#define DEFERRED

#include "/lib/all_the_libs.glsl"

in vec2 texcoord;
flat in vec3 LightColorDirect; // This needs to be initialized in the vertex stage of the pass

#include "/generic/water.glsl"
#include "/generic/shadow/main.glsl"
#include "/generic/lighting.fsh"
#include "/generic/sky.glsl"
#include "/generic/shadow/vl.glsl"
#include "/generic/fog.glsl"
#include "/generic/reflections.glsl"
#include "/generic/shadow/rsm.glsl"
#include "/generic/post/taa.glsl"

/* DRAWBUFFERS:03 */
layout(location = 0) out vec4 Color;
layout(location = 1) out vec4 GISpatial;

// Taken from spectrum: https://github.com/zombye/spectrum
vec3 refract2(vec3 I, vec3 N, vec3 NF, float eta) {
    float NoI = dot(N, I);
    float k = 1.0 - eta * eta * (1.0 - NoI * NoI);
    if (k < 0.0) {
        return vec3(0.0);
    } else {
        float sqrtk = sqrt(k);
        vec3 R = (eta * dot(NF, I) + sqrtk) * NF - (eta * NoI + sqrtk) * N;
        return normalize(R * sqrt(abs(NoI)) + eta * I);
    }
}

void main() {
    float Depth = texture(depthtex0, texcoord).x;
    vec3 ScreenPos = vec3(texcoord, Depth);
    vec3 ViewPos = screen_view(ScreenPos, true);
    vec3 ViewPosN = normalize(ViewPos);
    vec3 PlayerPos = view_player(ViewPos);
    vec3 PlayerPosN = normalize(PlayerPos);
    bool IsHand = Depth <= 0.56;
    if (IsHand) {
        Depth = Depth * 2 - 1;
        Depth /= MC_HAND_DEPTH;
        Depth = Depth * 0.5 + 0.5;
    }

    if (Depth < 1) {
        vec4 Data = texture(colortex1, texcoord);
        vec4 Data2 = texture(colortex2, texcoord);
        vec2 UnpackX = unpackUnorm2x8(Data.x);
        vec2 UnpackY = unpackUnorm2x8(Data.y);
        float Material = UnpackY.y * 255;
        vec3 Normal = decodeUnitVector(unpackUnorm2x8(Data.w) * 2 - 1);
        Normal = player_view(Normal);
        vec3 FlatNormal = decodeUnitVector(unpackUnorm2x8(Data2.w) * 2 - 1);
        FlatNormal = player_view(FlatNormal);

        vec3 ViewPosN = normalize(ViewPos);

        float Depth1 = texture(depthtex1, texcoord).x;
        vec3 ViewPos1 = screen_view(vec3(ScreenPos.xy, Depth1), true);
        if (Depth != Depth1 && Depth1 < 1) {
            vec3 RefractedDir = refract2(ViewPosN, Normal, FlatNormal, 0.7518);

            vec3 RefractedPos = ViewPos1 + RefractedDir * distance(ViewPos, ViewPos1);
            vec3 ScreenPosRef = view_screen(RefractedPos, true);

            vec4 NewDepths = textureGather(depthtex1, ScreenPosRef.xy, 0);
            float NewDepthClosest = min_component(NewDepths);
            if (NewDepthClosest < Depth) ScreenPosRef = ScreenPos;
            else {
                Depth1 = lerp(NewDepths.x, NewDepths.y, NewDepths.z, NewDepths.w, ScreenPosRef.xy);
                ViewPos1 = screen_view(vec3(ScreenPos.xy, Depth1), true);
            }

            Color = texture(colortex0, ScreenPosRef.xy);
        }
        else {
            Color = texture(colortex0, ScreenPos.xy);
        }

        if (Material == MATERIAL_WATER && isEyeInWater == 0) {
            vec3 PlayerPos1 = view_player(ViewPos1);
            Color.rgb = do_water_vl(PlayerPos, PlayerPos1, PlayerPosN, Color.rgb, Depth1, 4);
        }

        float Smoothness = get_smoothness(ScreenPos.xy, Material);
        bool IsMetal, IsHardcodedMetal;
        mat2x3 F0 = get_f0(ScreenPos.xy, Material, Color.rgb, IsMetal, IsHardcodedMetal);
        vec2 Lightmap = unpackUnorm2x8(Data2.x);

        // Reflections
        if (Smoothness > 0.3 && isEyeInWater == 0) {
            vec3 ReflectionBlendFactor = vec3(Smoothness);
            if (IsMetal) {
                vec3 Albedo = vec3(UnpackX, UnpackY.x);
                ReflectionBlendFactor *= fresnel_metals(Normal, -ViewPosN, F0) * Albedo;
            }
            else {
                ReflectionBlendFactor *= schlick(Normal, -ViewPosN, F0[0]);
            }

            Color.rgb += calc_reflections(ViewPos, ViewPosN, ScreenPos, Normal, ReflectionBlendFactor, Lightmap.y, IsHand);
        }

        // Specular
        vec3 Shadow = get_shadow(PlayerPos, FlatNormal, Material, Lightmap.y, false);
        if (Shadow != vec3(0)) {
            vec3 H = normalize(sLightPosN - ViewPosN); // Half-way vector
            vec3 F;
            if (IsHardcodedMetal) {
                F = fresnel_metals(H, -ViewPosN, F0) * Color.rgb;
            }
            else {
                F = schlick(H, -ViewPosN, F0[0]);
            }
            vec3 Specular = cook_torrance(-ViewPosN, sLightPosN, Normal, smoothness_to_roughness(Smoothness), H, F);
            float NdotL = max(dot(sLightPosN, Normal), 0);
            Color.rgb += Specular * LightColorDirect * NdotL * Shadow;
        }

        if (!IsHand) {
            float GTAO = gtao(ScreenPos, ViewPos, ViewPosN, Normal);
            vec3 RSM = rsm(PlayerPos, Normal, LightColorDirect);
            //float GTAO = ssao(Color.rgb, Normal, ViewPos);
            GISpatial = vec4(RSM, GTAO);
        }
    }
    else {
        Color = texture(colortex0, texcoord);
    }

    if (Depth >= 1 || IsHand) {
        GISpatial = vec4(0);
    }
}
