#include "/lib/all_the_libs.glsl"

flat in vec3 LightColorDirect; // This needs to be initialized in the vertex stage of the pass

#include "/generic/water.glsl"
#include "/generic/shadow/main.glsl"
#include "/generic/shadow/rsm.glsl"
#include "/generic/shadow/vl.glsl"
#include "/generic/sky.glsl"
#include "/generic/fog.glsl"

in vec2 texcoord;

/* DRAWBUFFERS:0 */
layout(location = 0) out vec4 Color;

void main() {
    Color = texture(colortex0, texcoord);
    float Depth = texture(depthtex0, texcoord).x;
    vec3 ScreenPos = vec3(texcoord, Depth);
    vec3 ViewPos = screen_view(ScreenPos, true);
    vec3 ViewPosN = normalize(ViewPos);
    vec3 PlayerPos = view_player(ViewPos);
    vec3 PlayerPosN = normalize(PlayerPos);

    if (Depth > 0.56) {
        if (Depth < 1) {
            vec4 Data = texture(colortex1, texcoord);
            vec2 UnpackX = unpackUnorm2x8(Data.x);
            vec2 UnpackY = unpackUnorm2x8(Data.y);

            vec4 GISpatial = gi_denoise(colortex3, ivec2(gl_FragCoord.xy), ivec2(0, 1), Depth);
            float Material = UnpackY.y * 255;

            vec3 Albedo = vec3(UnpackX, UnpackY.x);
            Albedo.rgb = pow(Albedo.rgb, vec3(2.2));

            Color.rgb *= 1 - GISpatial.a; // Apply AO
            Color.rgb += GISpatial.rgb * Albedo; // Apply GI
        }

        vec3 SkyColor = get_sky(ViewPosN, false, PlayerPosN.y);
        Color.rgb = get_fog_main(PlayerPos, Color.rgb, Depth, SkyColor);

        Color.rgb = do_vl(vec3(0), PlayerPos, PlayerPosN, Color.rgb, Depth, 12);
    }
}
