#define DEFERRED

in vec2 texcoord;

flat in vec3 LightColorDirect;

#include "/lib/all_the_libs.glsl"
#include "/generic/water.glsl"
#include "/generic/fog.glsl"
#include "/generic/shadow/main.glsl"
#include "/generic/lighting.fsh"
#include "/generic/sky.glsl"
#include "/generic/clouds.glsl"

void main() {
    float Depth = texture(depthtex0, texcoord).r;
    bool IsHand = Depth <= 0.56;
    if (IsHand) {
        Depth = Depth * 2 - 1;
        Depth /= MC_HAND_DEPTH;
        Depth = Depth * 0.5 + 0.5;
    }
    vec3 ScreenPos = vec3(texcoord, Depth);
    vec3 ViewPos = screen_view(ScreenPos, true);
    vec3 ViewPosN = normalize(ViewPos);
    vec3 PlayerPos = view_player(ViewPos);
    vec3 PlayerPosN = normalize(PlayerPos);

    float Dither = dither(gl_FragCoord.xy);

    vec3 Color;
    if (Depth == 1) {
        Color = get_sky(ViewPosN, true, PlayerPosN.y);
        Color = do_clouds(PlayerPos, PlayerPosN, Color, 8);
    }
    else {
        vec4 Data = texture(colortex1, texcoord);
        vec4 Data2 = texture(colortex2, texcoord);

        vec2 UnpackX = unpackUnorm2x8(Data.x);
        vec2 UnpackY = unpackUnorm2x8(Data.y);

        vec3 Albedo = vec3(UnpackX, UnpackY.x);
        Albedo.rgb = pow(Albedo.rgb, vec3(2.2));
        float Material = UnpackY.y * 255;
        vec2 Lightmap = unpackUnorm2x8(Data2.x);
        vec3 Normal = decodeUnitVector(unpackUnorm2x8(Data.w) * 2 - 1);
        Normal = player_view(Normal);
        vec3 FlatNormal = decodeUnitVector(unpackUnorm2x8(Data2.w) * 2 - 1);
        FlatNormal = player_view(FlatNormal);
        vec2 Unpack2Z = unpackUnorm2x8(Data2.z);
        float PackSSS = Unpack2Z.x, Emissiveness = Unpack2Z.y;
        Color = calc_lighting(texcoord, Albedo, Material, PackSSS, Emissiveness, Lightmap, Normal, FlatNormal, ViewPos, ScreenPos, PlayerPos, IsHand);
    }

    /* DRAWBUFFERS:0 */
    gl_FragData[0] = vec4(Color, 1.0); //colortex0
}
