#include "/lib/all_the_libs.glsl"
#include "/generic/water.glsl"
in vec2 texcoord;
in vec4 glcolor;

flat in vec3 Normal;
flat in uint Material;

in vec3 PlayerPos;

/* DRAWBUFFERS:01 */
layout(location = 0) out vec4 Color;
layout(location = 1) out vec4 ShadowNormal;

void main() {
    Color = texture(texture, texcoord) * glcolor;
    if (Color.a < 0.1) {
        discard;
        return;
    }

    if (renderStage == MC_RENDER_STAGE_ENTITIES) { // Stop entities from contributing to RSM because it ruins temporal stability
        Color.rgb = vec3(0);
    }
    else {
        if (Material == MATERIAL_WATER) {
            Color.rgb = vec3(1);
            // This is how water is detected later
            Color.a = 1;
        }
    }

    ShadowNormal.rg = encodeUnitVector(Normal) * 0.5 + 0.5;
}
