#include "/lib/all_the_libs.glsl"
#include "/generic/water.glsl"
in vec2 texcoord;
/* DRAWBUFFERS:0 */
layout(location = 0) out vec4 Color;

void main() {
    Color = texture(shadowcolor0, texcoord);
    if (Color.a == 1) { // Is water
        float Depth = texture(shadowtex0, texcoord).x;
        float Depth1 = texture(shadowtex1, texcoord).x;
        if (Depth != Depth1) {
            vec3 ShadowPosUndistorted = undistort(vec3(texcoord, Depth) * 2 - 1);

            vec3 NDCPos = vec3(ShadowPosUndistorted);
            vec3 NDCPos1 = vec3(ShadowPosUndistorted.xy, (Depth1 * 2 - 1) / 0.2);
            vec3 ViewPos = project_and_divide(shadowProjectionInverse, NDCPos);
            vec3 ViewPos1 = project_and_divide(shadowProjectionInverse, NDCPos1);

            float WaterFog = exp(-distance(ViewPos, ViewPos1) * 0.5);
            //Color.rgb = mix(vec3(1), Color.rgb, max(1-WaterFog, 0));
        }
    }
}
