
# -> If player is a ghost then return
execute if entity @s[tag=OverlyRealistic.Player.IsGhost] run \
    return run \
        effect give @s blindness 7 0 true

# -> If player is a level 5 blacksmith then speed up furnaces
execute if score @s OverlyRealistic.Player.WisdomStats.Blacksmithing matches 5 run \
    function overly_realistic:players/wisdom/blacksmithing/actions/detect_furnaces

# -> If player is moving with a map, on RNG, award intelligence
execute if score @s OverlyRealistic.Player.WalkOneCm matches 10000.. \
    if items entity @s weapon.* filled_map run \
        function overly_realistic:players/misc/cartography/int_gain_from_explore
execute if score @s OverlyRealistic.Player.SprintOneCm matches 12000.. \
    if items entity @s weapon.* filled_map run \
        function overly_realistic:players/misc/cartography/int_gain_from_explore

# -> If temperature is less than 20 then do white smokey breath particles
execute if score @s OverlyRealistic.Player.Stats.Temperature matches ..19 \
    anchored eyes run \
        particle minecraft:snowflake ^ ^ ^0.35 0 0 0 0.00001 3 normal @a

# -> If temperature is over 85 then do sweat particles
execute if score @s OverlyRealistic.Player.Stats.Temperature matches 86.. run \
    particle minecraft:falling_water ~ ~1 ~ 0.2 0.5 0.2 0.1 2 normal @a

# -> If player is at 0 stamina and swimming then damage
execute if score @s OverlyRealistic.Player.Stats.Stamina matches 0 \
    if predicate overly_realistic:player/actions/player_is_swimming run \
        function overly_realistic:players/stamina/damage_on_water

# --> Mental health operations

# -> Do operations
function overly_realistic:players/mental_health/mental_health_looping_operate

# --> Hygiene operations

# -> Reset vars
scoreboard players set #or.global OverlyRealistic.General.ArbitraryData 0

# -> Outside check
execute if score @s OverlyRealistic.PredicateValue.IsExposedToSkyLight matches 1 \
    if score #or.WorldTime OverlyRealistic.General.ArbitraryData matches 13000..23460 run \
        scoreboard players add #or.global OverlyRealistic.General.ArbitraryData 15

# -> Dirtyness check
execute if items entity @s weapon.* #overly_realistic:dirty_blocks run \
    scoreboard players add #or.global OverlyRealistic.General.ArbitraryData 10
execute if block ~ ~-1 ~ #overly_realistic:dirty_blocks \
    unless items entity @s armor.feet * run \
        scoreboard players add #or.global OverlyRealistic.General.ArbitraryData 15

# -> Blood check
execute if entity @n[type=block_display,tag=OverlyRealistic.GroundBloodSplatter,distance=..10] run \
    scoreboard players add #or.global OverlyRealistic.General.ArbitraryData 15

# -> Swamp check
execute if biome ~ ~ ~ #overly_realistic:swamps run \
    scoreboard players add #or.global OverlyRealistic.General.ArbitraryData 8

# -> No-armor check
execute unless items entity @s armor.* * run \
    scoreboard players add #or.global OverlyRealistic.General.ArbitraryData 20

# -> Function tag
function #overly_realistic:mechanics/player_hygiene_value_operate

# -> RNG check
execute store result score #or.global OverlyRealistic.Player.Stats.Hygiene run \
    random value 0..100
execute if score @s OverlyRealistic.Player.Stats.Hygiene matches 1.. \
    if score #or.global OverlyRealistic.General.ArbitraryData >= #or.global OverlyRealistic.Player.Stats.Hygiene run \
        function overly_realistic:players/hygiene/decrease_hygiene {amount: 1i}

# --> Intelligence attribute operations
attribute @s attack_damage modifier remove overly_realistic:low_intelligence_attack_damage_debuff
execute unless score @s OverlyRealistic.Player.Stats.Intelligence matches 70.. \
    if predicate overly_realistic:player/misc/intelligence_gain_general_rng run \
        attribute @s attack_damage modifier add overly_realistic:low_intelligence_attack_damage_debuff -0.75 add_value

# --> Thirst operations

# -> Increase base thirst timer
scoreboard players add @s OverlyRealistic.Player.ThirstTimer 1

# -> If player is running then increase thirst timer
execute if score @s OverlyRealistic.PredicateValue.IsSprinting matches 1 run \
    scoreboard players add @s OverlyRealistic.Player.ThirstTimer 1

# -> If player is low on stamina then increase thirst timer
execute if score @s OverlyRealistic.Player.Stats.Stamina matches 0..4 run \
    scoreboard players add @s OverlyRealistic.Player.ThirstTimer 1

# -> If player has high body temperature then increase thirst timer
execute if score @s OverlyRealistic.Player.Stats.Temperature matches 78.. run \
    scoreboard players add @s OverlyRealistic.Player.ThirstTimer 2

# -> If player is ill then increase thirst timer
execute if entity @s[tag=OverlyRealistic.Player.IsSick] run \
    scoreboard players add @s OverlyRealistic.Player.ThirstTimer 1

# -> If player is bleeding then increase thirst timer
execute if score @s OverlyRealistic.Player.BleedingTimer matches 1.. run \
    scoreboard players add @s OverlyRealistic.Player.ThirstTimer 1

# -> If player is exposed to the sun then increase thirst timer
execute if score @s OverlyRealistic.PredicateValue.IsExposedToSkyLight matches 1.. \
    unless score #or.WorldTime OverlyRealistic.General.ArbitraryData matches 13000..23460 run \
        scoreboard players add @s OverlyRealistic.Player.ThirstTimer 1

# -> If timer hasnt reached its maximum then return
execute unless score @s OverlyRealistic.Player.ThirstTimer matches 230.. run \
    return fail

# -> Reset timer for new calculation
scoreboard players set @s OverlyRealistic.Player.ThirstTimer 1

# ----> Decrease thirst

# -> If player is running then increase new value
execute if score @s OverlyRealistic.PredicateValue.IsSprinting matches 1 run \
    scoreboard players add @s OverlyRealistic.Player.ThirstTimer 1

# -> If player is low on stamina then increase new value
execute if score @s OverlyRealistic.Player.Stats.Stamina matches 0..5 run \
    scoreboard players add @s OverlyRealistic.Player.ThirstTimer 1

# -> If player has high body temperature then increase new value
execute if score @s OverlyRealistic.Player.Stats.Temperature matches 70.. run \
    scoreboard players add @s OverlyRealistic.Player.ThirstTimer 2

# -> If player is ill then increase new value
execute if entity @s[tag=OverlyRealistic.Player.IsSick] run \
    scoreboard players add @s OverlyRealistic.Player.ThirstTimer 1

# -> If player is bleeding then increase new value
execute if score @s OverlyRealistic.Player.BleedingTimer matches 1.. run \
    scoreboard players add @s OverlyRealistic.Player.ThirstTimer 1

# -> If player is exposed to the sun then increase new value
execute if score @s OverlyRealistic.PredicateValue.IsExposedToSkyLight matches 1.. \
    unless score #or.WorldTime OverlyRealistic.General.ArbitraryData matches 13000..23460 run \
        scoreboard players add @s OverlyRealistic.Player.ThirstTimer 1

# -> If player is in a hot biome then increase new value
execute if biome ~ ~ ~ #overly_realistic:temperature_modifying/hot_biome run \
    scoreboard players add @s OverlyRealistic.Player.ThirstTimer 2

# -> Decrease thirst
scoreboard players operation @s OverlyRealistic.Player.Stats.Thirst -= @s OverlyRealistic.Player.ThirstTimer

# -> Function tag
function #overly_realistic:mechanics/player_thirst_value_operate

# -> Clamp
execute if score @s OverlyRealistic.Player.Stats.Thirst matches ..-1 run \
    scoreboard players set @s OverlyRealistic.Player.Stats.Thirst 0

# -> Reset timer
scoreboard players set @s OverlyRealistic.Player.ThirstTimer 0