
# -> If there is no water filled then return
execute unless block ~ ~ ~ barrier[waterlogged=true] run \
    return fail

# -> Sound
playsound minecraft:entity.boat.paddle_water block @a ~ ~ ~ 0.85 2

# -> Particle
particle falling_water ~ ~0.5 ~ 0.125 0 0.125 0.001 1 normal @a

# -> Rotation test
#execute as @n[type=block_display,tag=OverlyRealistic.Block.Basket,distance=..0.5] \
    on passengers \
    if entity @s[type=item_display] \
    at @s run \
        rotate @s ~10 ~

# -> Add onto stir amount
execute unless score @s OverlyRealistic.World.BasketStirAmount matches 20.. run \
    return run \
        scoreboard players add @s OverlyRealistic.World.BasketStirAmount 1

# -> Unless stir RNG passes, return
execute unless predicate overly_realistic:world/basket/basket_stir_success_rng run \
    return fail

# -> Cache items data into storage
data modify storage overly_realistic:temp_values temp_basket_items set from entity @s data.BasketItems

# --> Check recipes

# -> Kelp base
execute if data storage overly_realistic:temp_values \
    {temp_basket_items:\
        [\
            {id:"minecraft:kelp"},{id:"minecraft:kelp"},{id:"minecraft:kelp"},\
            {id:"minecraft:kelp"},{id:"minecraft:kelp"},{id:"minecraft:kelp"},\
            {id:"minecraft:kelp"},{id:"minecraft:kelp"},{id:"minecraft:kelp"}\
        ]\
    } run \
        return run \
            function overly_realistic:general/custom_blocks/basket/interactions/stir_interactions/create_kelp_base

# -> Poison base
execute if score @s OverlyRealistic.World.BasketBoilTime matches 100.. \
    if data storage overly_realistic:temp_values \
        {temp_basket_items:\
            [\
                {id:"minecraft:lily_of_the_valley"},{id:"minecraft:lily_of_the_valley"},{id:"minecraft:lily_of_the_valley"},\
                {id:"minecraft:rotten_flesh"},{id:"minecraft:rotten_flesh"},{id:"minecraft:rotten_flesh"},\
                {id:"minecraft:sweet_berries"},{id:"minecraft:pufferfish"},{id:"minecraft:spider_eye"}\
            ]\
        } run \
            return run \
                function overly_realistic:general/custom_blocks/basket/interactions/stir_interactions/create_poison_base

# -> Healing stew
execute if entity @s[tag=OverlyRealistic.Block.Basket_Status_HasKelpBase] \
    if score @s OverlyRealistic.World.BasketBoilTime matches 100.. \
    if data storage overly_realistic:temp_values \
        {temp_basket_items:\
            [\
                {id:"minecraft:suspicious_stew"},{id:"minecraft:beetroot"},{id:"minecraft:dried_kelp"},\
                {id:"minecraft:dandelion"},{id:"minecraft:brown_mushroom"},{id:"minecraft:cactus_flower"},\
                {id:"minecraft:sugar_cane"},{id:"minecraft:vine"},{id:"minecraft:cactus"}\
            ]\
        } run \
            return run \
                function overly_realistic:general/custom_blocks/basket/interactions/stir_interactions/create_healing_stew

# -> Sweet berry base
execute if data storage overly_realistic:temp_values \
    {temp_basket_items:\
        [\
            {id:"minecraft:sweet_berries"},{id:"minecraft:sweet_berries"},{id:"minecraft:sweet_berries"},\
            {id:"minecraft:sweet_berries"},{id:"minecraft:sweet_berries"},{id:"minecraft:sweet_berries"},\
            {id:"minecraft:sweet_berries"},{id:"minecraft:sweet_berries"},{id:"minecraft:sweet_berries"}\
        ]\
    } run \
        return run \
            function overly_realistic:general/custom_blocks/basket/interactions/stir_interactions/create_sweet_berry_base

# -> Meat stew
execute if entity @s[tag=OverlyRealistic.Block.Basket_Status_HasKelpBase] \
    if score @s OverlyRealistic.World.BasketBoilTime matches 100.. \
    if data storage overly_realistic:temp_values \
        {temp_basket_items:\
            [\
                {id:"minecraft:mushroom_stew"},{id:"minecraft:cooked_beef"},{id:"minecraft:cooked_chicken"},\
                {id:"minecraft:cooked_porkchop"},{id:"minecraft:brown_mushroom"},{id:"minecraft:red_mushroom"}\
            ]\
        } run \
            return run \
                function overly_realistic:general/custom_blocks/basket/interactions/stir_interactions/create_meat_stew

# -> Vegetable stew
execute if entity @s[tag=OverlyRealistic.Block.Basket_Status_HasKelpBase] \
    if score @s OverlyRealistic.World.BasketBoilTime matches 100.. \
    if data storage overly_realistic:temp_values \
        {temp_basket_items:\
            [\
                {id:"minecraft:mushroom_stew"},{id:"minecraft:kelp"},{id:"minecraft:vine"},\
                {id:"minecraft:beetroot"},{id:"minecraft:wheat_seeds"},{id:"minecraft:beetroot_seeds"},\
                {id:"minecraft:dandelion"},{id:"minecraft:brown_mushroom"},{id:"minecraft:sugar"},\
            ]\
        } run \
            return run \
                function overly_realistic:general/custom_blocks/basket/interactions/stir_interactions/create_vegetable_stew

# -> Poison arrows
execute if entity @s[tag=OverlyRealistic.Block.Basket_Status_HasPoisonBase] \
    if data storage overly_realistic:temp_values \
        {temp_basket_items:\
            [\
                {id:"minecraft:arrow"}\
            ]\
        } run \
            return run \
                function overly_realistic:general/custom_blocks/basket/interactions/stir_interactions/create_strong_poison_arrows
