# -> Code GREATLY inspired by (and all props to) Xanbelor's simple custom heal library which can be found here:   https://github.com/XanBelOr/Minecraft-Simple-Custom-Heal
# ----------------------------------------------------------------------------------------------------------------------------------------------------------------------- #

# -> Failsafe for removing attribute
attribute @s minecraft:max_health modifier remove overly_realistic:healplayer

# -> Get (PlayerHealth * 10,000)
scoreboard players operation @s OverlyRealistic.Player.LocalHealthValue = @s OverlyRealistic.Player.Health
scoreboard players operation @s OverlyRealistic.Player.LocalHealthValue *= #or.static_num_10000 OverlyRealistic.General.ArbitraryData

# -> Store max and current health values, reset heal attribute
scoreboard players operation @s OverlyRealistic.Player.RealHeal += @s OverlyRealistic.Player.PlayerHeal
execute store result score @s OverlyRealistic.Player.MaxHealth run attribute @s minecraft:max_health get 10000
scoreboard players operation @s OverlyRealistic.Player.CurrentHealth = @s OverlyRealistic.Player.LocalHealthValue

# -> Failsafe for if current health >= max health - exit the function if so
execute if score @s OverlyRealistic.Player.MaxHealth <= @s OverlyRealistic.Player.CurrentHealth run return run scoreboard players set @s OverlyRealistic.Player.RealHeal 0

# -> Calc for max health value
scoreboard players operation @s OverlyRealistic.Player.MaxHealth -= @s OverlyRealistic.Player.RealHeal
scoreboard players operation @s OverlyRealistic.Player.MaxHealth -= @s OverlyRealistic.Player.CurrentHealth

# -> If the healing amount would set the player to max health, simply set so
execute if score @s OverlyRealistic.Player.MaxHealth matches ..0 run return run effect give @s minecraft:instant_health 1 26 true

# -> Get player's max health and set attribute
execute store result storage overly_realistic:heal heal.healamount double -0.0001 run scoreboard players get @s OverlyRealistic.Player.MaxHealth
function overly_realistic:general/healing/heal_health with storage overly_realistic:heal heal

# -> Heal player and set IsHealed, used for adv trigger
effect give @s minecraft:instant_health 1 28 true
scoreboard players set @s OverlyRealistic.Player.IsHealed 1
