
# -> If player is a ghost then return
execute if entity @s[tag=OverlyRealistic.Player.IsGhost] run \
    return fail

# --> Get temperature

# -> If player has updated a temperature-modifier item in their inventory then operate
execute if entity @s[tag=OverlyRealistic.Player.InventoryChangedTemperatureModifier] run \
    function overly_realistic:players/armor/temperature_modifiers/add_temperature_modifier_from_armor

# -> Reset temperature
scoreboard players set @s OverlyRealistic.Player.Stats.Temperature 50

# -> Height checks (top to bottom of the world)
execute if entity @s[y=280,dy=99999] run \
    scoreboard players set #or.global OverlyRealistic.Player.Stats.Temperature -25
execute if entity @s[y=100,dy=99999] run \
    scoreboard players set #or.global OverlyRealistic.Player.Stats.Temperature -12
execute if entity @s[y=0,dy=28] run \
    scoreboard players set #or.global OverlyRealistic.Player.Stats.Temperature 12
execute if entity @s[y=-0,dy=-99999] run \
    scoreboard players set #or.global OverlyRealistic.Player.Stats.Temperature 25
scoreboard players operation @s OverlyRealistic.Player.Stats.Temperature += #or.global OverlyRealistic.Player.Stats.Temperature

# -> Campfire check
execute if entity @n[type=marker,tag=OverlyRealistic.CampfireBlock,distance=..5,scores={OverlyRealistic.World.CampfireFireTime=1..}] run \
    scoreboard players add @s OverlyRealistic.Player.Stats.Temperature 20

# -> Torch check
execute if entity @n[type=marker,tag=OverlyRealistic.TorchBlock,distance=..5] run \
    scoreboard players add @s OverlyRealistic.Player.Stats.Temperature 8

# -> Fire check
execute if predicate overly_realistic:player/temperature/is_in_fire run \
    scoreboard players add @s OverlyRealistic.Player.Stats.Temperature 70
execute if block ~ ~ ~ #campfires[lit=true] run \
    scoreboard players add @s OverlyRealistic.Player.Stats.Temperature 70

# -> Cold block check
execute if predicate overly_realistic:player/temperature/is_in_cold_block run \
    scoreboard players remove @s OverlyRealistic.Player.Stats.Temperature 10
execute if block ~ ~ ~ powder_snow run \
    scoreboard players remove @s OverlyRealistic.Player.Stats.Temperature 40
execute anchored eyes \
    if block ^ ^ ^ powder_snow run \
        scoreboard players remove @s OverlyRealistic.Player.Stats.Temperature 55

# -> Snow-specific cold block check
execute if block ~ ~ ~ #snow run \
    scoreboard players remove @s OverlyRealistic.Player.Stats.Temperature 12

# -> Biome checks
execute if biome ~ ~ ~ #overly_realistic:temperature_modifying/hot_biome run \
    scoreboard players add @s OverlyRealistic.Player.Stats.Temperature 20
execute if biome ~ ~ ~ #overly_realistic:temperature_modifying/freezing_biome run \
    scoreboard players remove @s OverlyRealistic.Player.Stats.Temperature 20

# -> Desert night time check
execute if biome ~ ~ ~ desert \
    if score #or.WorldTime OverlyRealistic.General.ArbitraryData matches 13000..23460 run \
        scoreboard players remove @s OverlyRealistic.Player.Stats.Temperature 40

# -> Time checks
execute if score #or.WorldTime OverlyRealistic.General.ArbitraryData matches 5000..8000 run \
    scoreboard players add @s OverlyRealistic.Player.Stats.Temperature 10
execute if score #or.WorldTime OverlyRealistic.General.ArbitraryData matches 13000..23460 run \
    scoreboard players remove @s OverlyRealistic.Player.Stats.Temperature 10

# -> Player outside check
scoreboard players set @s OverlyRealistic.PredicateValue.IsExposedToSkyLight 0
execute if predicate overly_realistic:player/temperature/is_outside run \
    scoreboard players set @s OverlyRealistic.PredicateValue.IsExposedToSkyLight 1
execute if score @s OverlyRealistic.PredicateValue.IsExposedToSkyLight matches 1 run \
    function overly_realistic:players/temperature/outside_check_operate

# -> Armor temperature modifier checks
scoreboard players operation @s OverlyRealistic.Player.Stats.Temperature += @s OverlyRealistic.Player.TemperatureModifier

# -> Holding a torch
execute if items entity @s weapon.* torch run \
    function overly_realistic:general/torches/player_hold_torch_15t

# -> Wetness
execute if score @s OverlyRealistic.Player.WetTime matches 1.. run \
    scoreboard players remove @s OverlyRealistic.Player.Stats.Temperature 6

# -> High body temp illness
execute if entity @s[tag=OverlyRealistic.Harsh_Illness.HigherBodyTemp] run \
    scoreboard players add @s OverlyRealistic.Player.Stats.Temperature 10

# -> Low body temp illness
execute if entity @s[tag=OverlyRealistic.Harsh_Illness.HigherBodyTemp] run \
    scoreboard players remove @s OverlyRealistic.Player.Stats.Temperature 10

# -> Function tag
function #overly_realistic:mechanics/player_temperature

# -> Clamp temperature value
execute if score @s OverlyRealistic.Player.Stats.Temperature matches ..-1 run \
    scoreboard players set @s OverlyRealistic.Player.Stats.Temperature 0
execute if score @s OverlyRealistic.Player.Stats.Temperature matches 101.. run \
    scoreboard players set @s OverlyRealistic.Player.Stats.Temperature 100

# -> Extreme temperature actions
execute unless score @s OverlyRealistic.Player.Stats.Temperature matches 1..99 run \
    function overly_realistic:players/temperature/extreme_temperature_actions
