
# -> If entity is a pig and aggro animals are enabled and hog RNG passes, return and operate
execute if entity @s[type=pig] \
    if score #or.setting.should_aggro_animals_spawn OverlyRealistic.Settings.ArbitrarySetting matches 1 \
    if predicate overly_realistic:animal/hog_spawn_rng run \
        return run \
            function overly_realistic:animals/hogs/pig_passed_as_hog

# -> Get randomized array entry
execute store result storage overly_realistic:temp_values generic_value_0 int 1 run \
    random value 0..9

# -> Apply genetics
function overly_realistic:animals/genetics/get_animal_genetics_entry with storage overly_realistic:temp_values

# -> Tag entity
tag @s add OverlyRealistic.CommonAnimalChecked

# -> Apply vars
execute store result score @s OverlyRealistic.Animal.Stamina run \
    random value 100..1500

# -> Apply modifiers
execute unless score #or.setting.nerfed_aggro_animals OverlyRealistic.Settings.ArbitrarySetting matches 1 run \
    attribute @s max_health modifier add overly_realistic:animal_default_max_health 60 add_value
attribute @s knockback_resistance modifier add overly_realistic:animal_default_knockback_resistance 0.25 add_value
attribute @s movement_speed modifier add overly_realistic:animal_default_movement_speed 0.035 add_value

# -> Apply modifiers for 'nerfed aggro animals'
execute if score #or.setting.nerfed_aggro_animals OverlyRealistic.Settings.ArbitrarySetting matches 1 run \
    attribute @s max_health modifier add overly_realistic:animal_default_max_health 10 add_value

effect give @s regeneration 3 255 true

# -> Set chicken nerf
execute if entity @s[type=chicken] run \
    function overly_realistic:animals/operations/chicken_nerf

# -> If aggro animals are disabled then return
execute if score #or.setting.should_aggro_animals_spawn OverlyRealistic.Settings.ArbitrarySetting matches 0 run \
    return fail

# -> Aggressiveness RNG
execute unless predicate overly_realistic:animal/common_animal_aggressive_rng run \
    return fail

# -> If animal is a baby then return
execute if predicate overly_realistic:animal/animal_is_baby run \
    return fail

# -> Nerfed aggro animals RNG
execute if score #or.setting.nerfed_aggro_animals OverlyRealistic.Settings.ArbitrarySetting matches 1 \
    unless predicate overly_realistic:animal/nerfed_aggro_animal_spawn_rng run \
        return fail

# -> Tag entity
tag @s add OverlyRealistic.CommonAnimalAggressive

# -> If entity is a wolf then set AngerTime
data modify entity @s[type=wolf] AngerTime set value 2147483647

# -> Apply modifiers
execute unless score #or.setting.nerfed_aggro_animals OverlyRealistic.Settings.ArbitrarySetting matches 1 run \
    attribute @s max_health modifier add overly_realistic:animal_aggressive_max_health 10 add_value
execute unless score #or.setting.nerfed_aggro_animals OverlyRealistic.Settings.ArbitrarySetting matches 1 run \
    attribute @s knockback_resistance modifier add overly_realistic:animal_aggressive_knockback_resistance 0.35 add_value
attribute @s movement_speed modifier add overly_realistic:animal_aggressive_movement_speed 0.1 add_value

# -> Create targeter entity
summon piglin_brute ~ ~ ~ {Silent:1b,Invulnerable:1b,CustomNameVisible:0b,DeathLootTable:"minecraft:empty",Team:"overly_realistic.targeters",PersistenceRequired:1b,IsImmuneToZombification:1b,Tags:["OverlyRealistic.TempEntity","OverlyRealistic.TargeterEntity"],CustomName:"Wild Animal",active_effects:[{id:"minecraft:invisibility",amplifier:0,duration:-1,show_particles:0b}],attributes:[{id:"minecraft:scale",base:0.0625}]}

# -> Targeter rider
ride @n[type=piglin_brute,tag=OverlyRealistic.TempEntity,dx=0,dy=0,dz=0] mount @s

# -> Untag entity
execute on vehicle run \
    tag @s remove OverlyRealistic.TempEntity

# -> Set chicken nerf
execute if entity @s[type=chicken] \
    on passengers \
    if entity @s[type=piglin_brute] run \
        attribute @s attack_damage modifier add overly_realistic:chicken_nerf_attack_damage -0.75 add_multiplied_total

# -> Reduce animal damage
execute unless score #or.setting.nerfed_aggro_animals OverlyRealistic.Settings.ArbitrarySetting matches 1 \
    unless entity @s[type=chicken] \
    on passengers \
    if entity @s[type=piglin_brute] run \
        attribute @s attack_damage modifier add overly_realistic:nerfed_aggro_animal_attack_damage -0.38 add_multiplied_total

# -> If 'nerfed aggro animals' is on then nerf attack damage
execute if score #or.setting.nerfed_aggro_animals OverlyRealistic.Settings.ArbitrarySetting matches 1 \
    on passengers \
    if entity @s[type=piglin_brute] run \
        attribute @s attack_damage modifier add overly_realistic:nerfed_aggro_animal_attack_damage -0.68 add_multiplied_total

# -> Get entity scale
execute store result score #or.equation_part_1 OverlyRealistic.General.ArbitraryData run \
    attribute @s scale get 100

# --> Smart fear RNG

# -> Small scaled animal
execute if score #or.equation_part_1 OverlyRealistic.General.ArbitraryData matches ..98 run \
    return run \
        execute if predicate overly_realistic:animal/animal_fear_smart_rng_small_animal run \
            tag @s add OverlyRealistic.Animal.SmartFearAggroAnimal

# -> Normal & big scaled animal
execute if predicate overly_realistic:animal/animal_fear_smart_rng_big_animal run \
    tag @s add OverlyRealistic.Animal.SmartFearAggroAnimal
