
# -> If player hasnt been given OverlyRealistic data then give it to them 
execute unless entity @s[tag=OverlyRealistic.Player.PlayerHasData] run \
    function overly_realistic:players/custom_data/apply_general_data_startup

# -> If player is a ghost then return
execute if entity @s[tag=OverlyRealistic.Player.IsGhost] run \
    return fail

# -> Set spawnpoint, if settings allow it
execute unless score #or.setting.do_normal_respawning OverlyRealistic.Settings.ArbitrarySetting matches 1 run \
    spawnpoint @s ~ ~ ~

# -> Check if player is wearing non-leather armor
attribute @s movement_speed modifier remove overly_realistic:default_armor_movement_speed
execute if items entity @s armor.* #overly_realistic:non_leather_armor run \
    attribute @s movement_speed modifier add overly_realistic:default_armor_movement_speed -0.0305 add_value

# -> Check if player is wearing boots
attribute @s movement_speed modifier remove overly_realistic:boots_movement_speed
execute if items entity @s armor.feet * run \
    attribute @s movement_speed modifier add overly_realistic:default_armor_movement_speed 0.01 add_value

# --> Illness operations

# -> Do illness operations if player is ill
execute if entity @s[tag=OverlyRealistic.Player.IsSick] run \
    function overly_realistic:players/illness/illness_operate

# --> Get stamina

# -> Reset global var
scoreboard players set #or.global OverlyRealistic.Player.Stats.Stamina 1

# -> If player is on water while not touching the ground or on a vehicle then decrease stamina
execute if block ~ ~ ~ water \
    if predicate overly_realistic:player/actions/player_can_decrease_stamina_in_water run \
        scoreboard players remove @s OverlyRealistic.Player.Stats.Stamina 2

# -> Sprint check
execute if predicate overly_realistic:player/actions/player_is_sprinting \
    unless entity @s[gamemode=creative,predicate=overly_realistic:player/actions/player_is_flying] run \
        function overly_realistic:players/stamina/player_sprinting

# -> Jump check
execute if score @s OverlyRealistic.Player.Jumps matches 1.. run \
    function overly_realistic:players/stamina/player_jumped

# -> Function tag
function #overly_realistic:mechanics/player_stamina

# -> Calculate stamina
scoreboard players operation @s OverlyRealistic.Player.Stats.Stamina += #or.global OverlyRealistic.Player.Stats.Stamina

# -> Clamp stamina
execute if score @s OverlyRealistic.Player.Stats.Stamina matches ..-1 run \
    scoreboard players set @s OverlyRealistic.Player.Stats.Stamina 0
execute if score @s OverlyRealistic.Player.Stats.Stamina >= @s OverlyRealistic.Player.Stats.MaxStamina run \
    scoreboard players operation @s OverlyRealistic.Player.Stats.Stamina = @s OverlyRealistic.Player.Stats.MaxStamina

# -> Exhaust player
execute if score @s OverlyRealistic.Player.Stats.Stamina matches 0 \
    unless entity @s[tag=OverlyRealistic.Player.IsExhausted] run \
        function overly_realistic:players/stamina/player_exhaust

# -> Normalize player
execute if score @s OverlyRealistic.Player.Stats.Stamina matches 1.. \
    if entity @s[tag=OverlyRealistic.Player.IsExhausted] run \
        function overly_realistic:players/stamina/player_normalize

# -> If player stamina is below 3 then display sweat particles
execute if score @s OverlyRealistic.Player.Stats.Stamina matches ..2 run \
    particle minecraft:falling_water ~ ~1 ~ 0.2 0.5 0.2 0.1 1 normal @a

# -> If player is exhausted while swimming, on RNG, set downwards velocity
execute if entity @s[tag=OverlyRealistic.Player.IsExhausted,gamemode=!spectator] \
    if block ~ ~-1 ~ water \
    if predicate overly_realistic:player/misc/exhaustion_can_cause_downwards_velocity run \
        function overly_realistic:players/stamina/swim_exhaustion/apply_downwards_velocity

# --> Get status

# -> Store status value
execute store result storage overly_realistic:temp_values generic_value_0 int 1 run \
    scoreboard players get @s OverlyRealistic.Player.Stats.Status

# -> Set status data
function overly_realistic:players/status/set_status_data with storage overly_realistic:temp_values

# -> Function tag
function #overly_realistic:mechanics/player_status

# --> Status actionbar

# -> If player is downed then return
execute if entity @s[tag=OverlyRealistic.Player.IsDowned] run \
    return fail

# -> Compass
execute if items entity @s weapon.* compass run \
    return run \
        function overly_realistic:general/compass/get_rotation

# -> Normal
title @s actionbar [{"color":"#5BA34D","text":"☀ Temperature: "},{"color":"#5BA34D","score":{"name":"@s","objective":"OverlyRealistic.Player.Stats.Temperature"}},{"color":"#5BA34D","text":"/100  "},{"color":"#49A3A3","text":"⚡ Stamina: "},{"color":"#49A3A3","score":{"name":"@s","objective":"OverlyRealistic.Player.Stats.Stamina"}},{"color":"#49A3A3","text":"/"},{"color":"#49A3A3","score":{"name":"@s","objective":"OverlyRealistic.Player.Stats.MaxStamina"}},{"color":"#4B51A3","text":"  🧪 Thirst: "},{"color":"#4B51A3","score":{"name":"@s","objective":"OverlyRealistic.Player.Stats.Thirst"}},{"color":"#4B51A3","text":"/"},{"color":"#4B51A3","score":{"name":"#or.setting.max_thirst","objective":"OverlyRealistic.Settings.ArbitrarySetting"}},{"color":"#C263BF","text":"  ❤ Status: "},{"color":"#C263BF","nbt":"player_status","storage":"overly_realistic:player_stats"}]

#title @s actionbar [{"color":"#5BA34D","text":"☀ ᴛᴇᴍᴘᴇʀᴀᴛᴜʀᴇ: "},{"color":"#5BA34D","score":{"name":"@s","objective":"OverlyRealistic.Player.Stats.Temperature"}},{"color":"#5BA34D","text":"/100  "},{"color":"#49A3A3","text":"⚡ ꜱᴛᴀᴍɪɴᴀ: "},{"color":"#49A3A3","score":{"name":"@s","objective":"OverlyRealistic.Player.Stats.Stamina"}},{"color":"#49A3A3","text":"/"},{"color":"#49A3A3","score":{"name":"@s","objective":"OverlyRealistic.Player.Stats.MaxStamina"}},{"color":"#4B51A3","text":"  ♦ ᴛʜɪʀꜱᴛ: "},{"color":"#4B51A3","score":{"name":"@s","objective":"OverlyRealistic.Player.Stats.Thirst"}},{"color":"#4B51A3","text":"/"},{"color":"#4B51A3","score":{"name":"#or.setting.max_thirst","objective":"OverlyRealistic.Settings.ArbitrarySetting"}},{"color":"#C263BF","text":"  ❤ ꜱᴛᴀᴛᴜꜱ: "},{"color":"#C263BF","nbt":"player_status","storage":"overly_realistic:player_stats"}]
