
# -> If player is a ghost then return
execute if entity @s[tag=OverlyRealistic.Player.IsGhost] run \
    return fail

# -> If player has no carbs then decrease intelligence if possible
execute if score @s OverlyRealistic.Player.Stats.Carbs matches ..0 \
    if score @s OverlyRealistic.Player.Stats.Intelligence matches 1.. run \
        scoreboard players remove @s OverlyRealistic.Player.Stats.Intelligence 1

# --> Clothe dirtyness

# -> If player has clothes then add to clothes dirtyness
execute if items entity @s armor.* * run \
    scoreboard players add @s OverlyRealistic.Player.Stats.ClothesDirtyness 1

# -> If ClothesDirtyness >= max then set dirty clothes
execute unless score @s OverlyRealistic.Player.Stats.ClothesDirtyness matches 100.. run \
    function overly_realistic:players/armor/dirty_armor

# --> Mental health operations

# -> If player has low mental health then operate
execute if score @s OverlyRealistic.Player.Stats.MentalHealth matches ..18 run \
    function overly_realistic:players/mental_health/low_mental_health_actions

# --> Illness operations

# -> On RNG do return
execute if predicate overly_realistic:player/illness/do_illness_detection_rng run \
    return fail

# -> Reset vars
scoreboard players set @s OverlyRealistic.Player.Stats.IllnessChance 0

# -> Temperature check
execute unless score @s OverlyRealistic.Player.Stats.Temperature matches 15..85 run \
    scoreboard players add @s OverlyRealistic.Player.Stats.IllnessChance 15

# -> Thirst check
execute unless score @s OverlyRealistic.Player.Stats.Thirst matches 3.. run \
    scoreboard players add @s OverlyRealistic.Player.Stats.IllnessChance 8

# -> Hunger check
execute unless score @s OverlyRealistic.Player.Hunger matches 10.. run \
    scoreboard players add @s OverlyRealistic.Player.Stats.IllnessChance 6

# -> Health checks
execute unless score @s OverlyRealistic.Player.Health matches 15.. run \
    scoreboard players add @s OverlyRealistic.Player.Stats.IllnessChance 3
execute unless score @s OverlyRealistic.Player.Health matches 10.. run \
    scoreboard players add @s OverlyRealistic.Player.Stats.IllnessChance 8
execute unless score @s OverlyRealistic.Player.Health matches 5.. run \
    scoreboard players add @s OverlyRealistic.Player.Stats.IllnessChance 15

# -> Dirtyness checks
execute if block ~ ~-0.1 ~ #overly_realistic:dirty_blocks run \
    scoreboard players add @s OverlyRealistic.Player.Stats.IllnessChance 3
execute if items entity @s weapon.* #overly_realistic:dirty_blocks run \
    scoreboard players add @s OverlyRealistic.Player.Stats.IllnessChance 4

# -> Dirty clothes check
execute if items entity @s armor.* *[custom_data~{IsDirty:true}] run \
    scoreboard players add @s OverlyRealistic.Player.Stats.IllnessChance 3

# -> No-armor check
execute unless items entity @s armor.* * run \
    scoreboard players add @s OverlyRealistic.Player.Stats.IllnessChance 3

# -> Outside check
execute if predicate overly_realistic:player/temperature/is_outside \
    if predicate overly_realistic:world/time/is_night run \
        scoreboard players add @s OverlyRealistic.Player.Stats.IllnessChance 10

# -> Campfire check
execute if score @s OverlyRealistic.Player.Stats.Temperature matches 0..35 \
    unless entity @n[type=marker,tag=OverlyRealistic.CampfireBlock,scores={OverlyRealistic.World.CampfireFireTime=1..}] run \
        scoreboard players add @s OverlyRealistic.Player.Stats.IllnessChance 2

# -> Illness-inducing food checks
scoreboard players operation @s OverlyRealistic.Player.Stats.IllnessChance += @s OverlyRealistic.Player.FoodIllnessAmount
scoreboard players reset @s OverlyRealistic.Player.FoodIllnessAmount

# -> Low protein check
execute if score @s OverlyRealistic.Player.Stats.Proteins matches ..0 run \
    scoreboard players add @s OverlyRealistic.Player.Stats.IllnessChance 19

# -> Hygiene check
execute if score @s OverlyRealistic.Player.Stats.Hygiene matches 0..15 run \
    scoreboard players add @s OverlyRealistic.Player.Stats.IllnessChance 18

# -> Bleeding check
execute if score @s OverlyRealistic.Player.BleedingTimer matches 1.. run \
    scoreboard players add @s OverlyRealistic.Player.Stats.IllnessChance 30

# -> Nearby ill player check
execute if entity @p[tag=OverlyRealistic.Player.IsSick,distance=..5] run \
    scoreboard players add @s OverlyRealistic.Player.Stats.IllnessChance 6

# -> Function tag
function #overly_realistic:mechanics/player_get_illness_operate


# -> Illness RNG
execute store result score #or.global OverlyRealistic.General.ArbitraryData run \
    random value 9..200

# -> If RNG fails then return
execute unless score @s OverlyRealistic.Player.Stats.IllnessChance >= #or.global OverlyRealistic.General.ArbitraryData run \
    return fail

# -> Give player an illness
function overly_realistic:players/illness/get_illness
