
# -> Function tag
function #overly_realistic:internals/data_0_start

# ---> Gamerules
gamerule doImmediateRespawn true
gamerule doDaylightCycle false
gamerule doInsomnia false
gamerule snowAccumulationHeight 999
gamerule randomTickSpeed 1
gamerule waterSourceConversion false
gamerule naturalRegeneration false
gamerule reducedDebugInfo true
gamerule doTraderSpawning false
gamerule showDeathMessages false
gamerule locatorBar false
gamerule playersNetherPortalCreativeDelay 999999999
gamerule playersNetherPortalDefaultDelay 999999999
gamerule playersSleepingPercentage 110
gamerule doPatrolSpawning false

# ---> Vars

# -> Player stats
scoreboard objectives add OverlyRealistic.Player.Stats.Temperature dummy
scoreboard objectives add OverlyRealistic.Player.Stats.Stamina dummy
scoreboard objectives add OverlyRealistic.Player.Stats.MaxStamina dummy
scoreboard objectives add OverlyRealistic.Player.Stats.Temperature dummy
scoreboard objectives add OverlyRealistic.Player.Stats.Thirst dummy
scoreboard objectives add OverlyRealistic.Player.Stats.IllnessChance dummy
scoreboard objectives add OverlyRealistic.Player.Stats.Status dummy
scoreboard objectives add OverlyRealistic.Player.Stats.Hygiene dummy
scoreboard objectives add OverlyRealistic.Player.Stats.MentalHealth dummy
scoreboard objectives add OverlyRealistic.Player.Stats.ClothesDirtyness dummy
scoreboard objectives add OverlyRealistic.Player.Stats.Strength dummy
scoreboard objectives add OverlyRealistic.Player.Stats.Intelligence dummy
scoreboard objectives add OverlyRealistic.Player.Stats.Dizzyness dummy
scoreboard objectives add OverlyRealistic.Player.Stats.Carbs dummy
scoreboard objectives add OverlyRealistic.Player.Stats.Fats dummy
scoreboard objectives add OverlyRealistic.Player.Stats.Proteins dummy
scoreboard objectives add OverlyRealistic.Player.Stats.Speed dummy

# -> Player timers
scoreboard objectives add OverlyRealistic.Player.ExtremeTemperatureTimer dummy
scoreboard objectives add OverlyRealistic.Player.ThirstTimer dummy
scoreboard objectives add OverlyRealistic.Player.RegenTimer dummy
scoreboard objectives add OverlyRealistic.Player.IllnessTimer dummy
scoreboard objectives add OverlyRealistic.Player.MaxIllnessTimer dummy
scoreboard objectives add OverlyRealistic.Player.BleedingTimer dummy
scoreboard objectives add OverlyRealistic.Player.FallTime dummy
scoreboard objectives add OverlyRealistic.Player.WetTime dummy
scoreboard objectives add OverlyRealistic.Player.UnderwaterTime dummy
scoreboard objectives add OverlyRealistic.Player.SwimmingTime dummy
scoreboard objectives add OverlyRealistic.Player.IllnessCooldownTime dummy
scoreboard objectives add OverlyRealistic.Player.DeathTimer dummy
scoreboard objectives add OverlyRealistic.Player.NoThirstTimer dummy
scoreboard objectives add OverlyRealistic.Player.ShootingStarSightTimer dummy
scoreboard objectives add OverlyRealistic.Player.UseUnlitTorchTimer dummy
scoreboard objectives add OverlyRealistic.Player.UseBandageTimer dummy
scoreboard objectives add OverlyRealistic.Player.SprintTime custom:sprint_one_cm

# -> Player specialized
scoreboard objectives add OverlyRealistic.Player.Deaths deathCount
scoreboard objectives add OverlyRealistic.Player.DeathID dummy
scoreboard objectives add OverlyRealistic.Player.Jumps custom:jump
scoreboard objectives add OverlyRealistic.Player.ExhaustionCounter dummy
scoreboard objectives add OverlyRealistic.Player.UsedGlassBottle used:glass_bottle
scoreboard objectives add OverlyRealistic.Player.DrankPotion used:potion
scoreboard objectives add OverlyRealistic.Player.Health health
scoreboard objectives add OverlyRealistic.Player.Hunger food
scoreboard objectives add OverlyRealistic.Player.UsedGoatHorn used:minecraft.goat_horn
scoreboard objectives add OverlyRealistic.Player.StrengthTimer dummy
scoreboard objectives add OverlyRealistic.Player.WalkOneCm custom:walk_one_cm
scoreboard objectives add OverlyRealistic.Player.SprintOneCm custom:sprint_one_cm
scoreboard objectives add OverlyRealistic.Player.UsedChickenSpawn used:chicken_spawn_egg
scoreboard objectives add OverlyRealistic.Player.UsedDonkeySpawn used:donkey_spawn_egg
scoreboard objectives add OverlyRealistic.Player.UsedCreeperSpawn used:creeper_spawn_egg
scoreboard objectives add OverlyRealistic.Player.UsedParrotSpawn used:parrot_spawn_egg
scoreboard objectives add OverlyRealistic.Player.UsedAllaySpawn used:allay_spawn_egg

# -> Player primary
scoreboard objectives add OverlyRealistic.Player.PlayerHeal dummy
scoreboard objectives add OverlyRealistic.Player.RealHeal dummy
scoreboard objectives add OverlyRealistic.Player.IsHealed dummy
scoreboard objectives add OverlyRealistic.Player.CurrentHealth dummy
scoreboard objectives add OverlyRealistic.Player.MaxHealth dummy
scoreboard objectives add OverlyRealistic.Player.LogStripTime dummy
scoreboard objectives add OverlyRealistic.Player.FootstepSide dummy
scoreboard objectives add OverlyRealistic.Player.UsingSpearTime_Old dummy
scoreboard objectives add OverlyRealistic.Player.UsingSpearTime_New dummy
scoreboard objectives add OverlyRealistic.Player.UsingSpearID dummy
scoreboard objectives add OverlyRealistic.Player.FoodIllnessAmount dummy
scoreboard objectives add OverlyRealistic.Player.AnvilForgingHammerHits dummy

# -> Animals
scoreboard objectives add OverlyRealistic.Animal.Stamina dummy
scoreboard objectives add OverlyRealistic.Animal.Exhaustion dummy

# -> World
scoreboard objectives add OverlyRealistic.World.CampfireFireTime dummy
scoreboard objectives add OverlyRealistic.World.CampfireRainCooldown dummy
scoreboard objectives add OverlyRealistic.World.BlockItemAmount dummy
scoreboard objectives add OverlyRealistic.World.BasketStirAmount dummy
scoreboard objectives add OverlyRealistic.World.BasketBoilTime dummy
scoreboard objectives add OverlyRealistic.World.BasketSweetBerryFermentationTime dummy

scoreboard objectives add OverlyRealistic.General.ArbitraryData dummy

# --> Setting vars

# -> Settings holders
scoreboard objectives add OverlyRealistic.Settings.ArbitrarySetting dummy
scoreboard objectives add OverlyRealistic.Settings.Action trigger

# -> Do normal respawning
execute unless score #or.setting.do_normal_respawning OverlyRealistic.Settings.ArbitrarySetting matches 1.. run \
    scoreboard players set #or.setting.do_normal_respawning OverlyRealistic.Settings.ArbitrarySetting 0

# -> Max thirst
execute unless score #or.setting.max_thirst OverlyRealistic.Settings.ArbitrarySetting matches 1.. run \
    scoreboard players set #or.setting.max_thirst OverlyRealistic.Settings.ArbitrarySetting 10

# -> Base regen time
execute unless score #or.setting.base_regen_time OverlyRealistic.Settings.ArbitrarySetting matches 0.. run \
    scoreboard players set #or.setting.base_regen_time OverlyRealistic.Settings.ArbitrarySetting 5

# -> Max ground blood time
execute unless score #or.setting.max_ground_blood_time OverlyRealistic.Settings.ArbitrarySetting matches 0.. run \
    scoreboard players set #or.setting.max_ground_blood_time OverlyRealistic.Settings.ArbitrarySetting 25

# -> Max available player slots
execute unless score #or.setting.max_available_player_slots OverlyRealistic.Settings.ArbitrarySetting matches 0.. run \
    scoreboard players set #or.setting.max_available_player_slots OverlyRealistic.Settings.ArbitrarySetting 250

# -> Base available player slots
execute unless score #or.setting.base_available_player_slots OverlyRealistic.Settings.ArbitrarySetting matches 0.. run \
    scoreboard players set #or.setting.base_available_player_slots OverlyRealistic.Settings.ArbitrarySetting 10

# -> Should aggro animals spawn
execute unless score #or.setting.should_aggro_animals_spawn OverlyRealistic.Settings.ArbitrarySetting matches 0.. run \
    scoreboard players set #or.setting.should_aggro_animals_spawn OverlyRealistic.Settings.ArbitrarySetting 1

# -> Current player slots
execute unless score #or.setting.current_player_slots OverlyRealistic.General.ArbitraryData matches 0.. run \
    scoreboard players set #or.setting.current_player_slots OverlyRealistic.General.ArbitraryData 0

# -> Disable genetics
execute unless score #or.setting.disable_genetics OverlyRealistic.General.ArbitraryData matches 1.. run \
    scoreboard players set #or.setting.disable_genetics OverlyRealistic.Settings.ArbitrarySetting 0

# -> Nerfed aggro animals
execute unless score #or.setting.nerfed_aggro_animals OverlyRealistic.General.ArbitraryData matches 1.. run \
    scoreboard players set #or.setting.nerfed_aggro_animals OverlyRealistic.Settings.ArbitrarySetting 0

# -> If DoNormalRespawning is true then reset doImmediateRespawn
execute if score #or.setting.do_normal_respawning OverlyRealistic.Settings.ArbitrarySetting matches 1 run \
    gamerule doImmediateRespawn false

# ---> Teams

# -> Targeters
team add overly_realistic.targeters
team modify overly_realistic.targeters nametagVisibility never

# -> Players
team add overly_realistic.players
team modify overly_realistic.players friendlyFire true
team modify overly_realistic.players nametagVisibility hideForOwnTeam
team modify overly_realistic.players seeFriendlyInvisibles false

# ---> Storages

# -> Create version changes
function overly_realistic:main/update_changes/version_change_create with storage overly_realistic:general

# -> Set version
data merge storage overly_realistic:general \
    {\
        version_string: "v1.3.9", \
        version_id: 7 \
    }

# -> Spawn attribute modifiers
data modify storage overly_realistic:player_attributes spawn_modifiers set value \
    {\
        entity_block_interaction_range:\
            [\
                1.5, \
                1.25, \
                0.55, \
                0.35, \
                0, \
                -0.1, \
                -0.15, \
                -0.35, \
                -0.48, \
                -0.78, \
            ],\
        \
        movement_speed:\
            [\
                0.00025, \
                0.00015, \
                0.000045, \
                0.00003, \
                0, \
                -0.003, \
                -0.0075, \
                -0.011, \
                -0.018, \
                -0.04, \
            ],\
        \
        attack_damage:\
            [\
                1.0, \
                0.75, \
                0.455, \
                0.25, \
                0.1, \
                0, \
                -0.1, \
                -0.255, \
                -0.38, \
                -0.5, \
            ],\
        attack_speed:\
            [\
                1.0, \
                0.75, \
                0.5, \
                0.25, \
                0, \
                -0.18, \
                -0.45, \
                -0.85, \
                -1.0, \
                -1.1, \
            ],\
        block_break_speed:\
            [\
                0.01, \
                0.0065, \
                0.0025, \
                0.001, \
                0, \
                -0.01, \
                -0.02, \
                -0.025, \
                -0.03, \
                -0.038, \
            ],\
        sneaking_speed:\
            [\
                0.45, \
                0.255, \
                0.18, \
                0.1, \
                0, \
                -0.05, \
                -0.1, \
                -0.15, \
                -0.2, \
                -0.245, \
            ],\
        scale:\
            [\
                0.5, \
                0.35, \
                0.2, \
                0.1, \
                0, \
                -0.05, \
                -0.1, \
                -0.2, \
                -0.23, \
                -0.5, \
            ],\
        max_health:\
            [\
                5.0, \
                4.0, \
                2.0, \
                1.0, \
                0, \
                0, \
                -1.0, \
                -2.0, \
                -3.0, \
                -5.0, \
            ]\
    }


# -> Animal genetics attribute modifiers
data modify storage overly_realistic:animal_attributes animal_genetics_modifiers set value \
    {\
        scale:\
            [\
                0.45, \
                0.35, \
                0.25, \
                0.2, \
                0.15, \
                0.1, \
                0, \
                -0.05, \
                -0.1, \
                -0.15, \
            ],\
        \
    }

# -> Load data 1
schedule function overly_realistic:main/data/load_data_1 1t

# -> Function tag
function #overly_realistic:internals/data_0_end
