
# -> If entity is in the water then boost it
execute if block ~ ~ ~ water run \
    data modify entity @s[type=!hoglin] Motion[1] set value 0.3

# -> If there are no players nearby then return
execute unless entity @p[tag=!OverlyRealistic.Player.IsGhost,distance=..8] run \
    return fail

# -> If entity is smart, if there are 3+ players nearby, then de-aggro
execute if entity @s[tag=OverlyRealistic.Animal.SmartFearAggroAnimal] \
    if function overly_realistic:animals/operations/player_count_3_smart_fear run \
        return run \
            function overly_realistic:animals/operations/aggro_flee

# -> If entity has the tribal fear trait, if there are 3+ tribal-mask-wearing players nearby, then de-aggro
execute if entity @s[tag=OverlyRealistic.Animal.TribalFearAggroAnimal] \
    if function overly_realistic:animals/operations/player_count_3_tribal_fear run \
        return run \
            function overly_realistic:animals/operations/aggro_flee

# -> Get entity health
execute store result score #or.animal_health_current OverlyRealistic.General.ArbitraryData run \
    data get entity @s Health

# -> Get 1/3rd health value
scoreboard players operation #or.low_animal_health OverlyRealistic.General.ArbitraryData = @s OverlyRealistic.Animal.MaxHealth
scoreboard players operation #or.low_animal_health OverlyRealistic.General.ArbitraryData /= #or.static_num_3 OverlyRealistic.General.ArbitraryData

# -> Debug
#tellraw @a [{text:"hp: "},{score:{name:"#or.animal_health_current",objective:"OverlyRealistic.General.ArbitraryData"}}]
#tellraw @a [{text:"hp 1/3: "},{score:{name:"#or.low_animal_health",objective:"OverlyRealistic.General.ArbitraryData"}}]

# -> If animal health <= 1/3rd animal health then return and pacify it
execute if score #or.animal_health_current OverlyRealistic.General.ArbitraryData <= #or.low_animal_health OverlyRealistic.General.ArbitraryData run \
    return run \
        function overly_realistic:animals/operations/aggro_flee

# -> Get half health value
scoreboard players operation #or.half_animal_health OverlyRealistic.General.ArbitraryData = @s OverlyRealistic.Animal.MaxHealth
scoreboard players operation #or.half_animal_health OverlyRealistic.General.ArbitraryData /= #or.static_num_2 OverlyRealistic.General.ArbitraryData

# -> Debug
#tellraw @a [{text:"hp: "},{score:{name:"#or.animal_health_current",objective:"OverlyRealistic.General.ArbitraryData"}}]
#tellraw @a [{text:"hp 1/2: "},{score:{name:"#or.half_animal_health",objective:"OverlyRealistic.General.ArbitraryData"}}]

# -> If animal health <= 25 and there are >= 4 players nearby then return and flee
execute if score #or.animal_health_current OverlyRealistic.General.ArbitraryData <= #or.half_animal_health OverlyRealistic.General.ArbitraryData \
    if function overly_realistic:animals/operations/player_count_4 run \
    return run \
        function overly_realistic:animals/operations/aggro_flee

# -> Attack nearby players
execute positioned ~-1 ~ ~-1 run \
    damage @p[tag=!OverlyRealistic.Player.IsGhost,dx=1,dy=2,dz=1] 2 mob_attack by @s from @s
