
# -> Reset adv trigger
advancement revoke @s only overly_realistic:player/player_tick

# -> If player is on spectator then return
execute if entity @s[gamemode=spectator] run \
    return fail

# -> Operate on held items if needed
execute if items entity @s weapon.* #overly_realistic:player_editable_held_items run \
    function overly_realistic:players/misc/held_item_edit/edit_item_general

# -> If player is using a spear then operate
execute if entity @s[tag=OverlyRealistic.Player.IsUsingSpear] run \
    function overly_realistic:players/misc/spear/spear_operate

# -> If player is a deity then return and operate accordingly
execute if entity @s[tag=OverlyRealistic.Player.IsDeity] run \
    return run \
        function overly_realistic:general/godhood/deity_ticked

# -> If player is sprinting then operate
execute if predicate overly_realistic:player/actions/player_is_sprinting run \
    function overly_realistic:players/sprinting/player_is_sprinting

# -> Remove XP
xp set @s 0 levels
xp set @s 0 points

# -> Check if player is holding a reach-increasing item
attribute @s entity_interaction_range modifier remove overly_realistic:default_weapon_entity_interaction_range
execute if items entity @s weapon.mainhand #overly_realistic:adds_to_player_reach run \
    attribute @s entity_interaction_range modifier add overly_realistic:default_weapon_entity_interaction_range 0.5 add_value

# -> Check if player used a glass bottle
execute if score @s OverlyRealistic.Player.UsedGlassBottle matches 1.. \
    if items entity @s weapon.* potion run \
        function overly_realistic:players/thirst/used_glass_bottle

# -> Check if player who was previously in water is out of the water
execute if entity @s[tag=OverlyRealistic.Player.IsInWater] \
    anchored eyes \
    positioned ^ ^ ^ \
    anchored feet \
    unless block ~ ~ ~ water run \
        function overly_realistic:players/misc/water/player_got_off_water

# -> Check if player is in water
execute anchored eyes \
    positioned ^ ^ ^ \
    anchored feet \
    if block ~ ~ ~ water run \
        tag @s add OverlyRealistic.Player.IsInWater

# -> Check if player is falling
execute if score @s OverlyRealistic.Player.FallTime matches 1.. \
    unless predicate overly_realistic:player/actions/player_is_falling run \
        function overly_realistic:players/water_fall_damage/player_fell
execute if predicate overly_realistic:player/actions/player_is_falling run \
    scoreboard players add @s OverlyRealistic.Player.FallTime 10000

# -> If player is standing on leaves then fall
#execute if predicate overly_realistic:player/misc/standing_on_leaves run \
    tp ~ ~-0.01 ~

# -> If player is standing on a lilypad then break it
execute if predicate overly_realistic:player/misc/standing_on_lilypad run \
    function overly_realistic:players/misc/water/break_lilypad

# -> If player is deaf then remove sounds
stopsound @s[tag=OverlyRealistic.Player.IsDeaf]

# -> Wet checks
execute if block ~ ~ ~ water \
    unless predicate overly_realistic:global/entity_is_on_vehicle run \
        scoreboard players add @s OverlyRealistic.Player.WetTime 4
execute anchored eyes \
    if block ^ ^ ^ water run \
        scoreboard players add @s OverlyRealistic.Player.WetTime 4
execute if score @s OverlyRealistic.Player.WetTime matches 1201.. run \
    scoreboard players set @s OverlyRealistic.Player.WetTime 1200

# -> Decrease WetTime
scoreboard players remove @s OverlyRealistic.Player.WetTime 1
execute unless score @s OverlyRealistic.Player.WetTime matches 0.. run \
    scoreboard players set @s OverlyRealistic.Player.WetTime 0

# --> (@NOTE: DEPRECATED)

# -> Check for drinking water
#execute if score @s[tag=OverlyRealistic.Player.IsHoldingWater] OverlyRealistic.Player.DrankPotion matches 1.. run \
    function overly_realistic:players/thirst/drank_liquid

# -> Check for player holding water
#tag @s remove OverlyRealistic.Player.IsHoldingWater
#execute if items entity @s weapon.* potion[potion_contents={potion:"water"}] run \
    tag @s add OverlyRealistic.Player.IsHoldingWater