/*
 * Decompiled with CFR 0.152.
 */
package timmychips.pommelheldmodels;

import com.mojang.logging.LogUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5272;
import net.minecraft.class_811;
import org.slf4j.Logger;
import timmychips.pommelheldmodels.ShieldHasBanner;
import timmychips.pommelheldmodels.StackIsEnchanted;
import timmychips.pommelheldmodels.UseKeyTracker;
import timmychips.pommelheldmodels.objects.GroundItemSubmerged;
import timmychips.pommelheldmodels.objects.PredicateRenderModeMap;

@Environment(value=EnvType.CLIENT)
public class HeldItemPredicate {
    public static class_811 currentItemRenderMode;
    public static boolean itemInOffhand;
    public static boolean isProjectile;
    public static final Logger LOGGER;
    private static final String namespace = "pommel";
    private static final String render_held = "is_held";
    private static final String render_first_thirdperson = "first_third_person";
    private static final String render_misc_entity_holding = "is_misc_entity_holding";
    private static final String render_offhand = "is_offhand";
    private static final String render_fixed = "is_fixed";
    private static final String render_ground = "is_ground";
    private static final String render_projectile = "is_projectile";
    private static final String render_head = "is_head";
    private static final String render_using = "is_using";
    private static final String render_submerged = "is_submerged";
    private static final String render_use = "item_use";
    private static final String render_enchanted = "is_enchanted";
    private static final String render_shield_banner = "shield_has_banner";
    private static final List<class_811> renderModeHands;
    private static final List<class_811> renderModeThird;
    private static final List<class_811> renderAny;
    public static final PredicateRenderModeMap predicateMap;

    public static void predicateWhitelistMap() {
        predicateMap.addToMap(render_held, renderModeHands);
        predicateMap.addToMap(render_offhand, renderModeHands);
        predicateMap.addToMap(render_using, renderAny);
        predicateMap.addToMap(render_submerged, renderModeHands);
        predicateMap.addToMap(render_fixed, class_811.field_4319);
        predicateMap.addToMap(render_ground, class_811.field_4318);
        predicateMap.addToMap(render_projectile, class_811.field_4318);
        predicateMap.addToMap(render_head, class_811.field_4316);
        predicateMap.addToMap(render_first_thirdperson, renderModeHands);
        predicateMap.addToMap(render_misc_entity_holding, class_811.field_4318);
        predicateMap.addToMap(render_use, renderAny);
        predicateMap.addToMap(render_enchanted, renderAny);
        predicateMap.addToMap(render_shield_banner, renderAny);
    }

    public static void registerHeldModelPredicate() {
        HeldItemPredicate.predicateWhitelistMap();
        for (Map.Entry<class_2960, List<class_811>> entry : PredicateRenderModeMap.PREDICATE_RENDER_MODE_MAP.entrySet()) {
            class_5272.method_27881((class_2960)entry.getKey(), (itemStack, world, livingEntity, i) -> {
                String predicate = ((class_2960)entry.getKey()).method_12832();
                if (predicate.equals(render_enchanted)) {
                    return StackIsEnchanted.getValue(itemStack);
                }
                if (predicate.equals(render_shield_banner)) {
                    return ShieldHasBanner.getValue(itemStack);
                }
                if (livingEntity != null) {
                    switch (predicate) {
                        case "is_using": {
                            return HeldItemPredicate.matchesItemInHand(livingEntity, itemStack) ? UseKeyTracker.playerUseItemKey(livingEntity, itemStack) : 0.0f;
                        }
                        case "is_submerged": {
                            return livingEntity.method_5869() ? 1.0f : 0.0f;
                        }
                        case "item_use": {
                            return HeldItemPredicate.itemUseRemaining(itemStack, livingEntity);
                        }
                    }
                }
                if (predicate.equals(render_submerged)) {
                    return GroundItemSubmerged.SUBMERGED_MAP.contains(itemStack) ? 1.0f : 0.0f;
                }
                if (currentItemRenderMode == null) {
                    return 0.0f;
                }
                boolean isItemEntity = itemStack.method_27319() instanceof class_1542;
                return switch (predicate) {
                    case render_offhand -> {
                        if (itemInOffhand && ((List)entry.getValue()).contains(currentItemRenderMode)) {
                            yield 1.0f;
                        }
                        yield 0.0f;
                    }
                    case render_first_thirdperson -> HeldItemPredicate.firstThirdPersonCheck();
                    case render_misc_entity_holding -> {
                        if (livingEntity != null && ((List)entry.getValue()).contains(currentItemRenderMode)) {
                            yield 1.0f;
                        }
                        yield 0.0f;
                    }
                    case render_projectile -> {
                        if (isProjectile && !isItemEntity && livingEntity == null) {
                            isProjectile = false;
                            yield 1.0f;
                        }
                        yield 0.0f;
                    }
                    case render_ground -> {
                        if (isItemEntity && livingEntity == null && ((List)entry.getValue()).contains(currentItemRenderMode)) {
                            yield 1.0f;
                        }
                        yield 0.0f;
                    }
                    default -> ((List)entry.getValue()).contains(currentItemRenderMode) ? 1.0f : 0.0f;
                };
            });
        }
    }

    public static boolean matchesItemInHand(class_1309 entity, class_1799 stack) {
        class_1799 currentItem = entity.method_6047().method_7960() ? entity.method_6079() : entity.method_6047();
        return stack.toString().equals(currentItem.toString());
    }

    private static float firstThirdPersonCheck() {
        if (currentItemRenderMode.method_29998()) {
            return 0.5f;
        }
        if (renderModeThird.contains(currentItemRenderMode)) {
            return 1.0f;
        }
        return 0.0f;
    }

    private static float itemUseRemaining(class_1799 stack, class_1309 user) {
        if (user != null && class_1799.method_7973((class_1799)stack, (class_1799)user.method_6030())) {
            int maxUseTime = stack.method_7935(user);
            return (float)(maxUseTime - user.method_6014()) / (float)maxUseTime;
        }
        return 0.0f;
    }

    static {
        itemInOffhand = false;
        isProjectile = false;
        LOGGER = LogUtils.getLogger();
        renderModeHands = Arrays.asList(class_811.field_4321, class_811.field_4322, class_811.field_4323, class_811.field_4320);
        renderModeThird = Arrays.asList(class_811.field_4323, class_811.field_4320);
        renderAny = Arrays.asList(class_811.field_4321, class_811.field_4322, class_811.field_4323, class_811.field_4320, class_811.field_4316, class_811.field_4319, class_811.field_4318, class_811.field_4317);
        predicateMap = new PredicateRenderModeMap(namespace);
    }
}

