/*
 * Decompiled with CFR 0.152.
 */
package timmychips.pommelheldmodels;

import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_742;
import net.minecraft.class_746;
import org.slf4j.Logger;
import timmychips.pommelheldmodels.HeldItemPredicate;
import timmychips.pommelheldmodels.PommelNetworking;
import timmychips.pommelheldmodels.objects.PlayerHeldItem;

@Environment(value=EnvType.CLIENT)
public class UseKeyTracker {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static class_1799 itemUsed = class_1799.field_8037;
    private static boolean useKeyPressed = false;
    public static final HashMap<class_1657, PlayerHeldItem> itemMap = new HashMap();

    public static void clientUseKey() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1687 != null) {
                class_746 user = class_310.method_1551().field_1724;
                class_304 useKey = class_310.method_1551().field_1690.field_1904;
                useKeyPressed = useKey.method_1434();
                if (user != null) {
                    class_1799 class_17992 = itemUsed = user.method_6047().method_7960() ? user.method_6079() : user.method_6047();
                }
                if (useKeyPressed && !itemUsed.method_7960()) {
                    class_1799 defaultStack = itemUsed.method_7909().method_7854();
                    itemMap.put((class_1657)user, new PlayerHeldItem(defaultStack));
                }
            }
        });
        ClientTickEvents.END_WORLD_TICK.register(world -> {
            for (class_742 player : world.method_18456()) {
                UseKeyTracker.useTickInterval((class_1309)player);
            }
        });
    }

    public static void eventUseKeyPacket() {
        UseItemCallback.EVENT.register((user, world, hand) -> {
            if (!world.field_9236) {
                UUID playerUuid = user.method_5667();
                class_1792 itemUsed = user.method_5998(hand).method_7909();
                class_1799 defaultStack = itemUsed.method_7854();
                class_2540 buf = new class_2540(Unpooled.buffer());
                buf.method_10797(playerUuid);
                buf.method_10793(defaultStack);
                buf.writeBoolean(true);
                if (!defaultStack.method_7960()) {
                    for (class_1657 otherPlayer : world.method_18456()) {
                        if (otherPlayer.method_5667().equals(playerUuid)) continue;
                        ServerPlayNetworking.send((class_3222)((class_3222)otherPlayer), (class_2960)PommelNetworking.USE_KEY_S2C_ID, (class_2540)buf);
                    }
                }
            }
            return class_1271.method_22430((Object)user.method_5998(hand));
        });
    }

    public static void receiveUseKeyPacket() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PommelNetworking.USE_KEY_S2C_ID, (client, handler, buf, responseSender) -> {
            UUID senderUuid = buf.method_10790();
            class_1799 itemStack = buf.method_10819();
            boolean isUsing = buf.readBoolean();
            if (client.field_1687 != null) {
                client.execute(() -> {
                    class_1657 sender = client.field_1687.method_18470(senderUuid);
                    if (sender != null && isUsing) {
                        itemMap.put(sender, new PlayerHeldItem(itemStack));
                    }
                });
            }
        });
    }

    public static void useTickInterval(class_1309 entity) {
        class_1657 player;
        if (entity instanceof class_1657 && itemMap.containsKey(player = (class_1657)entity)) {
            int intervalTick = UseKeyTracker.itemMap.get((Object)player).checkInterval;
            if (intervalTick > 0) {
                --intervalTick;
            }
            if (intervalTick == 0) {
                UseKeyTracker.afterUseCooldown(player);
            } else {
                UseKeyTracker.itemMap.get((Object)player).checkInterval = intervalTick;
            }
        }
    }

    public static void afterUseCooldown(class_1657 player) {
        float useTimer = UseKeyTracker.itemMap.get((Object)player).lastUsed;
        if (useTimer > 0.0f) {
            useTimer = HeldItemPredicate.matchesItemInHand((class_1309)player, UseKeyTracker.itemMap.get((Object)player).lastItem) ? (useTimer -= 1.0f) : 0.0f;
        }
        if (useTimer == 0.0f) {
            itemMap.remove(player);
        } else {
            UseKeyTracker.itemMap.get((Object)player).lastUsed = useTimer;
        }
    }

    private static boolean clientHasItemSelected(class_1309 livingEntity, class_1799 stack) {
        if (livingEntity instanceof class_746) {
            class_746 clientPlayer = (class_746)livingEntity;
            class_1799 currentStack = livingEntity.method_6047().method_7960() ? livingEntity.method_6079() : livingEntity.method_6047();
            return class_1799.method_7973((class_1799)currentStack, (class_1799)stack);
        }
        return true;
    }

    public static float playerUseItemKey(class_1309 livingEntity, class_1799 usableItem) {
        if (!livingEntity.method_31747()) {
            return 0.0f;
        }
        if (livingEntity.method_6115() && class_1799.method_7973((class_1799)livingEntity.method_6030(), (class_1799)usableItem)) {
            return 1.0f;
        }
        class_1657 player = (class_1657)livingEntity;
        float returnFloat = 0.0f;
        if (itemMap.containsKey(player)) {
            class_1799 lastItem = UseKeyTracker.itemMap.get((Object)player).lastItem;
            if (!UseKeyTracker.clientHasItemSelected((class_1309)player, usableItem)) {
                return 0.0f;
            }
            if (lastItem != null) {
                returnFloat = UseKeyTracker.itemMap.get((Object)player).lastUsed / 18.0f;
            }
        }
        return returnFloat;
    }
}

