/*
 * Decompiled with CFR 0.152.
 */
package com.economyshop999;

import com.economyshop999.EconomyShop999;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CustomItemCommand
implements CommandExecutor {
    private final EconomyShop999 plugin;

    public CustomItemCommand(EconomyShop999 plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("economyshop999.admin")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use custom item commands.");
            return true;
        }
        if (args.length == 0) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /customitem <add|scan> ...");
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "add": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /customitem add <id>");
                    return true;
                }
                String id = args[1];
                ItemStack itemInHand = player.getInventory().getItemInMainHand();
                if (itemInHand == null || itemInHand.getType().isAir()) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be holding an item to add it as a custom item.");
                    return true;
                }
                this.plugin.getCustomItemManager().saveCustomItem(id, itemInHand);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Custom item '" + id + "' saved.");
                break;
            }
            case "scan": {
                player.sendMessage(String.valueOf(ChatColor.RED) + "The /customitemscan command is not fully implemented yet. Please use /customitem add <id> to register custom items manually.");
                break;
            }
            default: {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Unknown subcommand. Usage: /customitem <add|scan>");
            }
        }
        return true;
    }
}

