/*
 * Decompiled with CFR 0.152.
 */
package com.economyshop999;

import com.economyshop999.EconomyShop999;
import com.economyshop999.ShopCategory;
import com.economyshop999.ShopItem;
import java.util.ArrayList;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

public class GuiListener
implements Listener {
    private final EconomyShop999 plugin;

    public GuiListener(EconomyShop999 plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        InventoryView view = event.getView();
        String title = view.getTitle();
        if (title.equals("Shop Categories")) {
            event.setCancelled(true);
            this.handleCategoryListClick(event);
        } else if (title.contains(" - Page ")) {
            event.setCancelled(true);
            if (title.startsWith("Search: ")) {
                this.handleSearchResultsPageClick(event);
            } else if (title.startsWith("Sell Items - ")) {
                this.handleSellingGuiClick(event);
            } else {
                this.handleCategoryPageClick(event);
            }
        } else if (title.equals("Buy Item")) {
            event.setCancelled(true);
            this.handleBuyGuiClick(event);
        }
    }

    private void handleCategoryListClick(InventoryClickEvent event) {
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType().isAir()) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        for (ShopCategory category : this.plugin.getShopManager().getCategories().values()) {
            if (event.getSlot() != category.getSlot()) continue;
            this.plugin.getGuiManager().openCategoryGui(player, category, 0);
            break;
        }
    }

    private void handleCategoryPageClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        String categoryName = title.substring(0, title.lastIndexOf(" - Page "));
        ShopCategory category = this.plugin.getShopManager().getCategories().values().stream().filter(c -> c.getName().equals(categoryName)).findFirst().orElse(null);
        if (category == null) {
            return;
        }
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType().isAir()) {
            return;
        }
        int currentPage = Integer.parseInt(title.substring(title.lastIndexOf(" ") + 1)) - 1;
        if (clickedItem.getType() == Material.ARROW) {
            if (clickedItem.getItemMeta().getDisplayName().contains("Next")) {
                this.plugin.getGuiManager().openCategoryGui(player, category, currentPage + 1);
            } else if (clickedItem.getItemMeta().getDisplayName().contains("Previous")) {
                this.plugin.getGuiManager().openCategoryGui(player, category, currentPage - 1);
            }
            return;
        }
        ShopItem shopItem = category.getItems().stream().filter(item -> item.getItemStack().isSimilar(clickedItem)).findFirst().orElse(null);
        if (shopItem != null) {
            this.plugin.getGuiManager().openBuyingGui(player, shopItem, 1);
        }
    }

    private void handleSearchResultsPageClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        String searchTerm = title.substring(title.indexOf(" ") + 1, title.lastIndexOf(" - Page "));
        int currentPage = Integer.parseInt(title.substring(title.lastIndexOf(" ") + 1)) - 1;
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType().isAir()) {
            return;
        }
        ArrayList<ShopItem> searchResults = new ArrayList<ShopItem>();
        for (ShopCategory cat : this.plugin.getShopManager().getCategories().values()) {
            for (ShopItem item2 : cat.getItems()) {
                if (!item2.getItemStack().getType().name().contains(searchTerm.toUpperCase())) continue;
                searchResults.add(item2);
            }
        }
        if (clickedItem.getType() == Material.ARROW) {
            if (clickedItem.getItemMeta().getDisplayName().contains("Next")) {
                this.plugin.getGuiManager().openSearchResultsGui(player, searchResults, searchTerm, currentPage + 1);
            } else if (clickedItem.getItemMeta().getDisplayName().contains("Previous")) {
                this.plugin.getGuiManager().openSearchResultsGui(player, searchResults, searchTerm, currentPage - 1);
            }
            return;
        }
        ShopItem shopItem = searchResults.stream().filter(item -> item.getItemStack().isSimilar(clickedItem)).findFirst().orElse(null);
        if (shopItem != null) {
            this.plugin.getGuiManager().openBuyingGui(player, shopItem, 1);
        }
    }

    private void handleSellingGuiClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        int currentPage = Integer.parseInt(title.substring(title.lastIndexOf(" ") + 1)) - 1;
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType().isAir()) {
            return;
        }
        if (clickedItem.getType() == Material.ARROW) {
            if (clickedItem.getItemMeta().getDisplayName().contains("Next")) {
                this.plugin.getGuiManager().openSellingGui(player, currentPage + 1);
            } else if (clickedItem.getItemMeta().getDisplayName().contains("Previous")) {
                this.plugin.getGuiManager().openSellingGui(player, currentPage - 1);
            }
            return;
        }
        ShopItem shopItem = this.plugin.getShopManager().getCategories().values().stream().flatMap(c -> c.getItems().stream()).filter(item -> item.getItemStack().isSimilar(clickedItem) && item.getSellPrice() > 0.0).findFirst().orElse(null);
        if (shopItem != null) {
            double sellPrice = shopItem.getSellPrice() * (double)clickedItem.getAmount();
            EconomyResponse response = this.plugin.getVaultHook().getEconomy().depositPlayer((OfflinePlayer)player, sellPrice);
            if (response.transactionSuccess()) {
                player.getInventory().removeItem(new ItemStack[]{clickedItem});
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have sold " + clickedItem.getAmount() + " " + clickedItem.getType().name() + " for " + sellPrice);
                this.plugin.getGuiManager().openSellingGui(player, currentPage);
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Error selling item: " + response.errorMessage);
            }
        }
    }

    private void handleBuyGuiClick(InventoryClickEvent event) {
        String displayName;
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType().isAir()) {
            return;
        }
        InventoryView view = event.getView();
        ItemStack itemInMiddle = view.getTopInventory().getItem(13);
        if (itemInMiddle == null) {
            return;
        }
        ShopItem shopItem = this.plugin.getShopManager().getCategories().values().stream().flatMap(c -> c.getItems().stream()).filter(item -> item.getItemStack().isSimilar(itemInMiddle)).findFirst().orElse(null);
        if (shopItem == null) {
            return;
        }
        int currentAmount = itemInMiddle.getAmount();
        switch (displayName = clickedItem.getItemMeta().getDisplayName()) {
            case "+1": {
                this.plugin.getGuiManager().openBuyingGui(player, shopItem, currentAmount + 1);
                break;
            }
            case "+5": {
                this.plugin.getGuiManager().openBuyingGui(player, shopItem, currentAmount + 5);
                break;
            }
            case "+10": {
                this.plugin.getGuiManager().openBuyingGui(player, shopItem, currentAmount + 10);
                break;
            }
            case "-1": {
                this.plugin.getGuiManager().openBuyingGui(player, shopItem, Math.max(1, currentAmount - 1));
                break;
            }
            case "-5": {
                this.plugin.getGuiManager().openBuyingGui(player, shopItem, Math.max(1, currentAmount - 5));
                break;
            }
            case "-10": {
                this.plugin.getGuiManager().openBuyingGui(player, shopItem, Math.max(1, currentAmount - 10));
                break;
            }
            case "Accept": {
                double totalPrice = shopItem.getBuyPrice() * (double)currentAmount;
                EconomyResponse response = this.plugin.getVaultHook().getEconomy().withdrawPlayer((OfflinePlayer)player, totalPrice);
                if (response.transactionSuccess()) {
                    ItemStack itemToGive = shopItem.getItemStack().clone();
                    itemToGive.setAmount(currentAmount);
                    player.getInventory().addItem(new ItemStack[]{itemToGive});
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have purchased " + currentAmount + " " + shopItem.getItemStack().getType().name() + " for " + totalPrice);
                } else {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have enough money to make this purchase.");
                }
                player.closeInventory();
                break;
            }
            case "Decline": {
                player.closeInventory();
            }
        }
    }
}

