/*
 * Decompiled with CFR 0.152.
 */
package com.economyshop999;

import com.economyshop999.EconomyShop999;
import com.economyshop999.ShopCategory;
import com.economyshop999.ShopItem;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GuiManager {
    private final EconomyShop999 plugin;

    public GuiManager(EconomyShop999 plugin) {
        this.plugin = plugin;
    }

    public void openMainShopGui(Player player) {
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)"Shop Categories");
        for (ShopCategory category : this.plugin.getShopManager().getCategories().values()) {
            ItemStack item = new ItemStack(category.getIcon());
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(category.getName());
            meta.setLore(Collections.singletonList(String.valueOf(ChatColor.GRAY) + "Click to browse this category"));
            item.setItemMeta(meta);
            gui.setItem(category.getSlot(), item);
        }
        player.openInventory(gui);
    }

    public void openCategoryGui(Player player, ShopCategory category, int page) {
        ItemMeta meta;
        String title = category.getName() + " - Page " + (page + 1);
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)title);
        List<ShopItem> items = category.getItems();
        int pageSize = 45;
        int startIndex = page * pageSize;
        int endIndex = Math.min(startIndex + pageSize, items.size());
        for (int i = startIndex; i < endIndex; ++i) {
            ShopItem shopItem = items.get(i);
            ItemStack itemStack = shopItem.getItemStack().clone();
            ItemMeta meta2 = itemStack.getItemMeta();
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            if (shopItem.getBuyPrice() > 0.0) {
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.GREEN) + "Buy: " + shopItem.getBuyPrice())));
            }
            if (shopItem.getSellPrice() > 0.0) {
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.RED) + "Sell: " + shopItem.getSellPrice())));
            }
            meta2.setLore(lore);
            itemStack.setItemMeta(meta2);
            gui.setItem(i - startIndex, itemStack);
        }
        if (page > 0) {
            ItemStack previous = new ItemStack(Material.ARROW);
            meta = previous.getItemMeta();
            meta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Previous Page");
            previous.setItemMeta(meta);
            gui.setItem(45, previous);
        }
        if (endIndex < items.size()) {
            ItemStack next = new ItemStack(Material.ARROW);
            meta = next.getItemMeta();
            meta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Next Page");
            next.setItemMeta(meta);
            gui.setItem(53, next);
        }
        player.openInventory(gui);
    }

    public void openBuyingGui(Player player, ShopItem shopItem, int amount) {
        Inventory gui = Bukkit.createInventory(null, (int)27, (String)"Buy Item");
        ItemStack item = shopItem.getItemStack().clone();
        item.setAmount(amount);
        ItemMeta itemMeta = item.getItemMeta();
        List lore = itemMeta.hasLore() ? itemMeta.getLore() : new ArrayList();
        lore.add(String.valueOf(ChatColor.GOLD) + "Total Cost: " + shopItem.getBuyPrice() * (double)amount);
        itemMeta.setLore(lore);
        item.setItemMeta(itemMeta);
        gui.setItem(13, item);
        gui.setItem(0, this.createControlButton(Material.GREEN_CONCRETE, "+1"));
        gui.setItem(1, this.createControlButton(Material.GREEN_STAINED_GLASS_PANE, "+5"));
        gui.setItem(2, this.createControlButton(Material.GREEN_STAINED_GLASS_PANE, "+10"));
        gui.setItem(6, this.createControlButton(Material.RED_STAINED_GLASS_PANE, "-1"));
        gui.setItem(7, this.createControlButton(Material.RED_STAINED_GLASS_PANE, "-5"));
        gui.setItem(8, this.createControlButton(Material.RED_STAINED_GLASS_PANE, "-10"));
        gui.setItem(22, this.createControlButton(Material.GREEN_CONCRETE, "Accept"));
        gui.setItem(26, this.createControlButton(Material.RED_CONCRETE, "Decline"));
        player.openInventory(gui);
    }

    public void openSearchResultsGui(Player player, List<ShopItem> results, String searchTerm, int page) {
        ItemMeta meta;
        String title = "Search: " + searchTerm + " - Page " + (page + 1);
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)title);
        int pageSize = 45;
        int startIndex = page * pageSize;
        int endIndex = Math.min(startIndex + pageSize, results.size());
        for (int i = startIndex; i < endIndex; ++i) {
            List lore;
            ShopItem shopItem = results.get(i);
            ItemStack itemStack = shopItem.getItemStack().clone();
            ItemMeta meta2 = itemStack.getItemMeta();
            List list = lore = meta2.hasLore() ? meta2.getLore() : new ArrayList();
            if (shopItem.getBuyPrice() > 0.0) {
                lore.add(String.valueOf(ChatColor.GREEN) + "Buy: " + shopItem.getBuyPrice());
            }
            if (shopItem.getSellPrice() > 0.0) {
                lore.add(String.valueOf(ChatColor.RED) + "Sell: " + shopItem.getSellPrice());
            }
            meta2.setLore(lore);
            itemStack.setItemMeta(meta2);
            gui.setItem(i - startIndex, itemStack);
        }
        if (page > 0) {
            ItemStack previous = new ItemStack(Material.ARROW);
            meta = previous.getItemMeta();
            meta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Previous Page");
            previous.setItemMeta(meta);
            gui.setItem(45, previous);
        }
        if (endIndex < results.size()) {
            ItemStack next = new ItemStack(Material.ARROW);
            meta = next.getItemMeta();
            meta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Next Page");
            next.setItemMeta(meta);
            gui.setItem(53, next);
        }
        player.openInventory(gui);
    }

    public void openSellingGui(Player player, int page) {
        ItemMeta meta;
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)("Sell Items - Page " + (page + 1)));
        ArrayList<ItemStack> sellableItems = new ArrayList<ItemStack>();
        for (ItemStack itemStack : player.getInventory().getContents()) {
            if (itemStack == null || itemStack.getType() == Material.AIR) continue;
            block1: for (ShopCategory category : this.plugin.getShopManager().getCategories().values()) {
                for (ShopItem shopItem : category.getItems()) {
                    if (shopItem.getItemStack().getType() != itemStack.getType() || !(shopItem.getSellPrice() > 0.0)) continue;
                    sellableItems.add(itemStack);
                    continue block1;
                }
            }
        }
        int pageSize = 45;
        int startIndex = page * pageSize;
        int endIndex = Math.min(startIndex + pageSize, sellableItems.size());
        for (int i = startIndex; i < endIndex; ++i) {
            ItemStack itemStack = (ItemStack)sellableItems.get(i);
            ShopItem shopItem = null;
            for (ShopCategory category : this.plugin.getShopManager().getCategories().values()) {
                for (ShopItem sItem : category.getItems()) {
                    if (sItem.getItemStack().getType() != itemStack.getType()) continue;
                    shopItem = sItem;
                    break;
                }
                if (shopItem == null) continue;
                break;
            }
            if (shopItem == null) continue;
            ItemStack displayItem = itemStack.clone();
            ItemMeta meta2 = displayItem.getItemMeta();
            List lore = meta2.hasLore() ? meta2.getLore() : new ArrayList();
            lore.add(String.valueOf(ChatColor.RED) + "Sell Price: " + shopItem.getSellPrice());
            lore.add(String.valueOf(ChatColor.GRAY) + "Click to sell this stack");
            meta2.setLore(lore);
            displayItem.setItemMeta(meta2);
            gui.setItem(i - startIndex, displayItem);
        }
        if (page > 0) {
            ItemStack previous = new ItemStack(Material.ARROW);
            meta = previous.getItemMeta();
            meta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Previous Page");
            previous.setItemMeta(meta);
            gui.setItem(45, previous);
        }
        if (endIndex < sellableItems.size()) {
            ItemStack next = new ItemStack(Material.ARROW);
            meta = next.getItemMeta();
            meta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Next Page");
            next.setItemMeta(meta);
            gui.setItem(53, next);
        }
        player.openInventory(gui);
    }

    private ItemStack createControlButton(Material material, String name) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        return item;
    }
}

