/*
 * Decompiled with CFR 0.152.
 */
package com.economyshop999;

import com.economyshop999.EconomyShop999;
import com.economyshop999.ShopCategory;
import com.economyshop999.ShopItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class ShopManager {
    private final EconomyShop999 plugin;
    private final Map<String, ShopCategory> categories = new HashMap<String, ShopCategory>();

    public ShopManager(EconomyShop999 plugin) {
        this.plugin = plugin;
    }

    public void loadCategories() {
        this.categories.clear();
        ConfigurationSection categorySection = this.plugin.getConfigManager().getConfig().getConfigurationSection("categories");
        if (categorySection == null) {
            this.plugin.getLogger().warning("No categories found in shop.yml!");
            return;
        }
        for (String key : categorySection.getKeys(false)) {
            String name = ChatColor.translateAlternateColorCodes((char)'&', (String)categorySection.getString(key + ".name", "Unnamed Category"));
            Material icon = Material.getMaterial((String)categorySection.getString(key + ".icon", "STONE"));
            int slot = categorySection.getInt(key + ".slot", 0);
            List itemStrings = categorySection.getStringList(key + ".items");
            ArrayList<ShopItem> items = new ArrayList<ShopItem>();
            for (String itemString : itemStrings) {
                String[] parts = itemString.split(" ");
                if (parts.length >= 3) {
                    try {
                        String itemIdentifier = parts[0];
                        double buyPrice = Double.parseDouble(parts[1]);
                        double sellPrice = Double.parseDouble(parts[2]);
                        ItemStack itemStack = null;
                        if (this.plugin.getCustomItemManager().getCustomItems().containsKey(itemIdentifier)) {
                            itemStack = this.plugin.getCustomItemManager().getCustomItem(itemIdentifier);
                        } else {
                            Material material = Material.getMaterial((String)itemIdentifier);
                            if (material != null) {
                                itemStack = new ItemStack(material);
                            }
                        }
                        if (itemStack != null) {
                            items.add(new ShopItem(itemStack, buyPrice, sellPrice));
                            continue;
                        }
                        this.plugin.getLogger().warning("Invalid item identifier or custom item not found: " + itemIdentifier);
                    }
                    catch (NumberFormatException e) {
                        this.plugin.getLogger().warning("Invalid price for item: " + itemString);
                    }
                    continue;
                }
                this.plugin.getLogger().warning("Invalid item format in shop.yml: " + itemString + ". Expected: ITEM_IDENTIFIER BUY_PRICE SELL_PRICE");
            }
            this.categories.put(key, new ShopCategory(name, icon, slot, items));
        }
    }

    public Map<String, ShopCategory> getCategories() {
        return this.categories;
    }

    public ShopCategory getCategory(String name) {
        return this.categories.get(name);
    }
}

