/*
 * Decompiled with CFR 0.152.
 */
package com.economyshop999;

import com.economyshop999.EconomyShop999;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class BalancesManager {
    private final EconomyShop999 plugin;
    private final File balancesFile;
    private FileConfiguration balancesConfig;
    private final HashMap<UUID, Double> balances;

    public BalancesManager(EconomyShop999 plugin, HashMap<UUID, Double> balances) {
        this.plugin = plugin;
        this.balances = balances;
        this.balancesFile = new File(plugin.getDataFolder(), "balances.yml");
        if (!this.balancesFile.exists()) {
            try {
                this.balancesFile.createNewFile();
            }
            catch (IOException e) {
                plugin.getLogger().severe("Could not create balances.yml!");
                e.printStackTrace();
            }
        }
        this.balancesConfig = YamlConfiguration.loadConfiguration((File)this.balancesFile);
        this.loadBalances();
    }

    private void loadBalances() {
        this.balances.clear();
        if (this.balancesConfig.isConfigurationSection("balances")) {
            for (String uuidString : this.balancesConfig.getConfigurationSection("balances").getKeys(false)) {
                try {
                    UUID uuid = UUID.fromString(uuidString);
                    double balance = this.balancesConfig.getDouble("balances." + uuidString);
                    this.balances.put(uuid, balance);
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("Invalid UUID found in balances.yml: " + uuidString);
                }
            }
        }
        this.plugin.getLogger().info("Loaded " + this.balances.size() + " player balances.");
    }

    public void saveBalances() {
        this.balancesConfig.set("balances", null);
        for (Map.Entry<UUID, Double> entry : this.balances.entrySet()) {
            this.balancesConfig.set("balances." + entry.getKey().toString(), (Object)entry.getValue());
        }
        try {
            this.balancesConfig.save(this.balancesFile);
            this.plugin.getLogger().info("Saved " + this.balances.size() + " player balances.");
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save balances.yml!");
            e.printStackTrace();
        }
    }
}

