/*
 * Decompiled with CFR 0.152.
 */
package com.economyshop999;

import com.economyshop999.EconomyShop999;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class CustomItemManager {
    private final EconomyShop999 plugin;
    private final File customItemsFile;
    private FileConfiguration customItemsConfig;
    private final Map<String, ItemStack> customItems = new HashMap<String, ItemStack>();

    public CustomItemManager(EconomyShop999 plugin) {
        this.plugin = plugin;
        this.customItemsFile = new File(plugin.getDataFolder(), "custom_items.yml");
        if (!this.customItemsFile.exists()) {
            try {
                this.customItemsFile.createNewFile();
            }
            catch (IOException e) {
                plugin.getLogger().severe("Could not create custom_items.yml!");
                e.printStackTrace();
            }
        }
        this.customItemsConfig = YamlConfiguration.loadConfiguration((File)this.customItemsFile);
        this.loadCustomItems();
    }

    public void loadCustomItems() {
        this.customItems.clear();
        if (this.customItemsConfig.getConfigurationSection("items") == null) {
            return;
        }
        for (String key : this.customItemsConfig.getConfigurationSection("items").getKeys(false)) {
            ItemStack item = this.customItemsConfig.getItemStack("items." + key);
            if (item == null) continue;
            this.customItems.put(key, item);
        }
    }

    public void saveCustomItem(String id, ItemStack item) {
        this.customItemsConfig.set("items." + id, (Object)item);
        try {
            this.customItemsConfig.save(this.customItemsFile);
            this.customItems.put(id, item);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save custom_items.yml!");
            e.printStackTrace();
        }
    }

    public ItemStack getCustomItem(String id) {
        return this.customItems.get(id);
    }

    public Map<String, ItemStack> getCustomItems() {
        return this.customItems;
    }

    public void reloadCustomItems() {
        this.customItemsConfig = YamlConfiguration.loadConfiguration((File)this.customItemsFile);
        this.loadCustomItems();
    }
}

