/*
 * Decompiled with CFR 0.152.
 */
package com.economyshop999;

import com.economyshop999.EconomyShop999;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;

public class EconomyShop999Economy
implements Economy {
    private final EconomyShop999 plugin;
    private final HashMap<UUID, Double> balances = new HashMap();

    public EconomyShop999Economy(EconomyShop999 plugin) {
        this.plugin = plugin;
    }

    public HashMap<UUID, Double> getBalances() {
        return this.balances;
    }

    public boolean isEnabled() {
        return this.plugin.isEnabled();
    }

    public String getName() {
        return "EconomyShop999";
    }

    public boolean hasBankSupport() {
        return false;
    }

    public int fractionalDigits() {
        return 2;
    }

    public String format(double amount) {
        return String.format("%.2f", amount);
    }

    public String currencyNamePlural() {
        return "dollars";
    }

    public String currencyNameSingular() {
        return "dollar";
    }

    public double getBalance(String playerName) {
        return this.getBalance(this.plugin.getServer().getOfflinePlayer(playerName));
    }

    public double getBalance(OfflinePlayer player) {
        return this.balances.getOrDefault(player.getUniqueId(), 0.0);
    }

    public double getBalance(String playerName, String worldName) {
        return this.getBalance(playerName);
    }

    public double getBalance(OfflinePlayer player, String worldName) {
        return this.getBalance(player);
    }

    public boolean has(String playerName, double amount) {
        return this.has(this.plugin.getServer().getOfflinePlayer(playerName), amount);
    }

    public boolean has(OfflinePlayer player, double amount) {
        return this.getBalance(player) >= amount;
    }

    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    public boolean has(OfflinePlayer player, String worldName, double amount) {
        return this.has(player, amount);
    }

    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        return this.withdrawPlayer(this.plugin.getServer().getOfflinePlayer(playerName), amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds");
        }
        double currentBalance = this.getBalance(player);
        if (currentBalance < amount) {
            return new EconomyResponse(0.0, currentBalance, EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
        }
        this.balances.put(player.getUniqueId(), currentBalance - amount);
        this.plugin.getBalancesManager().saveBalances();
        return new EconomyResponse(amount, this.getBalance(player), EconomyResponse.ResponseType.SUCCESS, null);
    }

    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.withdrawPlayer(player, amount);
    }

    public EconomyResponse depositPlayer(String playerName, double amount) {
        return this.depositPlayer(this.plugin.getServer().getOfflinePlayer(playerName), amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot deposit negative funds");
        }
        this.balances.put(player.getUniqueId(), this.getBalance(player) + amount);
        this.plugin.getBalancesManager().saveBalances();
        return new EconomyResponse(amount, this.getBalance(player), EconomyResponse.ResponseType.SUCCESS, null);
    }

    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.depositPlayer(player, amount);
    }

    public EconomyResponse createBank(String name, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "EconomyShop999 does not support bank accounts!");
    }

    public EconomyResponse createBank(String name, OfflinePlayer player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "EconomyShop999 does not support bank accounts!");
    }

    public EconomyResponse deleteBank(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "EconomyShop999 does not support bank accounts!");
    }

    public EconomyResponse bankBalance(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "EconomyShop999 does not support bank accounts!");
    }

    public EconomyResponse bankHas(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "EconomyShop999 does not support bank accounts!");
    }

    public EconomyResponse bankWithdraw(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "EconomyShop999 does not support bank accounts!");
    }

    public EconomyResponse bankDeposit(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "EconomyShop999 does not support bank accounts!");
    }

    public EconomyResponse isBankOwner(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "EconomyShop999 does not support bank accounts!");
    }

    public EconomyResponse isBankOwner(String name, OfflinePlayer player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "EconomyShop999 does not support bank accounts!");
    }

    public EconomyResponse isBankMember(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "EconomyShop999 does not support bank accounts!");
    }

    public EconomyResponse isBankMember(String name, OfflinePlayer player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "EconomyShop999 does not support bank accounts!");
    }

    public boolean hasAccount(String playerName) {
        return this.balances.containsKey(this.plugin.getServer().getOfflinePlayer(playerName).getUniqueId());
    }

    public boolean hasAccount(OfflinePlayer player) {
        return this.balances.containsKey(player.getUniqueId());
    }

    public boolean hasAccount(String playerName, String worldName) {
        return this.hasAccount(playerName);
    }

    public boolean hasAccount(OfflinePlayer player, String worldName) {
        return this.hasAccount(player);
    }

    public List<String> getBanks() {
        return Collections.emptyList();
    }

    public boolean createPlayerAccount(String playerName) {
        return this.createPlayerAccount(this.plugin.getServer().getOfflinePlayer(playerName));
    }

    public boolean createPlayerAccount(OfflinePlayer player) {
        if (!this.balances.containsKey(player.getUniqueId())) {
            this.balances.put(player.getUniqueId(), 0.0);
            this.plugin.getBalancesManager().saveBalances();
            return true;
        }
        return false;
    }

    public boolean createPlayerAccount(String playerName, String worldName) {
        return this.createPlayerAccount(playerName);
    }

    public boolean createPlayerAccount(OfflinePlayer player, String worldName) {
        return this.createPlayerAccount(player);
    }
}

