/*
 * Decompiled with CFR 0.152.
 */
package com.economyshop999;

import com.economyshop999.EconomyShop999;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class ShopAdminCommand
implements CommandExecutor {
    private final EconomyShop999 plugin;

    public ShopAdminCommand(EconomyShop999 plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!sender.hasPermission("economyshop999.admin")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use admin commands.");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /shopadmin <subcommand>");
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "reload": {
                this.plugin.getConfigManager().reloadConfig();
                this.plugin.getShopManager().loadCategories();
                this.plugin.getCustomItemManager().reloadCustomItems();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "EconomyShop999 configuration reloaded.");
                break;
            }
            case "add": {
                double sellPrice;
                double buyPrice;
                if (args.length < 5) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /shopadmin add <category> <item_identifier> <buy> <sell>");
                    return true;
                }
                String categoryName = args[1];
                String itemIdentifier = args[2];
                try {
                    buyPrice = Double.parseDouble(args[3]);
                    sellPrice = Double.parseDouble(args[4]);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Buy and sell prices must be numbers.");
                    return true;
                }
                ItemStack itemStack = null;
                if (this.plugin.getCustomItemManager().getCustomItems().containsKey(itemIdentifier)) {
                    itemStack = this.plugin.getCustomItemManager().getCustomItem(itemIdentifier);
                } else {
                    Material material = Material.getMaterial((String)itemIdentifier.toUpperCase());
                    if (material != null) {
                        itemStack = new ItemStack(material);
                    }
                }
                if (itemStack == null) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid item identifier. Must be a valid Material or a registered custom item ID.");
                    return true;
                }
                ConfigurationSection categorySection = this.plugin.getConfigManager().getConfig().getConfigurationSection("categories." + categoryName);
                if (categorySection == null) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Category '" + categoryName + "' not found.");
                    return true;
                }
                List items = categorySection.getStringList("items");
                items.add(itemIdentifier + " " + buyPrice + " " + sellPrice);
                categorySection.set("items", (Object)items);
                this.plugin.getConfigManager().saveConfig();
                this.plugin.getShopManager().loadCategories();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Item '" + itemIdentifier + "' added to category '" + categoryName + "'.");
                break;
            }
            case "remove": {
                if (args.length < 3) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /shopadmin remove <category> <item_identifier>");
                    return true;
                }
                String categoryName = args[1];
                String itemIdentifier = args[2];
                ConfigurationSection categorySection = this.plugin.getConfigManager().getConfig().getConfigurationSection("categories." + categoryName);
                if (categorySection == null) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Category '" + categoryName + "' not found.");
                    return true;
                }
                List currentItems = categorySection.getStringList("items");
                List updatedItems = currentItems.stream().filter(item -> !item.startsWith(itemIdentifier + " ")).collect(Collectors.toList());
                if (currentItems.size() == updatedItems.size()) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Item '" + itemIdentifier + "' not found in category '" + categoryName + "'.");
                    return true;
                }
                categorySection.set("items", updatedItems);
                this.plugin.getConfigManager().saveConfig();
                this.plugin.getShopManager().loadCategories();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Item '" + itemIdentifier + "' removed from category '" + categoryName + "'.");
                break;
            }
            case "setprice": {
                double sellPrice;
                double buyPrice;
                if (args.length < 5) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /shopadmin setprice <category> <item_identifier> <buy> <sell>");
                    return true;
                }
                String categoryName = args[1];
                String itemIdentifier = args[2];
                try {
                    buyPrice = Double.parseDouble(args[3]);
                    sellPrice = Double.parseDouble(args[4]);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Buy and sell prices must be numbers.");
                    return true;
                }
                ConfigurationSection categorySection = this.plugin.getConfigManager().getConfig().getConfigurationSection("categories." + categoryName);
                if (categorySection == null) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Category '" + categoryName + "' not found.");
                    return true;
                }
                List currentItems = categorySection.getStringList("items");
                boolean found = false;
                for (int i = 0; i < currentItems.size(); ++i) {
                    if (!((String)currentItems.get(i)).startsWith(itemIdentifier + " ")) continue;
                    currentItems.set(i, itemIdentifier + " " + buyPrice + " " + sellPrice);
                    found = true;
                    break;
                }
                if (!found) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Item '" + itemIdentifier + "' not found in category '" + categoryName + "'.");
                    return true;
                }
                categorySection.set("items", (Object)currentItems);
                this.plugin.getConfigManager().saveConfig();
                this.plugin.getShopManager().loadCategories();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Prices for item '" + itemIdentifier + "' in category '" + categoryName + "' updated.");
                break;
            }
            case "createcategory": {
                int slot;
                if (args.length < 4) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /shopadmin createcategory <name> <icon> <slot>");
                    return true;
                }
                String categoryName = args[1];
                String iconName = args[2].toUpperCase();
                try {
                    slot = Integer.parseInt(args[3]);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Slot must be a number.");
                    return true;
                }
                Material iconMaterial = Material.getMaterial((String)iconName);
                if (iconMaterial == null) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid icon material name.");
                    return true;
                }
                ConfigurationSection newCategorySection = this.plugin.getConfigManager().getConfig().createSection("categories." + categoryName);
                newCategorySection.set("name", (Object)categoryName);
                newCategorySection.set("icon", (Object)iconName);
                newCategorySection.set("slot", (Object)slot);
                newCategorySection.set("items", new ArrayList());
                this.plugin.getConfigManager().saveConfig();
                this.plugin.getShopManager().loadCategories();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Category '" + categoryName + "' created.");
                break;
            }
            case "deletecategory": {
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /shopadmin deletecategory <name>");
                    return true;
                }
                String categoryName = args[1];
                if (this.plugin.getConfigManager().getConfig().getConfigurationSection("categories." + categoryName) == null) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Category '" + categoryName + "' not found.");
                    return true;
                }
                this.plugin.getConfigManager().getConfig().set("categories." + categoryName, null);
                this.plugin.getConfigManager().saveConfig();
                this.plugin.getShopManager().loadCategories();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Category '" + categoryName + "' deleted.");
                break;
            }
            default: {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown subcommand. Usage: /shopadmin <reload|add|remove|setprice|createcategory|deletecategory>");
            }
        }
        return true;
    }
}

