/*
 * Decompiled with CFR 0.152.
 */
package com.economyshop999;

import com.economyshop999.EconomyShop999;
import com.economyshop999.ShopCategory;
import com.economyshop999.ShopItem;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ShopCommand
implements CommandExecutor {
    private final EconomyShop999 plugin;

    public ShopCommand(EconomyShop999 plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.plugin.getGuiManager().openMainShopGui(player);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "balance": {
                double balance = this.plugin.getEconomyProvider().getBalance((OfflinePlayer)player);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Your current balance is: " + String.valueOf(ChatColor.GOLD) + this.plugin.getEconomyProvider().format(balance));
                break;
            }
            case "reload": {
                if (!player.hasPermission("economyshop999.reload")) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
                    return true;
                }
                this.plugin.getConfigManager().reloadConfig();
                this.plugin.getShopManager().loadCategories();
                this.plugin.getCustomItemManager().reloadCustomItems();
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "EconomyShop999 configuration reloaded.");
                break;
            }
            case "price": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /shop price <item>");
                    return true;
                }
                Material material = Material.getMaterial((String)args[1].toUpperCase());
                if (material == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid item name.");
                    return true;
                }
                ShopItem foundItem = null;
                for (ShopCategory category : this.plugin.getShopManager().getCategories().values()) {
                    for (ShopItem item : category.getItems()) {
                        if (item.getItemStack().getType() != material) continue;
                        foundItem = item;
                        break;
                    }
                    if (foundItem == null) continue;
                    break;
                }
                if (foundItem != null) {
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "--- " + material.name() + " Prices ---");
                    if (foundItem.getBuyPrice() > 0.0) {
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Buy: " + String.valueOf(ChatColor.GOLD) + foundItem.getBuyPrice());
                    }
                    if (!(foundItem.getSellPrice() > 0.0)) break;
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Sell: " + String.valueOf(ChatColor.GOLD) + foundItem.getSellPrice());
                    break;
                }
                player.sendMessage(String.valueOf(ChatColor.RED) + "Item not found in any shop category.");
                break;
            }
            case "browse": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /shop browse <category>");
                    return true;
                }
                String categoryName = args[1];
                ShopCategory category = this.plugin.getShopManager().getCategory(categoryName);
                if (category != null) {
                    this.plugin.getGuiManager().openCategoryGui(player, category, 0);
                    break;
                }
                player.sendMessage(String.valueOf(ChatColor.RED) + "Category not found.");
                break;
            }
            case "search": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /shop search <item>");
                    return true;
                }
                String searchTerm = args[1].toUpperCase();
                ArrayList<ShopItem> searchResults = new ArrayList<ShopItem>();
                for (ShopCategory cat : this.plugin.getShopManager().getCategories().values()) {
                    for (ShopItem item : cat.getItems()) {
                        if (!item.getItemStack().getType().name().contains(searchTerm)) continue;
                        searchResults.add(item);
                    }
                }
                if (searchResults.isEmpty()) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "No items found matching your search term.");
                    break;
                }
                this.plugin.getGuiManager().openSearchResultsGui(player, searchResults, searchTerm, 0);
                break;
            }
            case "sell": {
                this.plugin.getGuiManager().openSellingGui(player, 0);
                break;
            }
            default: {
                this.plugin.getGuiManager().openMainShopGui(player);
            }
        }
        return true;
    }
}

