/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.botanypotstiers.common.impl;

import com.mojang.serialization.MapCodec;
import com.ultramega.botanypotstiers.common.impl.BotanyPotsTiersMod;
import com.ultramega.botanypotstiers.common.impl.PotTier;
import com.ultramega.botanypotstiers.common.impl.block.TieredBotanyPotBlock;
import com.ultramega.botanypotstiers.common.impl.block.entity.TieredBotanyPotBlockEntity;
import com.ultramega.botanypotstiers.common.impl.data.TieredBotanyPotFileGenerator;
import com.ultramega.botanypotstiers.common.impl.data.conditions.ConfigLoadCondition;
import com.ultramega.botanypotstiers.common.impl.item.UpgradeItem;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.data.conditions.ILoadCondition;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.registry.ContentProvider;
import net.darkhax.bookshelf.common.api.registry.adapters.GameRegistryAdapter;
import net.darkhax.bookshelf.common.api.registry.adapters.GenericRegistryAdapter;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.bookshelf.common.impl.registry.adapter.BlockEntityRendererAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.BlockRegistryAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.BlockRenderTypeAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.CreativeModeTabAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.MenuScreenAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.MenuTypeAdapter;
import net.darkhax.botanypots.common.impl.block.BotanyPotRenderer;
import net.darkhax.botanypots.common.impl.block.PotType;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import net.minecraft.class_7923;

public class BotanyPotsTiersContent
implements ContentProvider {
    public static final Supplier<class_1799> TAB_ICON = CachedSupplier.cache(() -> ((class_1792)class_7923.field_41178.method_10223(BotanyPotsTiersMod.id("elite_terracotta_botany_pot"))).method_7854());
    private static final String[] BRICK_TYPES = new String[]{"brick", "stone", "mossy_stone", "deepslate", "tuff", "mud", "prismarine", "nether", "red_nether", "polished_blackstone", "end_stone", "quartz"};
    private final Map<class_2960, TieredBotanyPotBlock> allPotBlocks = new LinkedHashMap<class_2960, TieredBotanyPotBlock>();
    private final Map<class_2960, class_1792> allUpgradeItems = new LinkedHashMap<class_2960, class_1792>();

    private void generatePotFiles() {
        TieredBotanyPotFileGenerator gen = new TieredBotanyPotFileGenerator(new File("outdir"), "botanypotstiers");
        this.make(gen, "terracotta");
        for (class_1767 class_17672 : class_1767.values()) {
            this.make(gen, class_17672.method_7792() + "_terracotta");
            this.make(gen, class_17672.method_7792() + "_glazed_terracotta");
            this.make(gen, class_17672.method_7792() + "_concrete");
        }
        for (String string : BRICK_TYPES) {
            this.make(gen, (String)("brick".equals(string) ? "bricks" : string + "_bricks"));
        }
    }

    private void make(TieredBotanyPotFileGenerator gen, String block) {
        class_2960 blockId = class_2960.method_60656((String)block);
        for (PotTier tier : PotTier.values()) {
            gen.potRecipes(blockId, tier);
            gen.models(blockId, tier);
            gen.lootTables(blockId, tier);
        }
    }

    public void defineBlocks(BlockRegistryAdapter registry) {
        for (PotTier tier : PotTier.values()) {
            this.createPots(registry, "terracotta", tier);
            for (class_1767 class_17672 : class_1767.values()) {
                this.createPots(registry, class_17672.method_7792() + "_terracotta", tier);
                this.createPots(registry, class_17672.method_7792() + "_glazed_terracotta", tier);
                this.createPots(registry, class_17672.method_7792() + "_concrete", tier);
            }
            for (String string : BRICK_TYPES) {
                this.createPots(registry, (String)("brick".equals(string) ? "bricks" : string + "_bricks"), tier);
            }
        }
    }

    private void createPots(BlockRegistryAdapter registry, String name, PotTier tier) {
        class_2960 blockId = class_2960.method_60656((String)name);
        class_3620 color = class_7923.field_41175.method_10250(blockId) ? ((class_2248)class_7923.field_41175.method_10223(blockId)).method_26403() : class_3620.field_15987;
        this.definePot(registry, tier.getName() + "_" + name + "_botany_pot", new TieredBotanyPotBlock(color, PotType.BASIC, tier));
        this.definePot(registry, tier.getName() + "_" + name + "_hopper_botany_pot", new TieredBotanyPotBlock(color, PotType.HOPPER, tier));
        this.definePot(registry, tier.getName() + "_" + name + "_waxed_botany_pot", new TieredBotanyPotBlock(color, PotType.WAXED, tier));
    }

    private void definePot(BlockRegistryAdapter registry, String id, TieredBotanyPotBlock block) {
        class_2960 blockId = class_2960.method_60655((String)this.namespace(), (String)id);
        registry.addPlaceable(id, () -> block);
        this.allPotBlocks.put(blockId, block);
    }

    public void defineItems(GameRegistryAdapter<class_1792> registry) {
        for (PotTier tier : PotTier.values()) {
            String id = tier.getName() + "_upgrade";
            class_2960 itemId = class_2960.method_60655((String)this.namespace(), (String)id);
            UpgradeItem item = new UpgradeItem(new class_1792.class_1793(), tier);
            registry.add(id, () -> item);
            this.allUpgradeItems.put(itemId, item);
        }
    }

    public void defineBlockEntities(GameRegistryAdapter<class_2591<?>> registry) {
        for (PotTier tier : PotTier.values()) {
            registry.add(tier.getName() + "_botany_pot", (Object)Services.GAMEPLAY.blockEntityBuilder((pos, state) -> new TieredBotanyPotBlockEntity((class_2338)pos, (class_2680)state, tier), (class_2248[])this.allPotBlocks.values().stream().filter(block -> block.getTier() == tier).toArray(class_2248[]::new)).method_11034(null));
        }
    }

    public void defineMenuType(MenuTypeAdapter registry) {
    }

    public void defineLoadConditions(GenericRegistryAdapter<MapCodec<? extends ILoadCondition>> registry) {
        registry.add(ConfigLoadCondition.TYPE_ID, ConfigLoadCondition.CODEC);
    }

    public void defineCreativeTabs(CreativeModeTabAdapter registry) {
        registry.add("tab", TAB_ICON, (params, builder) -> {
            for (class_1792 class_17922 : this.allUpgradeItems.values()) {
                builder.method_45421((class_1935)class_17922);
            }
            for (class_2248 class_22482 : this.allPotBlocks.values()) {
                builder.method_45421((class_1935)class_22482.method_8389());
            }
        });
    }

    public void defineBlockRenderers(BlockEntityRendererAdapter registry) {
        for (PotTier tier : PotTier.values()) {
            registry.bind((class_2591)TieredBotanyPotBlockEntity.getType(tier).get(), BotanyPotRenderer::new);
        }
    }

    public void defineMenuScreens(MenuScreenAdapter registry) {
    }

    public void defineBlockRenderTypes(BlockRenderTypeAdapter registry) {
        for (class_2248 class_22482 : this.allPotBlocks.values()) {
            registry.add(class_22482, class_1921.method_23581());
        }
    }

    public String namespace() {
        return "botanypotstiers";
    }
}

