/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.botanypotstiers.common.impl.block;

import com.ultramega.botanypotstiers.common.impl.PotTier;
import com.ultramega.botanypotstiers.common.impl.block.entity.TieredBotanyPotBlockEntity;
import java.util.List;
import net.darkhax.botanypots.common.api.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.api.data.recipes.soil.Soil;
import net.darkhax.botanypots.common.impl.block.BotanyPotBlock;
import net.darkhax.botanypots.common.impl.block.PotType;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TieredBotanyPotBlock
extends BotanyPotBlock {
    private final PotTier tier;

    public TieredBotanyPotBlock(MapColor color, PotType type, PotTier tier) {
        super(color, type);
        this.tier = tier;
    }

    public TieredBotanyPotBlock(BlockBehaviour.Properties properties, PotType type, PotTier tier) {
        super(properties, type);
        this.tier = tier;
    }

    public float getGrowthModifier(BotanyPotContext context, Level level, Crop crop, @Nullable Soil soil) {
        return this.tier.getSpeedMultiplier();
    }

    public float getYieldModifier(BotanyPotContext context, Level level, Crop crop, @Nullable Soil soil) {
        return this.tier.getOutputMultiplier();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            components.add((Component)Component.translatable((String)"tooltip.botanypotstiers.tiered_botany_pot.multiplier", (Object[])new Object[]{this.tier.getOutputMultiplier()}).withStyle(ChatFormatting.AQUA));
            components.add((Component)Component.translatable((String)"tooltip.botanypotstiers.tiered_botany_pot.speed", (Object[])new Object[]{this.tier.getSpeedMultiplier()}).withStyle(ChatFormatting.AQUA));
        } else {
            components.add((Component)Component.translatable((String)"tooltip.botanypotstiers.tiered_botany_pot.pressShiftForMore").withStyle(ChatFormatting.YELLOW));
        }
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return TieredBotanyPotBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)TieredBotanyPotBlockEntity.getType(this.tier).get()), (level1, pos, state1, pot) -> TieredBotanyPotBlockEntity.tickPot(level1, pos, state1, (TieredBotanyPotBlockEntity)pot));
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new TieredBotanyPotBlockEntity(pos, state, this.tier);
    }

    public PotTier getTier() {
        return this.tier;
    }
}

