/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.botanypotstiers.common.impl.data;

import com.ultramega.botanypotstiers.common.impl.PotTier;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.minecraft.resources.ResourceLocation;

public class TieredBotanyPotFileGenerator {
    private final File outDir;
    private final String ownerId;
    private static final String BASIC_POT_MODEL_TEMPLATE = "{\n    \"parent\": \"botanypotstiers:block/template/pot\",\n    \"render_type\": \"minecraft:cutout\",\n    \"textures\": {\n        \"material\": \"minecraft:block/$texture\",\n        \"material_top\": \"botanypots:block/$texture_pot_top\",\n        \"stripe\": \"botanypotstiers:block/$tier\"\n    }\n}\n";
    private static final String HOPPER_POT_MODEL_TEMPLATE = "{\n    \"parent\": \"botanypotstiers:block/template/hopper_pot\",\n    \"render_type\": \"minecraft:cutout\",\n    \"textures\": {\n        \"material\": \"minecraft:block/$texture\",\n        \"material_top\": \"botanypots:block/$texture_pot_top\",\n        \"stripe\": \"botanypotstiers:block/$tier\"\n    }\n}\n";
    private static final String BLOCK_ITEM_MODEL_TEMPLATE = "{\n    \"parent\": \"$owner:block/$block_name\"\n}\n";
    private static final String BLOCK_STATE_TEMPLATE = "{\n  \"variants\": {\n    \"\": {\n      \"model\": \"$owner:block/$model_name\"\n    }\n  }\n}\n";
    private static final String BASIC_POT_RECIPE_TEMPLATE = "{\n    \"bookshelf:load_conditions\": [\n        {\n            \"type\": \"botanypotstiers:config\",\n            \"property\": \"can_craft_$tier_basic_pots\"\n        }\n    ],\n    \"type\": \"minecraft:crafting_shaped\",\n    \"category\": \"misc\",\n    \"group\": \"botanypotstiers:$tier_basic_pot\",\n    \"pattern\": [\n        \"MAM\",\n        \"MPM\",\n        \"BMB\"\n    ],\n    \"key\": {\n        \"M\": {\n            \"item\": \"$material_id\"\n        },\n        \"B\": {\n            \"item\": \"$recipe1_id\"\n        },\n        \"A\": {\n            \"item\": \"$recipe2_id\"\n        },\n        \"P\": {\n            \"tag\": \"$previous_owner:$previous_tier_$is_hopper_botany_pots\"\n        }\n    },\n    \"result\": {\n        \"id\": \"$owner:$tier_$material_name_$is_hopper_botany_pot\",\n        \"count\": 1\n    }\n}";
    private static final String BASIC_POT_SAME_MATERIAL_RECIPE_TEMPLATE = "{\n    \"bookshelf:load_conditions\": [\n        {\n            \"type\": \"botanypotstiers:config\",\n            \"property\": \"can_craft_$tier_basic_pots\"\n        }\n    ],\n    \"type\": \"minecraft:crafting_shaped\",\n    \"category\": \"misc\",\n    \"group\": \"botanypotstiers:$tier_basic_pot\",\n    \"pattern\": [\n        \" A \",\n        \" P \",\n        \"B B\"\n    ],\n    \"key\": {\n        \"B\": {\n            \"item\": \"$recipe1_id\"\n        },\n        \"A\": {\n            \"item\": \"$recipe2_id\"\n        },\n        \"P\": {\n            \"item\": \"$previous_owner:$previous_tier_$material_name_$is_hopper_botany_pot\"\n        }\n    },\n    \"result\": {\n        \"id\": \"$owner:$tier_$material_name_$is_hopper_botany_pot\",\n        \"count\": 1\n    }\n}";
    private static final String HOPPER_POT_RECIPE_TEMPLATE = "{\n    \"bookshelf:load_conditions\": [\n        {\n            \"type\": \"botanypotstiers:config\",\n            \"property\": \"can_craft_$tier_hopper_pots\"\n        }\n    ],\n    \"type\": \"minecraft:crafting_shapeless\",\n    \"category\": \"misc\",\n    \"group\": \"botanypotstiers:$tier_hopper_pot\",\n    \"ingredients\": [\n        {\n            \"item\": \"minecraft:hopper\"\n        },\n        {\n            \"item\": \"$owner:$tier_$material_name_botany_pot\"\n        }\n    ],\n    \"result\": {\n        \"id\": \"$owner:$tier_$material_name_hopper_botany_pot\",\n        \"count\": 1\n    }\n}";
    private static final String QUICK_HOPPER_POT_RECIPE_TEMPLATE = "{\n    \"bookshelf:load_conditions\": [\n        {\n            \"type\": \"botanypotstiers:config\",\n            \"property\": \"can_craft_$tier_hopper_pots\"\n        }\n    ],\n    \"type\": \"minecraft:crafting_shaped\",\n    \"category\": \"misc\",\n    \"group\": \"botanypotstiers:quick_$tier_hopper_pot\",\n    \"pattern\": [\n        \"HMA\",\n        \"MPM\",\n        \"BMB\"\n    ],\n    \"key\": {\n        \"M\": {\n            \"item\": \"$material_id\"\n        },\n        \"B\": {\n            \"item\": \"$recipe1_id\"\n        },\n        \"A\": {\n            \"item\": \"$recipe2_id\"\n        },\n        \"P\": {\n            \"tag\": \"$previous_owner:$previous_tier_botany_pots\"\n        },\n        \"H\": {\n            \"item\": \"minecraft:hopper\"\n        }\n    },\n    \"result\": {\n        \"id\": \"$owner:$tier_$material_name_hopper_botany_pot\",\n        \"count\": 1\n    }\n}";
    private static final String QUICK_HOPPER_POT_SAME_MATERIAL_RECIPE_TEMPLATE = "{\n    \"bookshelf:load_conditions\": [\n        {\n            \"type\": \"botanypotstiers:config\",\n            \"property\": \"can_craft_$tier_hopper_pots\"\n        }\n    ],\n    \"type\": \"minecraft:crafting_shaped\",\n    \"category\": \"misc\",\n    \"group\": \"botanypotstiers:quick_$tier_hopper_pot\",\n    \"pattern\": [\n        \"H A\",\n        \" P \",\n        \"B B\"\n    ],\n    \"key\": {\n        \"B\": {\n            \"item\": \"$recipe1_id\"\n        },\n        \"A\": {\n            \"item\": \"$recipe2_id\"\n        },\n        \"P\": {\n            \"item\": \"$previous_owner:$previous_tier_$material_name_botany_pot\"\n        },\n        \"H\": {\n            \"item\": \"minecraft:hopper\"\n        }\n    },\n    \"result\": {\n        \"id\": \"$owner:$tier_$material_name_hopper_botany_pot\",\n        \"count\": 1\n    }\n}";
    private static final String WAX_POT_RECIPE_TEMPLATE = "{\n    \"bookshelf:load_conditions\": [\n        {\n            \"type\": \"botanypotstiers:config\",\n            \"property\": \"can_wax_$tier_pots\"\n        }\n    ],\n    \"type\": \"minecraft:crafting_shapeless\",\n    \"category\": \"misc\",\n    \"group\": \"botanypotstiers:waxed_$tier_pot\",\n    \"ingredients\": [\n        {\n            \"item\": \"minecraft:honeycomb\"\n        },\n        {\n            \"item\": \"$owner:$tier_$material_name_botany_pot\"\n        }\n    ],\n    \"result\": {\n        \"id\": \"$owner:$tier_$material_name_waxed_botany_pot\",\n        \"count\": 1\n    }\n}";
    private static final String DROP_SELF_TABLE = "{\n  \"type\": \"minecraft:block\",\n  \"pools\": [\n    {\n      \"conditions\": [\n        {\n          \"condition\": \"minecraft:survives_explosion\"\n        }\n      ],\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"$block_id\"\n        }\n      ],\n      \"rolls\": 1.0\n    }\n  ],\n  \"random_sequence\": \"$block_id\"\n}\n";

    public TieredBotanyPotFileGenerator(File outDir, String ownerId) {
        this.outDir = outDir;
        this.ownerId = ownerId;
    }

    public void potRecipes(ResourceLocation material, PotTier tier) {
        File potsDir = TieredBotanyPotFileGenerator.setup(new File(this.outDir, "data/" + this.ownerId + "/recipe/pots"));
        this.basicPotUpgradeRecipe(potsDir, material, tier);
        this.basicPotUpgradeSameMaterialRecipe(potsDir, material, tier);
        this.hopperPotUpgradeRecipe(potsDir, material, tier);
        this.hopperPotUpgradeSameMaterialRecipe(potsDir, material, tier);
        this.hopperPotRecipe(potsDir, material, tier);
        this.quickHopperUpgradePotRecipe(potsDir, material, tier);
        this.quickHopperUpgradePotSameMaterialRecipe(potsDir, material, tier);
        this.waxedPotRecipe(potsDir, material, tier);
    }

    public void lootTables(ResourceLocation material, PotTier tier) {
        File lootDir = TieredBotanyPotFileGenerator.setup(new File(this.outDir, "data/" + this.ownerId + "/loot_table/blocks"));
        String prefix = tier.getName() + "_" + material.getPath();
        this.lootTable(lootDir, ResourceLocation.fromNamespaceAndPath((String)this.ownerId, (String)(prefix + "_botany_pot")));
        this.lootTable(lootDir, ResourceLocation.fromNamespaceAndPath((String)this.ownerId, (String)(prefix + "_hopper_botany_pot")));
        this.lootTable(lootDir, ResourceLocation.fromNamespaceAndPath((String)this.ownerId, (String)(prefix + "_waxed_botany_pot")));
    }

    public void models(ResourceLocation material, PotTier tier) {
        File modelDir = TieredBotanyPotFileGenerator.setup(new File(this.outDir, "assets/" + this.ownerId + "/models"));
        File blockDir = TieredBotanyPotFileGenerator.setup(new File(modelDir, "block"));
        File itemDir = TieredBotanyPotFileGenerator.setup(new File(modelDir, "item"));
        File stateDir = TieredBotanyPotFileGenerator.setup(new File(this.outDir, "assets/" + this.ownerId + "/blockstates"));
        String prefix = tier.getName() + "_" + material.getPath();
        TieredBotanyPotFileGenerator.write(new File(blockDir, prefix + "_botany_pot.json"), BASIC_POT_MODEL_TEMPLATE.replace("$texture", material.getPath()).replace("$tier", tier.getName()));
        TieredBotanyPotFileGenerator.write(new File(itemDir, prefix + "_botany_pot.json"), BLOCK_ITEM_MODEL_TEMPLATE.replace("$owner", this.ownerId).replace("$block_name", prefix + "_botany_pot"));
        TieredBotanyPotFileGenerator.write(new File(stateDir, prefix + "_botany_pot.json"), BLOCK_STATE_TEMPLATE.replace("$owner", this.ownerId).replace("$model_name", prefix + "_botany_pot"));
        TieredBotanyPotFileGenerator.write(new File(blockDir, prefix + "_hopper_botany_pot.json"), HOPPER_POT_MODEL_TEMPLATE.replace("$texture", material.getPath()).replace("$tier", tier.getName()));
        TieredBotanyPotFileGenerator.write(new File(itemDir, prefix + "_hopper_botany_pot.json"), BLOCK_ITEM_MODEL_TEMPLATE.replace("$owner", this.ownerId).replace("$block_name", prefix + "_hopper_botany_pot"));
        TieredBotanyPotFileGenerator.write(new File(stateDir, prefix + "_hopper_botany_pot.json"), BLOCK_STATE_TEMPLATE.replace("$owner", this.ownerId).replace("$model_name", prefix + "_hopper_botany_pot"));
        TieredBotanyPotFileGenerator.write(new File(blockDir, prefix + "_waxed_botany_pot.json"), BASIC_POT_MODEL_TEMPLATE.replace("$texture", material.getPath()).replace("$tier", tier.getName()));
        TieredBotanyPotFileGenerator.write(new File(itemDir, prefix + "_waxed_botany_pot.json"), BLOCK_ITEM_MODEL_TEMPLATE.replace("$owner", this.ownerId).replace("$block_name", prefix + "_botany_pot"));
        TieredBotanyPotFileGenerator.write(new File(stateDir, prefix + "_waxed_botany_pot.json"), BLOCK_STATE_TEMPLATE.replace("$owner", this.ownerId).replace("$model_name", prefix + "_botany_pot"));
    }

    public void basicPotUpgradeRecipe(File recipeDir, ResourceLocation material, PotTier tier) {
        TieredBotanyPotFileGenerator.write(new File(recipeDir, tier.getName() + "_" + material.getPath() + "_botany_pot.json"), this.format(BASIC_POT_RECIPE_TEMPLATE, material, tier, false));
    }

    public void basicPotUpgradeSameMaterialRecipe(File recipeDir, ResourceLocation material, PotTier tier) {
        TieredBotanyPotFileGenerator.write(new File(recipeDir, tier.getName() + "_" + material.getPath() + "_botany_pot_same_material.json"), this.format(BASIC_POT_SAME_MATERIAL_RECIPE_TEMPLATE, material, tier, false));
    }

    public void hopperPotUpgradeRecipe(File recipeDir, ResourceLocation material, PotTier tier) {
        if (tier == PotTier.ELITE) {
            return;
        }
        TieredBotanyPotFileGenerator.write(new File(recipeDir, tier.getName() + "_" + material.getPath() + "_hopper_botany_pot_upgrade.json"), this.format(BASIC_POT_RECIPE_TEMPLATE, material, tier, true));
    }

    public void hopperPotUpgradeSameMaterialRecipe(File recipeDir, ResourceLocation material, PotTier tier) {
        if (tier == PotTier.ELITE) {
            return;
        }
        TieredBotanyPotFileGenerator.write(new File(recipeDir, tier.getName() + "_" + material.getPath() + "_hopper_botany_pot_upgrade_same_material.json"), this.format(BASIC_POT_SAME_MATERIAL_RECIPE_TEMPLATE, material, tier, true));
    }

    public void quickHopperUpgradePotRecipe(File recipeDir, ResourceLocation material, PotTier tier) {
        TieredBotanyPotFileGenerator.write(new File(recipeDir, tier.getName() + "_" + material.getPath() + "_hopper_botany_pot_upgrade_quick.json"), this.format(QUICK_HOPPER_POT_RECIPE_TEMPLATE, material, tier, false));
    }

    public void quickHopperUpgradePotSameMaterialRecipe(File recipeDir, ResourceLocation material, PotTier tier) {
        TieredBotanyPotFileGenerator.write(new File(recipeDir, tier.getName() + "_" + material.getPath() + "_hopper_botany_pot_upgrade_quick_same_material.json"), this.format(QUICK_HOPPER_POT_SAME_MATERIAL_RECIPE_TEMPLATE, material, tier, false));
    }

    public void hopperPotRecipe(File recipeDir, ResourceLocation material, PotTier tier) {
        TieredBotanyPotFileGenerator.write(new File(recipeDir, tier.getName() + "_" + material.getPath() + "_hopper_botany_pot.json"), this.format(HOPPER_POT_RECIPE_TEMPLATE, material, tier, false));
    }

    public void waxedPotRecipe(File recipeDir, ResourceLocation material, PotTier tier) {
        TieredBotanyPotFileGenerator.write(new File(recipeDir, tier.getName() + "_" + material.getPath() + "_waxed_botany_pot.json"), this.format(WAX_POT_RECIPE_TEMPLATE, material, tier, false));
    }

    public void lootTable(File lootDir, ResourceLocation blockId) {
        TieredBotanyPotFileGenerator.write(new File(lootDir, blockId.getPath() + ".json"), DROP_SELF_TABLE.replace("$block_id", blockId.toString()));
    }

    private String format(String template, ResourceLocation material, PotTier tier, boolean isHopper) {
        PotTier prevTier = PotTier.getPrevious(tier);
        return template.replace("$previous_owner", tier == PotTier.ELITE ? "botanypots" : this.ownerId).replace("$previous_tier_", (CharSequence)(prevTier != null ? prevTier.getName() + "_" : "")).replace("$owner", this.ownerId).replace("$material_id", material.toString()).replace("$material_name", material.getPath()).replace("$recipe1_id", this.getRecipeItem1(tier)).replace("$recipe2_id", this.getRecipeItem2(tier)).replace("$is_hopper_", isHopper ? "hopper_" : "").replace("$tier", tier.getName());
    }

    private String getRecipeItem1(PotTier tier) {
        return switch (tier) {
            default -> throw new MatchException(null, null);
            case PotTier.ELITE -> "minecraft:iron_block";
            case PotTier.ULTRA -> "minecraft:diamond_block";
            case PotTier.MEGA -> "minecraft:netherite_block";
        };
    }

    private String getRecipeItem2(PotTier tier) {
        return switch (tier) {
            default -> throw new MatchException(null, null);
            case PotTier.ELITE -> "minecraft:ender_pearl";
            case PotTier.ULTRA -> "minecraft:nether_star";
            case PotTier.MEGA -> "minecraft:enchanted_golden_apple";
        };
    }

    private static void write(File file, String text) {
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try (FileWriter writer = new FileWriter(file);){
            writer.append(text);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static File setup(File dir) {
        dir.mkdirs();
        return dir;
    }
}

