/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.botanypotstiers.common.impl;

import com.ultramega.botanypotstiers.common.impl.BotanyPotsTiersMod;
import com.ultramega.botanypotstiers.common.impl.config.Config;
import org.jetbrains.annotations.Nullable;

public enum PotTier {
    ELITE("elite"),
    ULTRA("ultra"),
    MEGA("mega");

    private final String name;

    private PotTier(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getOutputMultiplier() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ((Config)BotanyPotsTiersMod.CONFIG.get()).gameplay.elite_botany_pot_output_multiplier;
            case 1 -> ((Config)BotanyPotsTiersMod.CONFIG.get()).gameplay.ultra_botany_pot_output_multiplier;
            case 2 -> ((Config)BotanyPotsTiersMod.CONFIG.get()).gameplay.mega_botany_pot_output_multiplier;
        };
    }

    public int getSpeedMultiplier() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ((Config)BotanyPotsTiersMod.CONFIG.get()).gameplay.elite_botany_pot_speed_multiplier;
            case 1 -> ((Config)BotanyPotsTiersMod.CONFIG.get()).gameplay.ultra_botany_pot_speed_multiplier;
            case 2 -> ((Config)BotanyPotsTiersMod.CONFIG.get()).gameplay.mega_botany_pot_speed_multiplier;
        };
    }

    @Nullable
    public static PotTier getPrevious(PotTier current) {
        PotTier[] values = PotTier.values();
        int index = current.ordinal() - 1;
        if (index < 0) {
            return null;
        }
        return values[index];
    }

    @Nullable
    public static PotTier getNext(PotTier current) {
        PotTier[] values = PotTier.values();
        int index = current.ordinal() + 1;
        if (index > values.length - 1) {
            return null;
        }
        return values[index];
    }
}

