/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.block.entity;

import com.michelmuscle.slidersmod.config.SlidersModConfig;
import com.michelmuscle.slidersmod.entity.VortexEntity;
import com.michelmuscle.slidersmod.init.ModBlockEntities;
import com.michelmuscle.slidersmod.init.ModItems;
import com.michelmuscle.slidersmod.init.ModSounds;
import com.michelmuscle.slidersmod.item.OriginalTimerItem;
import com.michelmuscle.slidersmod.menu.QuantumGatePrototypeMenu;
import com.michelmuscle.slidersmod.network.ExodusVortexBeamPacket;
import com.michelmuscle.slidersmod.network.ModNetworking;
import com.michelmuscle.slidersmod.portal.VortexImmersivePortalHelper;
import com.michelmuscle.slidersmod.portal.VortexPortalPlacement;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuantumGatePrototypeBlockEntity
extends BlockEntity
implements MenuProvider {
    private static final int ENERGY_CAPACITY = 25000;
    private static final int ENERGY_PER_TRIGGER = 15000;
    private static final int ENERGY_PULL_PER_TICK = 500;
    private static final int OVERHEAT_DURATION_TICKS = 12000;
    private static final int TRIGGER_WARMUP_TICKS = 100;
    private static final int EXPLORATION_DURATION_TICKS = 6000;
    private static final int VORTEX_DURATION_TICKS = 600;
    private static final int BEAM_SPAWN_DELAY_TICKS = 12;
    private static final int MIN_DISTANCE = 3;
    private static final int MAX_DISTANCE = 10;
    private static final float SUCCESS_PROBABILITY = 0.5f;
    private static final String ENERGY_TAG = "Energy";
    private static final String COOLDOWN_END_TIME_TAG = "CooldownEndTime";
    private static final String EXPLORATION_END_TIME_TAG = "ExplorationEndTime";
    private static final String VORTEX_DISTANCE_TAG = "VortexDistance";
    private static final String IS_OVERHEATED_TAG = "IsOverheated";
    private static final String QUANTUM_GATE_FLAG = "IsQuantumGatePrototype";
    private static final String QUANTUM_GATE_TARGET_DIM_TAG = "QuantumGateTargetDimension";
    private static final double VORTEX_VERTICAL_OFFSET = 2.2;
    private static final double BEAM_RANGE = 128.0;
    private static final double BEAM_START_Y_OFFSET = 0.6;
    private static final ResourceLocation QUANTUM_GATE_TARGET_DIMENSION = new ResourceLocation("slidersmod", "alternate_overworld");
    private final CustomEnergyStorage energyStorage = new CustomEnergyStorage(25000, 500);
    private LazyOptional<IEnergyStorage> energyCapability = LazyOptional.of(() -> this.energyStorage);
    private long cooldownEndTime = 0L;
    private long explorationEndTime = 0L;
    private int vortexDistance = 5;
    private boolean isOverheated = false;
    private int triggerCooldown = 0;
    private boolean lastTriggerSuccess = false;
    private UUID triggeringPlayerUUID = null;
    private long particleEffectEndTime = 0L;
    private boolean hasPendingVortex = false;
    private int pendingVortexDelayTicks = 0;
    private UUID pendingVortexPlayerUUID = null;
    private double pendingVortexX;
    private double pendingVortexY;
    private double pendingVortexZ;
    private ItemStack enderPearlStack = ItemStack.f_41583_;

    public QuantumGatePrototypeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.QUANTUM_GATE_PROTOTYPE.get(), pos, state);
    }

    private void sync() {
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    private void resetPendingVortex() {
        this.hasPendingVortex = false;
        this.pendingVortexDelayTicks = 0;
        this.pendingVortexPlayerUUID = null;
        this.pendingVortexX = 0.0;
        this.pendingVortexY = 0.0;
        this.pendingVortexZ = 0.0;
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int getScaledEnergy() {
        if (this.getMaxEnergyStored() == 0) {
            return 0;
        }
        return this.getEnergyStored() * 52 / this.getMaxEnergyStored();
    }

    public boolean isOverheated() {
        if (!this.isOverheated) {
            return false;
        }
        if (this.f_58857_ != null) {
            long currentTime = this.f_58857_.m_46467_();
            if (this.cooldownEndTime > 0L && currentTime >= this.cooldownEndTime) {
                this.cooldownEndTime = 0L;
                this.isOverheated = false;
                this.sync();
            }
        }
        return this.isOverheated;
    }

    public int getCooldownSecondsRemaining() {
        if (this.f_58857_ == null || this.cooldownEndTime <= 0L) {
            return 0;
        }
        long remainingTicks = this.cooldownEndTime - this.f_58857_.m_46467_();
        return (int)Math.max(0L, remainingTicks / 20L);
    }

    public int getTriggerCooldownTicks() {
        return this.triggerCooldown;
    }

    public boolean hasActiveExploration() {
        if (this.f_58857_ == null) {
            return false;
        }
        return this.explorationEndTime > this.f_58857_.m_46467_();
    }

    public int getExplorationSecondsRemaining() {
        if (this.f_58857_ == null || this.explorationEndTime <= 0L) {
            return 0;
        }
        long remainingTicks = this.explorationEndTime - this.f_58857_.m_46467_();
        return (int)Math.max(0L, remainingTicks / 20L);
    }

    private void startExplorationCountdown(ServerLevel serverLevel) {
        int durationMinutes = (Integer)SlidersModConfig.PROTO_VORTEX_DURATION_MINUTES.get();
        int durationTicks = durationMinutes * 60 * 20;
        this.explorationEndTime = serverLevel.m_46467_() + (long)durationTicks;
        this.sync();
    }

    private static String formatSeconds(int seconds) {
        int value = Math.max(0, seconds);
        int minutes = value / 60;
        int secs = value % 60;
        return String.format(Locale.ROOT, "%02d:%02d", minutes, secs);
    }

    public long getCooldownEndTime() {
        return this.cooldownEndTime;
    }

    public int getCooldownTicksRemaining() {
        if (this.f_58857_ == null) {
            return 0;
        }
        long remaining = this.cooldownEndTime - this.f_58857_.m_46467_();
        return (int)Math.max(0L, remaining);
    }

    private void setOverheated() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.isOverheated = true;
        this.cooldownEndTime = this.f_58857_.m_46467_() + 12000L;
        this.sync();
    }

    public void setVortexDistance(int distance) {
        int clamped = Math.max(3, Math.min(10, distance));
        if (this.vortexDistance != clamped) {
            this.vortexDistance = clamped;
            this.sync();
        }
    }

    public int getVortexDistance() {
        return this.vortexDistance;
    }

    public static int getMinDistance() {
        return 3;
    }

    public static int getMaxDistance() {
        return 10;
    }

    public void handleDistanceUpdate(int distance) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            this.vortexDistance = Math.max(3, Math.min(10, distance));
            return;
        }
        this.setVortexDistance(distance);
    }

    public ItemStack getEnderPearlStack() {
        return this.enderPearlStack;
    }

    public void setEnderPearlStack(ItemStack stack) {
        this.enderPearlStack = stack.m_41777_();
        this.enderPearlStack.m_41764_(Math.min(stack.m_41613_(), 64));
        this.sync();
    }

    private boolean hasThreeEnderPearls() {
        return this.enderPearlStack.m_41720_() == Items.f_42584_ && this.enderPearlStack.m_41613_() >= 3;
    }

    private void consumeThreeEnderPearls() {
        if (this.hasThreeEnderPearls()) {
            this.enderPearlStack.m_41774_(3);
            if (this.enderPearlStack.m_41619_()) {
                this.enderPearlStack = ItemStack.f_41583_;
            }
            this.sync();
        }
    }

    public boolean canTrigger() {
        return this.getTriggerFailureMessage() == null;
    }

    @Nullable
    private Component getTriggerFailureMessage() {
        if (this.isOverheated()) {
            return Component.m_237113_((String)("Quantum Gate overheated (" + QuantumGatePrototypeBlockEntity.formatSeconds(this.getCooldownSecondsRemaining()) + ")")).m_130940_(ChatFormatting.RED);
        }
        if (this.isTriggerActive()) {
            return Component.m_237113_((String)"Quantum Gate is already charging").m_130940_(ChatFormatting.RED);
        }
        if (this.energyStorage.getEnergyStored() < 15000) {
            return Component.m_237113_((String)"Requires 15,000 FE").m_130940_(ChatFormatting.RED);
        }
        if (!this.hasThreeEnderPearls()) {
            return Component.m_237113_((String)"Insert 3 Ender Pearls").m_130940_(ChatFormatting.RED);
        }
        return null;
    }

    public void triggerVortex(ServerPlayer player) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        Component failure = this.getTriggerFailureMessage();
        if (failure != null) {
            if (player != null) {
                player.m_5661_(failure, true);
            }
            return;
        }
        ServerLevel serverLevel = (ServerLevel)this.f_58857_;
        this.triggeringPlayerUUID = player.m_20148_();
        this.energyStorage.extractEnergy(15000, false);
        this.consumeThreeEnderPearls();
        this.particleEffectEndTime = this.f_58857_.m_46467_() + 100L;
        this.resetPendingVortex();
        serverLevel.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.PROTO_LOADING.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        this.triggerCooldown = 100;
        this.lastTriggerSuccess = serverLevel.f_46441_.m_188501_() < 0.5f;
        this.sync();
    }

    public String getStateText() {
        if (this.isOverheated()) {
            return "Overheated (" + QuantumGatePrototypeBlockEntity.formatSeconds(this.getCooldownSecondsRemaining()) + ")";
        }
        if (this.triggerCooldown > 0) {
            int seconds = (int)Math.ceil((double)this.triggerCooldown / 20.0);
            return "Charging (" + seconds + "s)";
        }
        int explorationSeconds = this.getExplorationSecondsRemaining();
        if (explorationSeconds > 0) {
            return "Exploration: " + QuantumGatePrototypeBlockEntity.formatSeconds(explorationSeconds);
        }
        return "Idle";
    }

    public boolean isTriggerActive() {
        return this.triggerCooldown > 0;
    }

    public int getTriggerProgress() {
        if (this.triggerCooldown <= 0) {
            return 0;
        }
        return 100 - this.triggerCooldown;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, QuantumGatePrototypeBlockEntity entity) {
        if (level.f_46443_) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        entity.pullEnergyFromNeighbors(serverLevel);
        entity.isOverheated();
        if (entity.explorationEndTime > 0L && serverLevel.m_46467_() >= entity.explorationEndTime) {
            entity.explorationEndTime = 0L;
            entity.sync();
        }
        if (entity.shouldEmitOperationalParticles(serverLevel) && serverLevel.m_46467_() % 2L == 0L) {
            entity.spawnOperationalParticles(serverLevel);
        }
        if (entity.hasPendingVortex && entity.pendingVortexDelayTicks > 0) {
            --entity.pendingVortexDelayTicks;
            if (entity.pendingVortexDelayTicks == 0) {
                entity.completeScheduledVortex(serverLevel, pos);
            }
        }
        if (entity.cooldownEndTime > 0L && serverLevel.m_46467_() >= entity.cooldownEndTime) {
            entity.cooldownEndTime = 0L;
            entity.isOverheated = false;
            entity.sync();
        }
        if (entity.triggerCooldown > 0) {
            --entity.triggerCooldown;
            if (entity.triggerCooldown == 0) {
                ServerPlayer player = null;
                if (entity.triggeringPlayerUUID != null) {
                    player = serverLevel.m_7654_().m_6846_().m_11259_(entity.triggeringPlayerUUID);
                }
                if (entity.lastTriggerSuccess) {
                    serverLevel.m_5594_(null, pos, (SoundEvent)ModSounds.EGYPTIAN_OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    serverLevel.m_5594_(null, pos, (SoundEvent)ModSounds.PROTO_SOUND.get(), SoundSource.BLOCKS, 0.6f, 1.0f);
                    entity.handleSuccessfulTrigger(serverLevel, pos, state, player);
                    if (player != null) {
                        player.m_5661_((Component)Component.m_237113_((String)"Vortex open! 30 seconds remaining.").m_130940_(ChatFormatting.GREEN), true);
                    }
                    entity.setOverheated();
                } else {
                    serverLevel.m_5594_(null, pos, (SoundEvent)ModSounds.TIMER_BURNOUT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (player != null) {
                        player.m_5661_((Component)Component.m_237113_((String)"Vortex failed to open!").m_130940_(ChatFormatting.RED), true);
                    }
                }
                entity.triggeringPlayerUUID = null;
                entity.sync();
            }
        }
    }

    private void handleSuccessfulTrigger(ServerLevel level, BlockPos pos, BlockState state, ServerPlayer player) {
        this.particleEffectEndTime = level.m_46467_() + 600L;
        Vec3 target = this.calculateVortexTarget(pos, state, player);
        this.scheduleVortexSpawn(level, pos, target, player);
    }

    private Vec3 calculateVortexTarget(BlockPos pos, BlockState state, ServerPlayer player) {
        Direction facing = ((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_();
        double distance = this.getVortexDistance();
        double offsetX = (double)facing.m_122429_() * distance;
        double offsetZ = (double)facing.m_122431_() * distance;
        double vortexX = (double)pos.m_123341_() + 0.5 + offsetX;
        double vortexY = player.m_20186_() + 2.2;
        double vortexZ = (double)pos.m_123343_() + 0.5 + offsetZ;
        return new Vec3(vortexX, vortexY, vortexZ);
    }

    private static VortexPortalPlacement buildProtoVortexPlacement(BlockState state, Vec3 center) {
        Direction facing = ((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_();
        Vec3 normal = new Vec3((double)facing.m_122429_(), 0.0, (double)facing.m_122431_());
        normal = normal.m_82556_() < 1.0E-4 ? new Vec3(0.0, 0.0, 1.0) : normal.m_82541_();
        Vec3 axisH = new Vec3(0.0, 1.0, 0.0);
        Vec3 axisW = normal.m_82537_(axisH);
        axisW = axisW.m_82556_() < 1.0E-4 ? new Vec3(1.0, 0.0, 0.0) : axisW.m_82541_();
        axisH = axisW.m_82537_(normal).m_82541_();
        return new VortexPortalPlacement(center, axisW, axisH, normal, true);
    }

    private void scheduleVortexSpawn(ServerLevel level, BlockPos pos, Vec3 target, ServerPlayer player) {
        this.hasPendingVortex = true;
        this.pendingVortexDelayTicks = 12;
        this.pendingVortexPlayerUUID = player != null ? player.m_20148_() : null;
        this.pendingVortexX = target.f_82479_;
        this.pendingVortexY = target.f_82480_;
        this.pendingVortexZ = target.f_82481_;
        this.sendBeamEffect(level, pos, target);
    }

    private void sendBeamEffect(ServerLevel level, BlockPos pos, Vec3 target) {
        Vec3 start = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.6, (double)pos.m_123343_() + 0.5);
        PacketDistributor.TargetPoint targetPoint = new PacketDistributor.TargetPoint(target.f_82479_, target.f_82480_, target.f_82481_, 128.0, level.m_46472_());
        ModNetworking.CHANNEL.send(PacketDistributor.NEAR.with(() -> targetPoint), (Object)new ExodusVortexBeamPacket(start, target));
    }

    private void completeScheduledVortex(ServerLevel level, BlockPos pos) {
        if (!this.hasPendingVortex) {
            return;
        }
        ServerPlayer player = null;
        if (this.pendingVortexPlayerUUID != null) {
            player = level.m_7654_().m_6846_().m_11259_(this.pendingVortexPlayerUUID);
        }
        if (player != null) {
            QuantumGatePrototypeBlockEntity.createVortex(level, pos, level.m_8055_(pos), this, player, this.pendingVortexX, this.pendingVortexY, this.pendingVortexZ);
            this.startExplorationCountdown(level);
        }
        this.resetPendingVortex();
    }

    private static void createVortex(ServerLevel level, BlockPos pos, BlockState state, QuantumGatePrototypeBlockEntity entity, ServerPlayer player, double vortexX, double vortexY, double vortexZ) {
        if (player == null) {
            return;
        }
        ItemStack timerStack = new ItemStack((ItemLike)ModItems.ORIGINAL_TIMER.get());
        OriginalTimerItem.setConfiguredTime(timerStack, 300L);
        CompoundTag tag = timerStack.m_41784_();
        tag.m_128379_("IsActive", true);
        tag.m_128356_("ActivationTime", level.m_46467_());
        tag.m_128359_("ReturnDimension", level.m_46472_().m_135782_().toString());
        Vec3 portalCenter = new Vec3(vortexX, vortexY, vortexZ);
        tag.m_128347_("ReturnX", portalCenter.f_82479_);
        tag.m_128347_("ReturnY", portalCenter.f_82480_);
        tag.m_128347_("ReturnZ", portalCenter.f_82481_);
        tag.m_128379_("IsLoganVortex", false);
        tag.m_128379_("IsProtoVortex", true);
        tag.m_128379_(QUANTUM_GATE_FLAG, true);
        tag.m_128359_(QUANTUM_GATE_TARGET_DIM_TAG, QUANTUM_GATE_TARGET_DIMENSION.toString());
        VortexPortalPlacement placement = QuantumGatePrototypeBlockEntity.buildProtoVortexPlacement(state, portalCenter);
        VortexEntity vortex = new VortexEntity((Level)level, vortexX, vortexY, vortexZ, player.m_20148_(), timerStack);
        vortex.setProtoVortex(true);
        vortex.reserveImmersivePortalVisual();
        level.m_7967_((Entity)vortex);
        VortexImmersivePortalHelper.attachVisuals(level, vortex, placement, null);
        QuantumGatePrototypeBlockEntity.spawnVortexParticles(level, vortexX, vortexY, vortexZ);
    }

    private static void spawnVortexParticles(ServerLevel level, double x, double y, double z) {
        for (int i = 0; i < 10; ++i) {
            double px = x + (level.f_46441_.m_188500_() - 0.5) * 2.0;
            double py = y + (level.f_46441_.m_188500_() - 0.5) * 2.0;
            double pz = z + (level.f_46441_.m_188500_() - 0.5) * 2.0;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, px, py, pz, 1, 0.0, 0.0, 0.0, 0.1);
        }
    }

    private void spawnOperationalParticles(ServerLevel level) {
        int i;
        double cx = (double)this.f_58858_.m_123341_() + 0.5;
        double cy = (double)this.f_58858_.m_123342_() + 1.0;
        double cz = (double)this.f_58858_.m_123343_() + 0.5;
        for (i = 0; i < 6; ++i) {
            double ox = (level.f_46441_.m_188500_() - 0.5) * 0.6;
            double oz = (level.f_46441_.m_188500_() - 0.5) * 0.6;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, cx + ox, cy + level.f_46441_.m_188500_() * 0.5, cz + oz, 1, 0.02, 0.05, 0.02, 0.01);
        }
        for (i = 0; i < 3; ++i) {
            level.m_8767_((ParticleOptions)ParticleTypes.f_123755_, cx, cy + 0.2 + level.f_46441_.m_188500_() * 0.4, cz, 1, 0.0, 0.08, 0.0, 0.025);
        }
    }

    private boolean shouldEmitOperationalParticles(ServerLevel level) {
        return this.particleEffectEndTime > 0L && level.m_46467_() < this.particleEffectEndTime;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.energyStorage.energy = tag.m_128451_(ENERGY_TAG);
        this.cooldownEndTime = tag.m_128454_(COOLDOWN_END_TIME_TAG);
        this.vortexDistance = tag.m_128451_(VORTEX_DISTANCE_TAG);
        this.isOverheated = tag.m_128471_(IS_OVERHEATED_TAG);
        this.explorationEndTime = tag.m_128454_(EXPLORATION_END_TIME_TAG);
        this.particleEffectEndTime = tag.m_128454_("ParticleEffectEndTime");
        this.hasPendingVortex = tag.m_128471_("HasPendingVortex");
        if (this.hasPendingVortex) {
            this.pendingVortexDelayTicks = tag.m_128451_("PendingVortexDelay");
            this.pendingVortexPlayerUUID = tag.m_128403_("PendingVortexPlayer") ? tag.m_128342_("PendingVortexPlayer") : null;
            this.pendingVortexX = tag.m_128459_("PendingVortexX");
            this.pendingVortexY = tag.m_128459_("PendingVortexY");
            this.pendingVortexZ = tag.m_128459_("PendingVortexZ");
        } else {
            this.resetPendingVortex();
        }
        this.enderPearlStack = tag.m_128441_("EnderPearlStack") ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("EnderPearlStack")) : ItemStack.f_41583_;
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_(ENERGY_TAG, this.energyStorage.energy);
        tag.m_128356_(COOLDOWN_END_TIME_TAG, this.cooldownEndTime);
        tag.m_128405_(VORTEX_DISTANCE_TAG, this.vortexDistance);
        tag.m_128379_(IS_OVERHEATED_TAG, this.isOverheated);
        tag.m_128356_(EXPLORATION_END_TIME_TAG, this.explorationEndTime);
        tag.m_128356_("ParticleEffectEndTime", this.particleEffectEndTime);
        tag.m_128379_("HasPendingVortex", this.hasPendingVortex);
        if (this.hasPendingVortex) {
            tag.m_128405_("PendingVortexDelay", this.pendingVortexDelayTicks);
            if (this.pendingVortexPlayerUUID != null) {
                tag.m_128362_("PendingVortexPlayer", this.pendingVortexPlayerUUID);
            }
            tag.m_128347_("PendingVortexX", this.pendingVortexX);
            tag.m_128347_("PendingVortexY", this.pendingVortexY);
            tag.m_128347_("PendingVortexZ", this.pendingVortexZ);
        }
        if (!this.enderPearlStack.m_41619_()) {
            CompoundTag slotTag = new CompoundTag();
            this.enderPearlStack.m_41739_(slotTag);
            tag.m_128365_("EnderPearlStack", (Tag)slotTag);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Quantum Gate Prototype");
    }

    public AbstractContainerMenu m_7208_(int containerId, @NotNull Inventory inventory, @NotNull Player player) {
        return new QuantumGatePrototypeMenu(containerId, inventory, this, player);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
        if (capability == ForgeCapabilities.ENERGY) {
            return this.energyCapability.cast();
        }
        return super.getCapability(capability, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyCapability.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.energyCapability = LazyOptional.of(() -> this.energyStorage);
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.energyCapability != null) {
            this.energyCapability.invalidate();
        }
    }

    private void pullEnergyFromNeighbors(ServerLevel serverLevel) {
        int remaining = this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored();
        if (remaining <= 0) {
            return;
        }
        remaining = Math.min(remaining, 500);
        for (Direction dir : Direction.values()) {
            int extracted;
            IEnergyStorage src;
            if (remaining <= 0) break;
            BlockPos adjPos = this.f_58858_.m_121945_(dir);
            BlockEntity be = serverLevel.m_7702_(adjPos);
            if (be == null || (src = (IEnergyStorage)be.getCapability(ForgeCapabilities.ENERGY, dir.m_122424_()).orElse(null)) == null || (extracted = src.extractEnergy(remaining, false)) <= 0) continue;
            this.energyStorage.receiveEnergy(extracted, false);
            remaining -= extracted;
        }
    }

    private class CustomEnergyStorage
    implements IEnergyStorage {
        private int energy = 0;
        private final int capacity;
        private final int maxReceive;

        public CustomEnergyStorage(int capacity, int maxReceive) {
            this.capacity = capacity;
            this.maxReceive = maxReceive;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
            if (!simulate) {
                this.energy += energyReceived;
                QuantumGatePrototypeBlockEntity.this.m_6596_();
                QuantumGatePrototypeBlockEntity.this.m_6596_();
            }
            return energyReceived;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int energyExtracted = Math.min(this.energy, maxExtract);
            if (!simulate) {
                this.energy -= energyExtracted;
                QuantumGatePrototypeBlockEntity.this.m_6596_();
                QuantumGatePrototypeBlockEntity.this.m_6596_();
            }
            return energyExtracted;
        }

        public int getEnergyStored() {
            return this.energy;
        }

        public int getMaxEnergyStored() {
            return this.capacity;
        }

        public boolean canReceive() {
            return true;
        }

        public boolean canExtract() {
            return false;
        }

        public void setEnergy(int energy) {
            this.energy = energy;
        }
    }
}

