/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.block.entity;

import com.michelmuscle.slidersmod.client.sound.BlockSoundManager;
import com.michelmuscle.slidersmod.entity.VortexEntity;
import com.michelmuscle.slidersmod.init.ModBlockEntities;
import com.michelmuscle.slidersmod.init.ModItems;
import com.michelmuscle.slidersmod.init.ModSounds;
import com.michelmuscle.slidersmod.item.QuantumMarkerItem;
import com.michelmuscle.slidersmod.menu.QuantumRecallStationMenu;
import com.michelmuscle.slidersmod.network.ExodusVortexBeamPacket;
import com.michelmuscle.slidersmod.network.ModNetworking;
import com.michelmuscle.slidersmod.portal.VortexImmersivePortalHelper;
import com.michelmuscle.slidersmod.portal.VortexPortalPlacement;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuantumRecallStationBlockEntity
extends BlockEntity
implements MenuProvider {
    private static final int CAPACITY = 200000;
    private static final int COST_RECALL = 200000;
    private static final int ENERGY_PULL_PER_TICK = 500;
    private static final int MIN_DISTANCE = 3;
    private static final int MAX_DISTANCE = 10;
    private static final String VORTEX_DISTANCE_TAG = "VortexDistance";
    private final CustomEnergyStorage energyStorage = new CustomEnergyStorage(200000, 500);
    private LazyOptional<IEnergyStorage> energyCapability = LazyOptional.of(() -> this.energyStorage);
    private ItemStack markerStack = ItemStack.f_41583_;
    private ItemStack lastMarkerStack = ItemStack.f_41583_;
    private UUID markedEntityUUID = null;
    private String markedEntityDimension = null;
    private double markedEntityX = 0.0;
    private double markedEntityY = 0.0;
    private double markedEntityZ = 0.0;
    private String markedEntityName = "Unknown";
    private String markedEntityType = "Unknown";
    private long markedEntityGameTime = 0L;
    private static final long MAX_MARK_AGE_TICKS = 36000L;
    private long lastRecallTime = -36000L;
    private static final long COOLDOWN_TICKS = 36000L;
    private int recallCountdown = 0;
    private static final int RECALL_DELAY_TICKS = 200;
    private static final int STATION_CHARGE_TICKS = 180;
    private static final int STATION_LASER_TICKS = 20;
    private static final int VORTEX_VISUAL_TICKS = 200;
    private int stationChargeTicks = 0;
    private int stationVortexTicks = 0;
    private int returnVortexTicks = 0;
    private int vortexDistance = 5;
    private UUID lastStationVortexId = null;
    private UUID lastReturnVortexId = null;
    private ResourceKey<Level> lastReturnVortexDimension = null;
    private Vec3 lastReturnNormal = null;
    private Vec3 lastStationCenter = null;
    private Vec3 lastStationNormal = null;

    public QuantumRecallStationBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.QUANTUM_RECALL_STATION.get(), pos, blockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, QuantumRecallStationBlockEntity entity) {
        if (level.f_46443_) {
            boolean shouldPlaySound;
            boolean bl = shouldPlaySound = entity.recallCountdown > 0 && entity.stationChargeTicks > 0;
            if (shouldPlaySound && !BlockSoundManager.isSoundPlaying(pos)) {
                BlockSoundManager.startBlockSound(pos, (SoundEvent)ModSounds.QUANTUM_RECALL_STATION_ACTIVE.get());
            } else if (!shouldPlaySound && BlockSoundManager.isSoundPlaying(pos)) {
                BlockSoundManager.stopBlockSound(pos);
            }
            return;
        }
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int prevCountdown = entity.recallCountdown;
        int prevChargeTicks = entity.stationChargeTicks;
        int prevVortexTicks = entity.stationVortexTicks;
        entity.checkAndLinkMarker(serverLevel);
        entity.pullEnergyFromNeighbors(serverLevel);
        entity.tickCountdown(serverLevel);
        if (prevCountdown != entity.recallCountdown || prevChargeTicks != entity.stationChargeTicks || prevVortexTicks != entity.stationVortexTicks) {
            entity.m_6596_();
            level.m_7260_(pos, state, state, 3);
        }
    }

    private void tickCountdown(ServerLevel level) {
        if (this.hasMarkedEntity() && this.isMarkExpired(level)) {
            this.clearMarkedEntity();
        }
        if (this.recallCountdown > 0) {
            --this.recallCountdown;
            if (this.recallCountdown % 20 == 0 && this.recallCountdown > 0) {
                ServerPlayer markedPlayer;
                int secondsRemaining = this.recallCountdown / 20;
                if (this.markedEntityUUID != null && (markedPlayer = level.m_7654_().m_6846_().m_11259_(this.markedEntityUUID)) != null) {
                    markedPlayer.m_5661_((Component)Component.m_237113_((String)("\u00a76[Quantum Recall] You will be recalled in " + secondsRemaining + " seconds!")), false);
                }
            }
            if (this.stationChargeTicks > 0) {
                --this.stationChargeTicks;
                if (this.stationChargeTicks == 20) {
                    level.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.VORTEX_OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.fireLaser(level);
                }
            }
            if (this.recallCountdown <= 0) {
                this.executeRecall(level);
                this.recallCountdown = 0;
            }
        }
        if (this.stationVortexTicks > 0) {
            --this.stationVortexTicks;
            if (this.stationVortexTicks == 0 && this.lastStationVortexId != null) {
                Entity e = level.m_8791_(this.lastStationVortexId);
                if (e instanceof VortexEntity) {
                    VortexEntity v = (VortexEntity)e;
                    v.closeWithAnimation();
                    level.m_5594_(null, v.m_20183_(), (SoundEvent)ModSounds.VORTEX_CLOSE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                this.lastStationVortexId = null;
            }
        }
        if (this.returnVortexTicks > 0) {
            --this.returnVortexTicks;
            this.tickReturnTeleport(level);
            if (this.returnVortexTicks == 0) {
                this.closeReturnVortex(level);
            }
        }
    }

    public void markEntity(LivingEntity entity) {
        this.markedEntityUUID = entity.m_20148_();
        this.markedEntityDimension = entity.m_9236_().m_46472_().m_135782_().toString();
        this.markedEntityX = entity.m_20185_();
        this.markedEntityY = entity.m_20186_();
        this.markedEntityZ = entity.m_20189_();
        this.markedEntityName = entity.m_5446_().getString();
        this.markedEntityType = entity.m_6095_().m_20676_().getString();
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.markedEntityGameTime = serverLevel.m_46467_();
        }
        this.m_6596_();
        this.sendUpdate();
    }

    public void clearMarkedEntity() {
        this.markedEntityUUID = null;
        this.markedEntityDimension = null;
        this.markedEntityName = "Unknown";
        this.markedEntityType = "Unknown";
        this.markedEntityX = 0.0;
        this.markedEntityY = 0.0;
        this.markedEntityZ = 0.0;
        this.markedEntityGameTime = 0L;
        this.m_6596_();
        this.sendUpdate();
    }

    public void setVortexDistance(int distance) {
        int clamped = Math.max(3, Math.min(10, distance));
        if (this.vortexDistance != clamped) {
            this.vortexDistance = clamped;
            this.m_6596_();
            this.sendUpdate();
        }
    }

    public int getVortexDistance() {
        return this.vortexDistance;
    }

    public static int getMinDistance() {
        return 3;
    }

    public static int getMaxDistance() {
        return 10;
    }

    public boolean hasMarkedEntity() {
        return this.markedEntityUUID != null && this.markedEntityDimension != null;
    }

    public boolean isMarkExpired(ServerLevel level) {
        if (!this.hasMarkedEntity()) {
            return true;
        }
        long age = level.m_46467_() - this.markedEntityGameTime;
        return age > 36000L;
    }

    public long getRemainingMarkTicks(ServerLevel level) {
        if (!this.hasMarkedEntity()) {
            return 0L;
        }
        long age = level.m_46467_() - this.markedEntityGameTime;
        return Math.max(0L, 36000L - age);
    }

    public void initiateRecall(ServerLevel level) {
        if (!this.hasMarkedEntity()) {
            return;
        }
        if (this.isMarkExpired(level)) {
            this.clearMarkedEntity();
            return;
        }
        if (this.energyStorage.getEnergyStored() < 200000) {
            return;
        }
        long timeSinceLastRecall = level.m_46467_() - this.lastRecallTime;
        if (timeSinceLastRecall < 36000L) {
            return;
        }
        this.recallCountdown = 200;
        this.stationChargeTicks = 200;
        this.stationVortexTicks = 0;
        this.returnVortexTicks = 0;
        this.lastStationVortexId = null;
        this.lastReturnVortexId = null;
        this.lastReturnVortexDimension = null;
        this.lastStationCenter = null;
        this.lastStationNormal = null;
        ServerPlayer markedPlayer = level.m_7654_().m_6846_().m_11259_(this.markedEntityUUID);
        if (markedPlayer != null) {
            markedPlayer.m_5661_((Component)Component.m_237113_((String)"\u00a76[Quantum Recall] A recall sequence has been initiated! You will be teleported in 10 seconds!"), false);
        }
        if (ModSounds.QUANTUM_LOADING.isPresent()) {
            level.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.QUANTUM_LOADING.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            level.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.PROTO_LOADING.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        this.m_6596_();
    }

    private void executeRecall(ServerLevel level) {
        ServerLevel targetLevel;
        if (!this.hasMarkedEntity()) {
            return;
        }
        if (this.isMarkExpired(level)) {
            this.clearMarkedEntity();
            return;
        }
        this.energyStorage.extractEnergy(200000, false);
        this.lastRecallTime = level.m_46467_();
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            return;
        }
        ResourceLocation dimId = ResourceLocation.m_135820_((String)this.markedEntityDimension);
        ServerLevel serverLevel = targetLevel = dimId != null ? server.m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimId)) : level;
        if (targetLevel == null) {
            return;
        }
        Entity entity = targetLevel.m_8791_(this.markedEntityUUID);
        if (entity == null) {
            for (Entity e : targetLevel.m_8583_()) {
                if (!this.markedEntityUUID.equals(e.m_20148_())) continue;
                entity = e;
                break;
            }
        }
        if (entity == null) {
            return;
        }
        Vec3 sourcePos = entity.m_20182_();
        this.returnVortexTicks = 200;
        this.stationVortexTicks = 200;
        level.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.VORTEX_OPEN.get(), SoundSource.BLOCKS, 1.0f, 0.8f);
        this.spawnStationVortex(level);
        this.spawnReturnVortex(targetLevel, sourcePos);
        if (entity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)entity;
        } else {
            ServerLevel stationLevel;
            Entity newEnt;
            Level level2;
            Entity teleported = entity;
            Vec3 dest = this.computeArrivalPosition();
            if (entity.m_9236_() != this.f_58857_ && entity.m_6072_() && (level2 = this.f_58857_) instanceof ServerLevel && (newEnt = entity.m_5489_(stationLevel = (ServerLevel)level2)) != null) {
                teleported = newEnt;
            }
            teleported.m_6021_(dest.f_82479_, dest.f_82480_, dest.f_82481_);
            this.applyExitImpulse(teleported);
            level2 = this.f_58857_;
            if (level2 instanceof ServerLevel) {
                stationLevel = (ServerLevel)level2;
                stationLevel.m_5594_(null, teleported.m_20183_(), (SoundEvent)ModSounds.VORTEX_GO.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        this.m_6596_();
        this.sendUpdate();
    }

    private void spawnRecallVortexAtMarkedLocation(ServerLevel recallStation, ServerLevel markedLevel) {
    }

    private void fireLaser(ServerLevel level) {
        Entity e;
        Vec3 start;
        Vec3 end = start = new Vec3((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 1.2, (double)this.m_58899_().m_123343_() + 0.5);
        if (this.lastStationVortexId != null && (e = level.m_8791_(this.lastStationVortexId)) != null) {
            end = e.m_20182_().m_82520_(0.0, (double)e.m_20206_() * 0.5, 0.0);
        }
        if (end == start) {
            Direction facing = this.m_58900_().m_61145_((Property)BlockStateProperties.f_61374_).orElse(Direction.NORTH).m_122424_();
            end = start.m_82520_((double)(facing.m_122429_() * this.vortexDistance), 1.0, (double)(facing.m_122431_() * this.vortexDistance));
        }
        PacketDistributor.TargetPoint targetPoint = new PacketDistributor.TargetPoint(end.f_82479_, end.f_82480_, end.f_82481_, 128.0, level.m_46472_());
        ModNetworking.CHANNEL.send(PacketDistributor.NEAR.with(() -> targetPoint), (Object)new ExodusVortexBeamPacket(start, end));
    }

    private void spawnStationVortex(ServerLevel level) {
        Vec3 axisH;
        if (level == null) {
            return;
        }
        BlockState state = this.m_58900_();
        Direction facing = state.m_61138_((Property)BlockStateProperties.f_61374_) ? ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_() : Direction.NORTH;
        double distance = this.vortexDistance;
        double vx = (double)this.m_58899_().m_123341_() + 0.5 + (double)facing.m_122429_() * distance;
        double vz = (double)this.m_58899_().m_123343_() + 0.5 + (double)facing.m_122431_() * distance;
        double vy = (double)this.m_58899_().m_123342_() + 2.2;
        Vec3 center = new Vec3(vx, vy, vz);
        Vec3 normal = new Vec3((double)facing.m_122429_(), 0.0, (double)facing.m_122431_()).m_82541_();
        Vec3 axisW = normal.m_82537_(axisH = new Vec3(0.0, 1.0, 0.0));
        if (axisW.m_82556_() < 1.0E-4) {
            axisW = new Vec3(1.0, 0.0, 0.0);
        }
        axisH = axisW.m_82537_(normal).m_82541_();
        VortexPortalPlacement placement = new VortexPortalPlacement(center, axisW, axisH, normal, true);
        ItemStack dummy = new ItemStack((ItemLike)ModItems.ORIGINAL_TIMER.get());
        dummy.m_41784_().m_128379_("IsProtoVortex", true);
        VortexEntity vortex = new VortexEntity((Level)level, vx, vy, vz, true, false, false, false, false, true);
        vortex.setTimerStack(dummy);
        vortex.setCollisionVolumesEnabled(false, false);
        vortex.setLifetimeTicks(0);
        vortex.markAsAlreadyUsed();
        level.m_7967_((Entity)vortex);
        VortexImmersivePortalHelper.attachVisuals(level, vortex, placement, null);
        this.lastStationVortexId = vortex.m_20148_();
        this.lastStationCenter = placement.center();
        this.lastStationNormal = placement.normal();
        level.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.VORTEX_OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private Vec3 computeArrivalPosition() {
        if (this.lastStationCenter != null && this.lastStationNormal != null) {
            return this.lastStationCenter.m_82549_(this.lastStationNormal.m_82490_(0.8)).m_82520_(0.0, 0.2, 0.0);
        }
        return new Vec3((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 1.0, (double)this.m_58899_().m_123343_() + 0.5);
    }

    private Vec3 computeExitImpulse() {
        Vec3 normal = this.lastStationNormal != null ? this.lastStationNormal.m_82541_() : new Vec3(0.0, 0.0, 1.0);
        return normal.m_82490_(-0.8).m_82520_(0.0, 0.2, 0.0);
    }

    private void applyExitImpulse(Entity entity) {
        Vec3 impulse = this.computeExitImpulse();
        entity.m_20256_(impulse);
    }

    private void playTraverseCue(Vec3 pos, ServerLevel level) {
        BlockPos bpos = BlockPos.m_274446_((Position)pos);
        level.m_5594_(null, bpos, (SoundEvent)ModSounds.VORTEX_GO.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123759_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 12, 0.2, 0.2, 0.2, 0.01);
    }

    private void spawnReturnVortex(ServerLevel targetLevel, Vec3 sourcePos) {
        Vec3 axisH;
        Vec3 normal;
        Vec3 axisW;
        if (targetLevel == null) {
            return;
        }
        if (this.f_58857_ == null) {
            return;
        }
        Vec3 destCenter = new Vec3((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 2.2, (double)this.m_58899_().m_123343_() + 0.5);
        Vec3 facing = new Vec3(destCenter.f_82479_ - sourcePos.f_82479_, 0.0, destCenter.f_82481_ - sourcePos.f_82481_);
        if (facing.m_82556_() < 1.0E-4) {
            facing = new Vec3(0.0, 0.0, 1.0);
        }
        if ((axisW = (normal = (facing = facing.m_82541_()).m_82490_(-1.0)).m_82537_(axisH = new Vec3(0.0, 1.0, 0.0))).m_82556_() < 1.0E-4) {
            axisW = new Vec3(1.0, 0.0, 0.0);
        }
        axisH = axisW.m_82537_(normal).m_82541_();
        Vec3 center = sourcePos.m_82546_(facing.m_82490_(1.5)).m_82520_(0.0, 2.6, 0.0);
        VortexPortalPlacement placement = new VortexPortalPlacement(center, axisW, axisH, normal, true);
        ItemStack dummy = new ItemStack((ItemLike)ModItems.ORIGINAL_TIMER.get());
        CompoundTag tag = dummy.m_41784_();
        tag.m_128359_("ReturnDimension", this.f_58857_.m_46472_().m_135782_().toString());
        tag.m_128347_("ReturnX", destCenter.f_82479_);
        tag.m_128347_("ReturnY", destCenter.f_82480_);
        tag.m_128347_("ReturnZ", destCenter.f_82481_);
        tag.m_128379_("IsActive", true);
        tag.m_128356_("ActivationTime", targetLevel.m_46467_());
        tag.m_128379_("IsProtoVortex", true);
        VortexEntity returnVortex = new VortexEntity((Level)targetLevel, center.f_82479_, center.f_82480_, center.f_82481_, true, false, false, false, false, true);
        returnVortex.setTimerStack(dummy);
        returnVortex.setOwnerUUID(this.markedEntityUUID);
        returnVortex.setLifetimeTicks(0);
        returnVortex.markAsAlreadyUsed();
        if (this.lastStationVortexId != null) {
            returnVortex.setLinkedAestheticVortex(this.lastStationVortexId);
        }
        targetLevel.m_7967_((Entity)returnVortex);
        VortexImmersivePortalHelper.attachVisuals(targetLevel, returnVortex, placement, null);
        targetLevel.m_5594_(null, returnVortex.m_20183_(), (SoundEvent)ModSounds.VORTEX_INCOMING.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        this.lastReturnVortexId = returnVortex.m_20148_();
        this.lastReturnVortexDimension = targetLevel.m_46472_();
        this.lastReturnNormal = normal;
    }

    private void closeReturnVortex(ServerLevel stationLevel) {
        Entity e;
        ServerLevel maybe;
        if (this.lastReturnVortexId == null) {
            this.lastReturnVortexDimension = null;
            this.lastReturnNormal = null;
            return;
        }
        ServerLevel targetLevel = stationLevel;
        if (stationLevel.m_7654_() != null && this.lastReturnVortexDimension != null && (maybe = stationLevel.m_7654_().m_129880_(this.lastReturnVortexDimension)) != null) {
            targetLevel = maybe;
        }
        if ((e = targetLevel.m_8791_(this.lastReturnVortexId)) instanceof VortexEntity) {
            VortexEntity v = (VortexEntity)e;
            v.closeWithAnimation();
            targetLevel.m_5594_(null, v.m_20183_(), (SoundEvent)ModSounds.VORTEX_CLOSE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        this.lastReturnVortexId = null;
        this.lastReturnVortexDimension = null;
        this.lastReturnNormal = null;
    }

    private void tickReturnTeleport(ServerLevel stationLevel) {
        Vec3 dest;
        ServerLevel targetLevel;
        if (this.lastReturnVortexId == null || stationLevel.m_7654_() == null) {
            return;
        }
        int elapsedTicks = 200 - this.returnVortexTicks;
        if (elapsedTicks < 10) {
            return;
        }
        ServerLevel serverLevel = targetLevel = this.lastReturnVortexDimension != null ? stationLevel.m_7654_().m_129880_(this.lastReturnVortexDimension) : stationLevel;
        if (targetLevel == null) {
            return;
        }
        Entity portalEntity = targetLevel.m_8791_(this.lastReturnVortexId);
        if (!(portalEntity instanceof VortexEntity)) {
            return;
        }
        VortexEntity vortex = (VortexEntity)portalEntity;
        double radius = 0.85;
        Vec3 center = vortex.m_20182_();
        AABB box = new AABB(center.f_82479_ - radius, center.f_82480_ - radius, center.f_82481_ - radius, center.f_82479_ + radius, center.f_82480_ + radius, center.f_82481_ + radius);
        for (Player p : targetLevel.m_45976_(Player.class, box)) {
            Vec3 towardPortal;
            if (this.lastReturnNormal != null && (towardPortal = p.m_20182_().m_82546_(center)).m_82526_(this.lastReturnNormal) <= 0.0) continue;
            dest = this.computeArrivalPosition();
            if (p instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)p;
                if (sp.m_9236_() != stationLevel) {
                    sp.m_8999_(stationLevel, dest.f_82479_, dest.f_82480_, dest.f_82481_, sp.m_146908_(), sp.m_146909_());
                } else {
                    sp.m_6021_(dest.f_82479_, dest.f_82480_, dest.f_82481_);
                }
            } else {
                p.m_6021_(dest.f_82479_, dest.f_82480_, dest.f_82481_);
            }
            this.applyExitImpulse((Entity)p);
            this.playTraverseCue(p.m_20182_(), targetLevel);
            this.playTraverseCue(dest, stationLevel);
            this.grantBackImmunityOnExit(stationLevel);
        }
        for (ItemEntity item : targetLevel.m_45976_(ItemEntity.class, box)) {
            dest = this.computeArrivalPosition();
            item.m_6021_(dest.f_82479_, dest.f_82480_, dest.f_82481_);
            item.m_20256_(Vec3.f_82478_);
            this.playTraverseCue(item.m_20182_(), targetLevel);
            this.playTraverseCue(dest, stationLevel);
        }
    }

    private void grantBackImmunityOnExit(ServerLevel stationLevel) {
        if (this.lastStationVortexId == null) {
            return;
        }
        Entity e = stationLevel.m_8791_(this.lastStationVortexId);
        if (e instanceof VortexEntity) {
            VortexEntity v = (VortexEntity)e;
            v.grantBackCollisionImmunity(this.markedEntityUUID, 100);
        }
    }

    public int getEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    public int getEnergyCapacity() {
        return 200000;
    }

    public static int getRecallCost() {
        return 200000;
    }

    public ItemStack getMarkerStack() {
        return this.markerStack;
    }

    public void setMarkerStack(ItemStack stack) {
        this.markerStack = stack.m_41777_();
        this.markerStack.m_41764_(Math.min(stack.m_41613_(), 64));
        this.m_6596_();
    }

    private void checkAndLinkMarker(ServerLevel level) {
        if (!ItemStack.m_41728_((ItemStack)this.markerStack, (ItemStack)this.lastMarkerStack)) {
            this.lastMarkerStack = this.markerStack.m_41777_();
            if (!this.markerStack.m_41619_()) {
                QuantumMarkerItem markerItem;
                QuantumMarkerItem quantumMarkerItem = markerItem = this.markerStack.m_41720_() instanceof QuantumMarkerItem ? (QuantumMarkerItem)this.markerStack.m_41720_() : null;
                if (markerItem != null && !QuantumMarkerItem.isLinkedToBlock(this.markerStack)) {
                    QuantumMarkerItem.linkToBlock(this.markerStack, this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_(), level.m_46472_().m_135782_().toString());
                    this.m_6596_();
                }
            }
        }
        if (!this.markerStack.m_41619_() && QuantumMarkerItem.isMarked(this.markerStack)) {
            CompoundTag markerTag;
            UUID markerMarkedUUID = QuantumMarkerItem.getMarkedEntityUUID(this.markerStack);
            if (markerMarkedUUID != null && !markerMarkedUUID.equals(this.markedEntityUUID) && (markerTag = this.markerStack.m_41783_()) != null) {
                this.markedEntityUUID = markerMarkedUUID;
                this.markedEntityDimension = markerTag.m_128461_("MarkedEntityDimension");
                this.markedEntityX = markerTag.m_128459_("MarkedEntityX");
                this.markedEntityY = markerTag.m_128459_("MarkedEntityY");
                this.markedEntityZ = markerTag.m_128459_("MarkedEntityZ");
                this.markedEntityName = markerTag.m_128461_("MarkedEntityName");
                this.markedEntityType = markerTag.m_128461_("MarkedEntityType");
                if (markerTag.m_128441_("MarkedEntityGameTime")) {
                    this.markedEntityGameTime = markerTag.m_128454_("MarkedEntityGameTime");
                }
                this.m_6596_();
                this.sendUpdate();
            }
        } else if (!this.markerStack.m_41619_() && !QuantumMarkerItem.isMarked(this.markerStack) && this.markedEntityUUID != null) {
            this.clearMarkedEntity();
        }
    }

    private void sendUpdate() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = this.m_58899_();
            serverLevel.m_7260_(pos, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public boolean isOnCooldown(ServerLevel level) {
        long timeSinceLastRecall = level.m_46467_() - this.lastRecallTime;
        return timeSinceLastRecall < 36000L;
    }

    public long getRemainingCooldownTicks(ServerLevel level) {
        long timeSinceLastRecall = level.m_46467_() - this.lastRecallTime;
        return Math.max(0L, 36000L - timeSinceLastRecall);
    }

    public String getMarkedEntityInfo() {
        if (!this.hasMarkedEntity()) {
            return "\u00a77No entity marked";
        }
        return "\u00a76" + this.markedEntityName + " (\u00a7e" + this.markedEntityType + "\u00a76)\n\u00a77" + this.markedEntityDimension;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return new QuantumRecallStationMenu(containerId, playerInventory, this, player);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Quantum Recall Station");
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Energy")) {
            this.energyStorage.setEnergy(tag.m_128451_("Energy"));
        }
        if (tag.m_128441_("MarkerStack")) {
            this.markerStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("MarkerStack"));
        }
        this.lastMarkerStack = this.markerStack.m_41777_();
        if (tag.m_128403_("MarkedEntityUUID")) {
            this.markedEntityUUID = tag.m_128342_("MarkedEntityUUID");
            this.markedEntityDimension = tag.m_128461_("MarkedEntityDimension");
            this.markedEntityX = tag.m_128459_("MarkedEntityX");
            this.markedEntityY = tag.m_128459_("MarkedEntityY");
            this.markedEntityZ = tag.m_128459_("MarkedEntityZ");
            this.markedEntityName = tag.m_128461_("MarkedEntityName");
            this.markedEntityType = tag.m_128461_("MarkedEntityType");
            this.markedEntityGameTime = tag.m_128454_("MarkedEntityGameTime");
        }
        this.lastRecallTime = tag.m_128454_("LastRecallTime");
        if (tag.m_128441_(VORTEX_DISTANCE_TAG)) {
            this.vortexDistance = Math.max(3, Math.min(10, tag.m_128451_(VORTEX_DISTANCE_TAG)));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Energy", this.energyStorage.getEnergyStored());
        if (!this.markerStack.m_41619_()) {
            tag.m_128365_("MarkerStack", (Tag)this.markerStack.serializeNBT());
        }
        if (this.markedEntityUUID != null) {
            tag.m_128362_("MarkedEntityUUID", this.markedEntityUUID);
            tag.m_128359_("MarkedEntityDimension", this.markedEntityDimension);
            tag.m_128347_("MarkedEntityX", this.markedEntityX);
            tag.m_128347_("MarkedEntityY", this.markedEntityY);
            tag.m_128347_("MarkedEntityZ", this.markedEntityZ);
            tag.m_128359_("MarkedEntityName", this.markedEntityName);
            tag.m_128359_("MarkedEntityType", this.markedEntityType);
            tag.m_128356_("MarkedEntityGameTime", this.markedEntityGameTime);
        }
        tag.m_128356_("LastRecallTime", this.lastRecallTime);
        tag.m_128405_(VORTEX_DISTANCE_TAG, this.vortexDistance);
    }

    public void drops() {
    }

    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
        if (capability == ForgeCapabilities.ENERGY) {
            return this.energyCapability.cast();
        }
        return super.getCapability(capability, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyCapability.invalidate();
    }

    private void pullEnergyFromNeighbors(ServerLevel serverLevel) {
        int remaining = this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored();
        if (remaining <= 0) {
            return;
        }
        remaining = Math.min(remaining, 500);
        for (Direction dir : Direction.values()) {
            int extracted;
            IEnergyStorage src;
            if (remaining <= 0) break;
            BlockPos adjPos = this.f_58858_.m_121945_(dir);
            BlockEntity be = serverLevel.m_7702_(adjPos);
            if (be == null || (src = (IEnergyStorage)be.getCapability(ForgeCapabilities.ENERGY, dir.m_122424_()).orElse(null)) == null || !src.canExtract() || (extracted = src.extractEnergy(remaining, false)) <= 0) continue;
            this.energyStorage.receiveEnergy(extracted, false);
            remaining -= extracted;
        }
    }

    private class CustomEnergyStorage
    implements IEnergyStorage {
        private int energy = 0;
        private final int capacity;
        private final int maxReceive;

        public CustomEnergyStorage(int capacity, int maxReceive) {
            this.capacity = capacity;
            this.maxReceive = maxReceive;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
            if (!simulate) {
                this.energy += energyReceived;
                QuantumRecallStationBlockEntity.this.m_6596_();
                QuantumRecallStationBlockEntity.this.m_6596_();
            }
            return energyReceived;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int energyExtracted = Math.min(this.energy, maxExtract);
            if (!simulate) {
                this.energy -= energyExtracted;
                QuantumRecallStationBlockEntity.this.m_6596_();
                QuantumRecallStationBlockEntity.this.m_6596_();
            }
            return energyExtracted;
        }

        public int getEnergyStored() {
            return this.energy;
        }

        public int getMaxEnergyStored() {
            return this.capacity;
        }

        public boolean canReceive() {
            return true;
        }

        public boolean canExtract() {
            return false;
        }

        public void setEnergy(int energy) {
            this.energy = energy;
        }
    }
}

