/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.block.entity;

import com.michelmuscle.slidersmod.advancements.AchievementManager;
import com.michelmuscle.slidersmod.client.sound.BlockSoundManager;
import com.michelmuscle.slidersmod.init.ModBlockEntities;
import com.michelmuscle.slidersmod.init.ModItems;
import com.michelmuscle.slidersmod.init.ModSounds;
import com.michelmuscle.slidersmod.menu.ResearchTableMenu;
import com.michelmuscle.slidersmod.util.UpgradeInstance;
import com.michelmuscle.slidersmod.util.UpgradeRarity;
import com.michelmuscle.slidersmod.util.UpgradeType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResearchTableBlockEntity
extends BlockEntity
implements MenuProvider,
Container {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 1;
    private static final int SLOT_COUNT = 2;
    private static final int PROCESS_TIME = 600;
    private static final int ENERGY_CAPACITY = 100000;
    private static final int MAX_RECEIVE = 1000;
    private static final int[] SUCCESS_CHANCE = new int[]{40, 50, 60, 75, 100};
    private static final int[] ENERGY_COST = new int[]{5000, 8000, 12000, 18000, 25000};
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            ResearchTableBlockEntity.this.m_6596_();
            ResearchTableBlockEntity.this.handleInventoryChanged(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 1) {
                return false;
            }
            return stack.m_150930_((Item)ModItems.SLIDE_ENHANCEMENT_CHIP.get());
        }

        public int getSlotLimit(int slot) {
            return slot == 0 ? 5 : super.getSlotLimit(slot);
        }
    };
    private final LazyOptional<ItemStackHandler> itemCapability = LazyOptional.of(() -> this.itemHandler);
    private final CustomEnergyStorage energyStorage = new CustomEnergyStorage(100000, 1000);
    private final LazyOptional<IEnergyStorage> energyCapability = LazyOptional.of(() -> this.energyStorage);
    private int progress = 0;
    private ResearchState state = ResearchState.IDLE;
    private int activeChance = 0;
    private int activeEnergyCost = 0;
    private int chipsToConsume = 0;
    private final ContainerData data = new SimpleContainerData(7){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> ResearchTableBlockEntity.this.progress;
                case 1 -> 600;
                case 2 -> ResearchTableBlockEntity.this.energyStorage.getEnergyStored();
                case 3 -> ResearchTableBlockEntity.this.energyStorage.getMaxEnergyStored();
                case 4 -> ResearchTableBlockEntity.this.state.ordinal();
                case 5 -> ResearchTableBlockEntity.this.activeChance;
                case 6 -> ResearchTableBlockEntity.this.activeEnergyCost;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    ResearchTableBlockEntity.this.progress = value;
                    break;
                }
                case 2: {
                    ResearchTableBlockEntity.this.energyStorage.setEnergy(value);
                    break;
                }
                case 4: {
                    ResearchTableBlockEntity.this.state = ResearchState.fromOrdinal(value);
                    break;
                }
                case 5: {
                    ResearchTableBlockEntity.this.activeChance = value;
                    break;
                }
                case 6: {
                    ResearchTableBlockEntity.this.activeEnergyCost = value;
                    break;
                }
            }
        }

        public int m_6499_() {
            return 7;
        }
    };

    public ResearchTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.RESEARCH_TABLE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ResearchTableBlockEntity entity) {
        if (level.f_46443_) {
            if (entity.state == ResearchState.PROCESSING && !BlockSoundManager.isSoundPlaying(pos)) {
                BlockSoundManager.startBlockSound(pos, (SoundEvent)ModSounds.RESEARCH_TABLE_ACTIVE.get());
            } else if (entity.state != ResearchState.PROCESSING && BlockSoundManager.isSoundPlaying(pos)) {
                BlockSoundManager.stopBlockSound(pos);
            }
            return;
        }
        boolean dirty = false;
        if (entity.state == ResearchState.PROCESSING) {
            ItemStack inputStack = entity.itemHandler.getStackInSlot(0);
            if (inputStack.m_41619_() || !inputStack.m_150930_((Item)ModItems.SLIDE_ENHANCEMENT_CHIP.get())) {
                entity.state = ResearchState.IDLE;
                entity.progress = 0;
                dirty = true;
            } else {
                ++entity.progress;
                if (entity.progress >= 600) {
                    entity.finishResearch();
                    dirty = true;
                }
            }
        } else if (entity.canStartResearch()) {
            entity.beginResearch();
            dirty = true;
        } else if (entity.state == ResearchState.IDLE) {
            entity.updatePreviewStats();
        }
        if (dirty) {
            entity.m_6596_();
            level.m_7260_(pos, state, state, 3);
        }
    }

    private void beginResearch() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        int available = Math.min(stack.m_41613_(), 5);
        if (available <= 0) {
            return;
        }
        int chance = SUCCESS_CHANCE[available - 1];
        int cost = ENERGY_COST[available - 1];
        if (this.energyStorage.getEnergyStored() < cost) {
            return;
        }
        this.energyStorage.extractEnergy(cost, false);
        this.progress = 0;
        this.chipsToConsume = available;
        this.activeChance = chance;
        this.activeEnergyCost = cost;
        this.state = ResearchState.PROCESSING;
    }

    private void finishResearch() {
        ItemStack in;
        boolean success;
        this.progress = 0;
        ServerLevel serverLevel = this.f_58857_ instanceof ServerLevel ? (ServerLevel)this.f_58857_ : null;
        boolean bl = success = serverLevel != null && serverLevel.f_46441_.m_188503_(100) < this.activeChance;
        if (success && serverLevel != null) {
            ItemStack reward = ResearchTableBlockEntity.getRandomUpgrade(serverLevel.f_46441_, this.chipsToConsume);
            if (reward.m_41619_()) {
                success = false;
            } else {
                ItemStack output = this.itemHandler.getStackInSlot(1);
                if (output.m_41619_()) {
                    this.itemHandler.setStackInSlot(1, reward);
                } else {
                    Containers.m_18992_((Level)serverLevel, (double)((double)this.f_58858_.m_123341_() + 0.5), (double)((double)this.f_58858_.m_123342_() + 0.5), (double)((double)this.f_58858_.m_123343_() + 0.5), (ItemStack)reward);
                }
            }
        }
        if (this.chipsToConsume > 0 && !(in = this.itemHandler.getStackInSlot(0)).m_41619_()) {
            int toRemove = Math.min(this.chipsToConsume, in.m_41613_());
            this.itemHandler.extractItem(0, toRemove, false);
        }
        this.state = success ? ResearchState.SUCCESS : ResearchState.FAILURE;
        this.chipsToConsume = 0;
        if (serverLevel != null) {
            for (ServerPlayer player : serverLevel.m_8795_(p -> p.m_20183_().m_123331_((Vec3i)this.f_58858_) < 100.0)) {
                if (success) {
                    AchievementManager.resetResearchFailures(player);
                    continue;
                }
                AchievementManager.addResearchFailure(player);
            }
        }
    }

    private boolean canStartResearch() {
        if (!this.itemHandler.getStackInSlot(1).m_41619_()) {
            return false;
        }
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.m_41619_() || !stack.m_150930_((Item)ModItems.SLIDE_ENHANCEMENT_CHIP.get())) {
            return false;
        }
        int available = Math.min(stack.m_41613_(), 5);
        int cost = ENERGY_COST[available - 1];
        this.activeChance = SUCCESS_CHANCE[available - 1];
        this.activeEnergyCost = cost;
        return this.energyStorage.getEnergyStored() >= cost;
    }

    private void updatePreviewStats() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.m_41619_() || !stack.m_150930_((Item)ModItems.SLIDE_ENHANCEMENT_CHIP.get())) {
            this.activeChance = 0;
            this.activeEnergyCost = 0;
            return;
        }
        int available = Math.min(stack.m_41613_(), 5);
        this.activeChance = SUCCESS_CHANCE[available - 1];
        this.activeEnergyCost = ENERGY_COST[available - 1];
    }

    private static ItemStack getRandomUpgrade(RandomSource random, int chips) {
        List<SupplierEntry> pool = UpgradePools.forChips(chips);
        if (pool.isEmpty()) {
            return ItemStack.f_41583_;
        }
        SupplierEntry entry = ResearchTableBlockEntity.pickWeighted(pool, random);
        if (entry == null) {
            return ItemStack.f_41583_;
        }
        UpgradeRarity rolledRarity = ResearchTableBlockEntity.rollRarity(random);
        return ResearchTableBlockEntity.createUpgradeStack(entry.item(), rolledRarity, random);
    }

    private static UpgradeRarity rollRarity(RandomSource random) {
        int roll = random.m_188503_(100);
        if (roll < 55) {
            return UpgradeRarity.COMMON;
        }
        if (roll < 80) {
            return UpgradeRarity.UNCOMMON;
        }
        if (roll < 90) {
            return UpgradeRarity.RARE;
        }
        if (roll < 97) {
            return UpgradeRarity.EPIC;
        }
        return UpgradeRarity.LEGENDARY;
    }

    private static ItemStack createUpgradeStack(Item item, UpgradeRarity rarity, RandomSource random) {
        ItemStack stack = new ItemStack((ItemLike)item);
        UpgradeInstance inst = null;
        if (item == ModItems.OVERHEAT_PROBABILITY_REDUCER.get()) {
            inst = UpgradeInstance.createWithGeneratedValue(UpgradeType.OVERHEAT_PROBABILITY_REDUCER, rarity, random);
        } else if (item == ModItems.OVERHEAT_COOLDOWN_REDUCER.get()) {
            inst = UpgradeInstance.createWithGeneratedValue(UpgradeType.OVERHEAT_COOLDOWN_REDUCER, rarity, random);
        } else if (item == ModItems.TEMPORAL_STABILIZER.get()) {
            inst = UpgradeInstance.createWithGeneratedValue(UpgradeType.TEMPORAL_STABILIZER, rarity, random);
        } else if (item == ModItems.DIMENSIONAL_BUFFER.get()) {
            inst = UpgradeInstance.createWithGeneratedValue(UpgradeType.DIMENSIONAL_BUFFER_TIER3, rarity, random);
        } else if (item == ModItems.EGYPTIAN_TRACKER_UPGRADE.get()) {
            inst = UpgradeInstance.createWithGeneratedValue(UpgradeType.EGYPTIAN_TRACKER, UpgradeRarity.EPIC, random);
        } else if (item == ModItems.EXODUS_SEED_UPGRADE.get()) {
            inst = UpgradeInstance.createWithGeneratedValue(UpgradeType.EXODUS_SEED, UpgradeRarity.EPIC, random);
        } else if (item == ModItems.DIMENSION_ANCHOR.get()) {
            inst = UpgradeInstance.createWithGeneratedValue(UpgradeType.DIMENSION_ANCHOR, UpgradeRarity.EPIC, random);
        } else if (item == ModItems.CRYSTAL_BUFFER.get()) {
            inst = UpgradeInstance.createWithGeneratedValue(UpgradeType.CRYSTAL_BUFFER, UpgradeRarity.COMMON, random);
        } else if (item == ModItems.ADVANCED_CRYSTAL_BUFFER.get()) {
            inst = UpgradeInstance.createWithGeneratedValue(UpgradeType.CRYSTAL_BUFFER, UpgradeRarity.RARE, random);
        } else if (item == ModItems.ULTIMATE_CRYSTAL_BUFFER.get()) {
            inst = UpgradeInstance.createWithGeneratedValue(UpgradeType.CRYSTAL_BUFFER, UpgradeRarity.LEGENDARY, random);
        } else if (item == ModItems.SLOT_EXPANSER_UPGRADE.get()) {
            inst = new UpgradeInstance(UpgradeType.SLOT_EXPANDER, UpgradeRarity.UNCOMMON, 0.0);
        } else if (item == ModItems.VORTEX_CALIBRATOR.get()) {
            inst = new UpgradeInstance(UpgradeType.SLOT_EXPANDER, UpgradeRarity.EPIC, 0.0);
        }
        if (inst != null) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128347_("UpgradeValue", inst.getPrimaryValue());
            tag.m_128359_("UpgradeRarity", inst.getRarity().name());
        }
        return stack;
    }

    public void drops() {
        NonNullList drops = NonNullList.m_122780_((int)this.itemHandler.getSlots(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            drops.set(i, (Object)this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19010_((Level)this.f_58857_, (BlockPos)this.f_58858_, (NonNullList)drops);
    }

    private void handleInventoryChanged(int slot) {
        if (slot == 0 && this.state != ResearchState.PROCESSING) {
            this.state = ResearchState.IDLE;
            this.updatePreviewStats();
        }
        if (slot == 1 && this.itemHandler.getStackInSlot(1).m_41619_() && this.state != ResearchState.PROCESSING) {
            this.state = ResearchState.IDLE;
        }
    }

    public void clearStatus() {
        if (this.state == ResearchState.SUCCESS || this.state == ResearchState.FAILURE) {
            this.state = ResearchState.IDLE;
        }
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public ContainerData getContainerData() {
        return this.data;
    }

    public boolean isProcessing() {
        return this.state == ResearchState.PROCESSING;
    }

    public ResearchState getState() {
        return this.state;
    }

    public int m_6643_() {
        return 2;
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack result = this.itemHandler.extractItem(slot, amount, false);
        if (slot == 1 && result.m_41619_()) {
            this.handleInventoryChanged(slot);
        }
        return result;
    }

    public ItemStack m_8016_(int slot) {
        ItemStack stack = this.itemHandler.getStackInSlot(slot);
        this.itemHandler.setStackInSlot(slot, ItemStack.f_41583_);
        return stack;
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.itemHandler.setStackInSlot(slot, stack);
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.slidersmod.research_table");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new ResearchTableMenu(id, inventory, this, this.data);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128365_("energy", (Tag)this.energyStorage.serializeNBT());
        tag.m_128405_("progress", this.progress);
        tag.m_128405_("state", this.state.ordinal());
        tag.m_128405_("chance", this.activeChance);
        tag.m_128405_("energyCost", this.activeEnergyCost);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.energyStorage.deserializeNBT(tag.m_128423_("energy"));
        this.progress = tag.m_128451_("progress");
        this.state = ResearchState.fromOrdinal(tag.m_128451_("state"));
        this.activeChance = tag.m_128451_("chance");
        this.activeEnergyCost = tag.m_128451_("energyCost");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        if (capability == ForgeCapabilities.ENERGY) {
            return this.energyCapability.cast();
        }
        return super.getCapability(capability, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemCapability.invalidate();
        this.energyCapability.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.itemCapability.lazyMap(handler -> handler);
        this.energyCapability.lazyMap(storage -> storage);
    }

    private static SupplierEntry pickWeighted(List<SupplierEntry> pool, RandomSource random) {
        int total = pool.stream().mapToInt(SupplierEntry::weight).filter(w -> w > 0).sum();
        if (total <= 0) {
            return null;
        }
        int roll = random.m_188503_(total);
        int cumulative = 0;
        for (SupplierEntry entry : pool) {
            int w2 = Math.max(0, entry.weight());
            if (roll >= (cumulative += w2)) continue;
            return entry;
        }
        return pool.get(pool.size() - 1);
    }

    private static class CustomEnergyStorage
    implements IEnergyStorage {
        private int energy;
        private final int capacity;
        private final int maxReceive;

        CustomEnergyStorage(int capacity, int maxReceive) {
            this.capacity = capacity;
            this.maxReceive = maxReceive;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int received = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
            if (!simulate && received > 0) {
                this.energy += received;
            }
            return received;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int extracted = Math.min(this.energy, maxExtract);
            if (!simulate && extracted > 0) {
                this.energy -= extracted;
            }
            return extracted;
        }

        public int getEnergyStored() {
            return this.energy;
        }

        public int getMaxEnergyStored() {
            return this.capacity;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }

        void setEnergy(int value) {
            this.energy = Math.min(value, this.capacity);
        }

        CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("energy", this.energy);
            return tag;
        }

        void deserializeNBT(@Nullable Tag nbt) {
            if (nbt instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)nbt;
                this.energy = compound.m_128451_("energy");
            }
        }
    }

    public static enum ResearchState {
        IDLE,
        PROCESSING,
        SUCCESS,
        FAILURE;


        public static ResearchState fromOrdinal(int ordinal) {
            if (ordinal < 0 || ordinal >= ResearchState.values().length) {
                return IDLE;
            }
            return ResearchState.values()[ordinal];
        }
    }

    private static class UpgradePools {
        private static final List<SupplierEntry> TIER_ONE = List.of(new SupplierEntry((Item)ModItems.CRYSTAL_BUFFER.get(), 4), new SupplierEntry((Item)ModItems.PHASE_MODULATOR.get(), 4), new SupplierEntry((Item)ModItems.OVERHEAT_PROBABILITY_REDUCER.get(), 4), new SupplierEntry((Item)ModItems.TEMPORAL_STABILIZER.get(), 8), new SupplierEntry((Item)ModItems.OVERHEAT_COOLDOWN_REDUCER.get(), 4), new SupplierEntry((Item)ModItems.QUANTUM_RELOCATOR.get(), 4), new SupplierEntry((Item)ModItems.SLOT_EXPANSER_UPGRADE.get(), 4));
        private static final List<SupplierEntry> TIER_TWO = List.of(new SupplierEntry((Item)ModItems.DIMENSIONAL_BUFFER.get(), 4), new SupplierEntry((Item)ModItems.EGYPTIAN_TRACKER_UPGRADE.get(), 2), new SupplierEntry((Item)ModItems.PORTAL_STABILITY_UPGRADE.get(), 2));
        private static final List<SupplierEntry> TIER_THREE = List.of(new SupplierEntry((Item)ModItems.VORTEX_CALIBRATOR.get(), 1), new SupplierEntry((Item)ModItems.DIMENSION_ANCHOR.get(), 2), new SupplierEntry((Item)ModItems.EXODUS_SEED_UPGRADE.get(), 2));

        private UpgradePools() {
        }

        static List<SupplierEntry> forChips(int chips) {
            return switch (chips) {
                case 1, 2 -> TIER_ONE;
                case 3 -> UpgradePools.concat(TIER_ONE, TIER_TWO);
                case 4, 5 -> UpgradePools.concat(UpgradePools.concat(TIER_ONE, TIER_TWO), TIER_THREE);
                default -> List.of();
            };
        }

        private static List<SupplierEntry> concat(List<SupplierEntry> a, List<SupplierEntry> b) {
            ArrayList<SupplierEntry> combined = new ArrayList<SupplierEntry>(a.size() + b.size());
            combined.addAll(a);
            combined.addAll(b);
            return combined;
        }
    }

    private record SupplierEntry(Item item, int weight) {
    }
}

