/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.block.entity;

import com.michelmuscle.slidersmod.block.entity.CustomEnergyStorage;
import com.michelmuscle.slidersmod.client.sound.BlockSoundManager;
import com.michelmuscle.slidersmod.init.ModBlockEntities;
import com.michelmuscle.slidersmod.init.ModItems;
import com.michelmuscle.slidersmod.init.ModSounds;
import com.michelmuscle.slidersmod.menu.TimerSlotExpanderMenu;
import com.michelmuscle.slidersmod.util.TimerUpgradeSlots;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimerSlotExpanderBlockEntity
extends BlockEntity
implements MenuProvider,
Container {
    public static final int SLOT_TIMER = 0;
    public static final int SLOT_UPGRADE = 1;
    public static final int SLOT_OUTPUT = 2;
    private static final int SLOT_COUNT = 3;
    private static final int ENERGY_CAPACITY = 8000;
    private static final int ENERGY_PER_OPERATION = 8000;
    public static final int PROCESS_TIME = 200;
    private static final int ENERGY_PER_TICK = 40;
    private final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            TimerSlotExpanderBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> TimerUpgradeSlots.isTimer(stack);
                case 1 -> stack.m_150930_((Item)ModItems.SLOT_EXPANSER_UPGRADE.get());
                case 2 -> false;
                default -> false;
            };
        }
    };
    private final LazyOptional<ItemStackHandler> itemCapability = LazyOptional.of(() -> this.itemHandler);
    private final LazyOptional<IEnergyStorage> energyCapability;
    private final CustomEnergyStorage energyStorage = new CustomEnergyStorage(8000, 5000);
    private int progress = 0;
    private boolean processing = false;
    private final ContainerData data = new SimpleContainerData(3){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> TimerSlotExpanderBlockEntity.this.progress;
                case 1 -> TimerSlotExpanderBlockEntity.this.energyStorage.getEnergyStored();
                case 2 -> {
                    if (TimerSlotExpanderBlockEntity.this.processing) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    TimerSlotExpanderBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    TimerSlotExpanderBlockEntity.this.energyStorage.setEnergy(value);
                    break;
                }
                case 2: {
                    TimerSlotExpanderBlockEntity.this.processing = value != 0;
                }
            }
        }

        public int m_6499_() {
            return 3;
        }
    };

    public TimerSlotExpanderBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TIMER_SLOT_EXPANDER.get(), pos, state);
        this.energyCapability = LazyOptional.of(() -> this.energyStorage);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TimerSlotExpanderBlockEntity entity) {
        if (level == null || level.f_46443_) {
            return;
        }
        entity.tick(level);
        boolean shouldPlay = entity.isProcessing();
        if (shouldPlay) {
            BlockSoundManager.startBlockSound(pos, (SoundEvent)ModSounds.RESEARCH_TABLE_ACTIVE.get());
        } else {
            BlockSoundManager.stopBlockSound(pos);
        }
    }

    public void tick(Level level) {
        ItemStack timerStack = this.itemHandler.getStackInSlot(0);
        ItemStack upgradeStack = this.itemHandler.getStackInSlot(1);
        ItemStack outputStack = this.itemHandler.getStackInSlot(2);
        if (timerStack.m_41619_() || upgradeStack.m_41619_()) {
            this.progress = 0;
            this.processing = false;
            return;
        }
        TimerUpgradeSlots.initializeTimer(timerStack);
        if (!TimerUpgradeSlots.canAddMoreSlots(timerStack)) {
            if (outputStack.m_41619_()) {
                this.itemHandler.setStackInSlot(2, timerStack.m_41777_());
                timerStack.m_41774_(timerStack.m_41613_());
            }
            this.progress = 0;
            return;
        }
        int energyNeeded = 40;
        if (this.energyStorage.extractEnergy(energyNeeded, true) < energyNeeded) {
            this.processing = false;
            return;
        }
        this.energyStorage.extractEnergy(energyNeeded, false);
        ++this.progress;
        this.processing = true;
        if (this.progress >= 200) {
            ArrayList<Integer> eligibleCategories = new ArrayList<Integer>();
            for (int category = 0; category < 5; ++category) {
                int slotCount = TimerUpgradeSlots.getSlotCount(timerStack, category);
                if (slotCount >= 5) continue;
                eligibleCategories.add(category);
            }
            if (!eligibleCategories.isEmpty()) {
                Random random = new Random();
                int selectedCategory = (Integer)eligibleCategories.get(random.nextInt(eligibleCategories.size()));
                TimerUpgradeSlots.addSlotToCategory(timerStack, selectedCategory);
            }
            if (outputStack.m_41619_()) {
                this.itemHandler.setStackInSlot(2, timerStack.m_41777_());
            }
            timerStack.m_41774_(timerStack.m_41613_());
            upgradeStack.m_41774_(1);
            this.progress = 0;
            this.processing = false;
            this.m_6596_();
        }
        this.m_6596_();
    }

    public void drops() {
        this.itemHandler.getStackInSlot(0).m_41774_(this.itemHandler.getStackInSlot(0).m_41613_());
        this.itemHandler.getStackInSlot(1).m_41774_(this.itemHandler.getStackInSlot(1).m_41613_());
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
        this.energyStorage.deserializeNBT(tag.m_128423_("Energy"));
        this.progress = tag.m_128451_("Progress");
        this.processing = tag.m_128471_("Processing");
    }

    public void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128365_("Energy", this.energyStorage.serializeNBT());
        tag.m_128405_("Progress", this.progress);
        tag.m_128379_("Processing", this.processing);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemCapability.invalidate();
        this.energyCapability.invalidate();
    }

    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return new TimerSlotExpanderMenu(containerId, playerInventory, this, this.data);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Timer Slot Expander");
    }

    public int m_6643_() {
        return 3;
    }

    public boolean m_7983_() {
        return this.itemHandler.getStackInSlot(0).m_41619_() && this.itemHandler.getStackInSlot(1).m_41619_();
    }

    public ItemStack m_8020_(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return this.itemHandler.extractItem(slot, amount, false);
    }

    public ItemStack m_8016_(int slot) {
        return this.itemHandler.extractItem(slot, this.itemHandler.getStackInSlot(slot).m_41613_(), false);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.itemHandler.setStackInSlot(slot, stack);
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_6211_() {
        this.itemHandler.setStackInSlot(0, ItemStack.f_41583_);
        this.itemHandler.setStackInSlot(1, ItemStack.f_41583_);
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        return 200;
    }

    public CustomEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public boolean isProcessing() {
        return this.processing;
    }
}

