/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.client.renderer;

import com.michelmuscle.slidersmod.client.ObjMesh;
import com.michelmuscle.slidersmod.client.VortexRenderTypes;
import com.michelmuscle.slidersmod.client.renderer.ProtoVortexObjRenderer;
import com.michelmuscle.slidersmod.entity.ProtoVortexBorderObjEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.q_misc_util.my_util.DQuaternion;

public class ProtoVortexBorderObjRenderer
extends EntityRenderer<ProtoVortexBorderObjEntity> {
    private static ObjMesh MESH;
    private static final ResourceLocation OBJ;
    private static final ResourceLocation TEX;

    public ProtoVortexBorderObjRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.f_114477_ = 0.0f;
    }

    public void render(ProtoVortexBorderObjEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        try {
            if (MESH == null) {
                MESH = ObjMesh.load(OBJ);
            }
        }
        catch (Exception ignored) {
            return;
        }
        float scroll = ((float)entity.m_9236_().m_46467_() + partialTicks) / 20.0f;
        float du = ObjMesh.wrap01(-scroll * ProtoVortexObjRenderer.SCROLL_SPEED);
        float dv = ObjMesh.wrap01(-scroll * ProtoVortexObjRenderer.SCROLL_SPEED);
        float fade = entity.getScaleFactor(partialTicks);
        if (fade <= 0.0f) {
            return;
        }
        poseStack.m_85836_();
        Quaternionf rotation = ProtoVortexBorderObjRenderer.orientation(entity.getAxisW(), entity.getAxisH());
        rotation.mul((Quaternionfc)new Quaternionf().rotateY((float)Math.PI));
        poseStack.m_252781_(rotation);
        poseStack.m_85841_(ProtoVortexObjRenderer.SCALE * fade, ProtoVortexObjRenderer.SCALE * fade, ProtoVortexObjRenderer.SCALE * fade);
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        VertexConsumer translucent = buffer.m_6299_(VortexRenderTypes.vortex(TEX));
        MESH.draw(translucent, pose, 0xF000F0, du, dv);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(ProtoVortexBorderObjEntity entity) {
        return TEX;
    }

    private static Quaternionf orientation(Vec3 axisW, Vec3 axisH) {
        Vec3 w = ProtoVortexBorderObjRenderer.normalize(axisW, new Vec3(1.0, 0.0, 0.0));
        Vec3 h = ProtoVortexBorderObjRenderer.normalize(axisH, new Vec3(0.0, 1.0, 0.0));
        DQuaternion dq = PortalManipulation.getPortalOrientationQuaternion((Vec3)w, (Vec3)h);
        return new Quaternionf((float)dq.x, (float)dq.y, (float)dq.z, (float)dq.w);
    }

    private static Vec3 normalize(Vec3 vec, Vec3 fallback) {
        if (vec.m_82556_() < 1.0E-6) {
            return fallback;
        }
        Vec3 normalized = vec.m_82541_();
        if (normalized.m_82556_() < 1.0E-6) {
            return fallback;
        }
        return normalized;
    }

    static {
        OBJ = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"models/entity/protovortexborder.obj");
        TEX = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"textures/entity/protovortex.png");
    }
}

