/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.dimension;

import com.michelmuscle.slidersmod.dimension.DimensionManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class ReturnSchedulerData
extends SavedData {
    private static final String DATA_NAME = "slidersmod_return_scheduler";
    private final Map<UUID, DimensionManager.ReturnInfo> entries = new HashMap<UUID, DimensionManager.ReturnInfo>();

    public ReturnSchedulerData() {
    }

    public ReturnSchedulerData(Map<UUID, DimensionManager.ReturnInfo> existing) {
        this.entries.putAll(existing);
    }

    public static ReturnSchedulerData get(MinecraftServer server) {
        ServerLevel level = server.m_129783_();
        return (ReturnSchedulerData)level.m_8895_().m_164861_(ReturnSchedulerData::load, ReturnSchedulerData::new, DATA_NAME);
    }

    public static ReturnSchedulerData load(CompoundTag tag) {
        ReturnSchedulerData data = new ReturnSchedulerData();
        ListTag list = tag.m_128437_("Returns", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag dataTag;
            DimensionManager.ReturnInfo info;
            CompoundTag entry = list.m_128728_(i);
            if (!entry.m_128403_("Player")) continue;
            UUID playerId = entry.m_128342_("Player");
            if (!entry.m_128425_("Data", 10) || (info = DimensionManager.ReturnInfo.deserialize(dataTag = entry.m_128469_("Data"))) == null) continue;
            data.entries.put(playerId, info);
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        for (Map.Entry<UUID, DimensionManager.ReturnInfo> entry : this.entries.entrySet()) {
            CompoundTag wrapper = new CompoundTag();
            wrapper.m_128362_("Player", entry.getKey());
            CompoundTag dataTag = entry.getValue().serialize();
            wrapper.m_128365_("Data", (Tag)dataTag);
            list.add((Object)wrapper);
        }
        tag.m_128365_("Returns", (Tag)list);
        return tag;
    }

    public Map<UUID, DimensionManager.ReturnInfo> getEntries() {
        return this.entries;
    }

    public void setReturn(UUID playerId, DimensionManager.ReturnInfo info) {
        this.entries.put(playerId, info);
        this.m_77762_();
    }

    public void removeReturn(UUID playerId) {
        if (this.entries.remove(playerId) != null) {
            this.m_77762_();
        }
    }
}

