/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.entity;

import com.michelmuscle.slidersmod.SlidersMod;
import com.michelmuscle.slidersmod.entity.VortexEntity;
import com.michelmuscle.slidersmod.init.ModEntities;
import com.michelmuscle.slidersmod.util.CustomVortexVisuals;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CustomVortexEntity
extends VortexEntity {
    public CustomVortexEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public CustomVortexEntity(Level level, double x, double y, double z, UUID ownerUUID, ItemStack timerStack) {
        super((EntityType)ModEntities.CUSTOM_VORTEX_ENTITY.get(), level);
        this.m_6034_(x, y, z);
        this.ownerUUID = ownerUUID;
        this.timerStack = timerStack.m_41777_();
        this.f_19804_.m_135381_(LIFETIME, (Object)0);
        this.f_19804_.m_135381_(IS_RETURN_PORTAL, (Object)false);
        boolean isLoganVortex = timerStack.m_41784_().m_128471_("IsLoganVortex");
        boolean isProtoVortex = timerStack.m_41784_().m_128471_("IsProtoVortex");
        boolean isExodusVortex = timerStack.m_41784_().m_128471_("IsExodusVortex");
        boolean isEgyptianVortex = timerStack.m_41784_().m_128471_("IsEgyptianVortex");
        this.f_19804_.m_135381_(IS_LOGAN_VORTEX, (Object)isLoganVortex);
        this.f_19804_.m_135381_(IS_EXODUS_VORTEX, (Object)isExodusVortex);
        this.f_19804_.m_135381_(IS_EGYPTIAN_VORTEX, (Object)isEgyptianVortex);
        this.f_19804_.m_135381_(IS_PROTO_VORTEX, (Object)isProtoVortex);
        this.applyCustomVisuals(timerStack);
        if (!level.f_46443_ && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            boolean isDamaged = this.timerStack.m_41784_().m_128471_("IsDamagedVortex");
            this.cachedDestination = this.resolveInitialDestination(serverLevel, isLoganVortex, isDamaged);
            SlidersMod.LOGGER.info("Custom vortex created with destination: {} (IsLoganVortex={}, IsProtoVortex={})", new Object[]{this.cachedDestination != null ? this.cachedDestination.dimension.m_135782_() : "null", isLoganVortex, isProtoVortex});
        }
    }

    public CustomVortexEntity(Level level, double x, double y, double z, boolean isReturnPortal, boolean alreadyUsed) {
        this(level, x, y, z, isReturnPortal, alreadyUsed, false, false, false, false);
    }

    public CustomVortexEntity(Level level, double x, double y, double z, boolean isReturnPortal, boolean alreadyUsed, boolean isLoganVortex) {
        this(level, x, y, z, isReturnPortal, alreadyUsed, isLoganVortex, false, false, false);
    }

    public CustomVortexEntity(Level level, double x, double y, double z, boolean isReturnPortal, boolean alreadyUsed, boolean isLoganVortex, boolean isExodusVortex) {
        this(level, x, y, z, isReturnPortal, alreadyUsed, isLoganVortex, isExodusVortex, false, false);
    }

    public CustomVortexEntity(Level level, double x, double y, double z, boolean isReturnPortal, boolean alreadyUsed, boolean isLoganVortex, boolean isExodusVortex, boolean isEgyptianVortex) {
        this(level, x, y, z, isReturnPortal, alreadyUsed, isLoganVortex, isExodusVortex, isEgyptianVortex, false);
    }

    public CustomVortexEntity(Level level, double x, double y, double z, boolean isReturnPortal, boolean alreadyUsed, boolean isLoganVortex, boolean isExodusVortex, boolean isEgyptianVortex, boolean isProtoVortex) {
        super((EntityType)ModEntities.CUSTOM_VORTEX_ENTITY.get(), level);
        this.m_6034_(x, y, z);
        this.f_19804_.m_135381_(LIFETIME, (Object)0);
        this.f_19804_.m_135381_(IS_RETURN_PORTAL, (Object)isReturnPortal);
        this.f_19804_.m_135381_(IS_LOGAN_VORTEX, (Object)isLoganVortex);
        this.f_19804_.m_135381_(IS_EXODUS_VORTEX, (Object)isExodusVortex);
        this.f_19804_.m_135381_(IS_EGYPTIAN_VORTEX, (Object)isEgyptianVortex);
        this.f_19804_.m_135381_(IS_PROTO_VORTEX, (Object)isProtoVortex);
        if (alreadyUsed) {
            this.f_19804_.m_135381_(HAS_BEEN_USED, (Object)true);
            this.usedAtTick = 0;
        }
    }

    public CustomVortexEntity(Level level, double x, double y, double z, boolean isReturnPortal) {
        this(level, x, y, z, isReturnPortal, false);
    }

    @Override
    protected VortexEntity createAestheticVortex(ServerLevel targetLevel, double x, double y, double z) {
        CustomVortexEntity aesthetic = new CustomVortexEntity((Level)targetLevel, x, y, z, true, true);
        aesthetic.setCustomModelId(this.getCustomModelId());
        aesthetic.setCustomTextureId(this.getCustomTextureId());
        aesthetic.setCustomTint(this.getCustomTint());
        return aesthetic;
    }

    private void applyCustomVisuals(ItemStack timerStack) {
        if (timerStack.m_41619_()) {
            return;
        }
        CompoundTag tag = timerStack.m_41784_();
        CustomVortexVisuals.ModelVariant model = CustomVortexVisuals.readModel(tag);
        CustomVortexVisuals.TextureVariant texture = CustomVortexVisuals.readTexture(tag);
        int tint = CustomVortexVisuals.readTint(tag);
        this.setCustomModelId(model.id());
        this.setCustomTextureId(texture.id());
        this.setCustomTint(tint);
    }
}

