/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.entity;

import com.michelmuscle.slidersmod.SlidersMod;
import com.michelmuscle.slidersmod.dimension.DimensionManager;
import com.michelmuscle.slidersmod.entity.VortexEntity;
import com.michelmuscle.slidersmod.init.ModEntities;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class LoganVortexEntity
extends VortexEntity {
    public LoganVortexEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public LoganVortexEntity(Level level, double x, double y, double z, UUID ownerUUID, ItemStack timerStack) {
        super((EntityType)ModEntities.LOGAN_VORTEX_ENTITY.get(), level);
        this.m_6034_(x, y, z);
        this.ownerUUID = ownerUUID;
        this.timerStack = timerStack.m_41777_();
        this.f_19804_.m_135381_(LIFETIME, (Object)0);
        this.f_19804_.m_135381_(IS_RETURN_PORTAL, (Object)false);
        this.f_19804_.m_135381_(IS_LOGAN_VORTEX, (Object)true);
        if (!level.f_46443_) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.cachedDestination = DimensionManager.generateRandomDestination(serverLevel.m_7654_(), DimensionManager.getTimerTier(timerStack), true);
            SlidersMod.LOGGER.info("LoganVortexEntity created with destination: {} (IsLoganVortex=true)", this.cachedDestination != null ? this.cachedDestination.dimension.m_135782_() : "null");
        }
    }

    public LoganVortexEntity(Level level, double x, double y, double z, UUID ownerUUID, ItemStack timerStack, int targetX, int targetZ, int precisionRange) {
        super((EntityType)ModEntities.LOGAN_VORTEX_ENTITY.get(), level);
        this.m_6034_(x, y, z);
        this.ownerUUID = ownerUUID;
        this.timerStack = timerStack.m_41777_();
        this.f_19804_.m_135381_(LIFETIME, (Object)0);
        this.f_19804_.m_135381_(IS_RETURN_PORTAL, (Object)false);
        this.f_19804_.m_135381_(IS_LOGAN_VORTEX, (Object)true);
        if (!level.f_46443_) {
            ServerLevel serverLevel = (ServerLevel)level;
            Random random = new Random();
            int finalX = targetX + (random.nextInt(precisionRange * 2 + 1) - precisionRange);
            int finalZ = targetZ + (random.nextInt(precisionRange * 2 + 1) - precisionRange);
            ResourceKey overworldKey = Level.f_46428_;
            ServerLevel overworld = serverLevel.m_7654_().m_129880_(overworldKey);
            if (overworld != null) {
                BlockPos targetPos = DimensionManager.findSafeSpawnLocation(overworld, finalX, finalZ);
                this.cachedDestination = new DimensionManager.RandomDestination((ResourceKey<Level>)overworldKey, targetPos);
                SlidersMod.LOGGER.info("UpgradedLoganVortex created with targeted destination: Overworld @ ({}, {}, {}) [Target: ({}, {}), Precision:  {}]", new Object[]{targetPos.m_123341_(), targetPos.m_123342_(), targetPos.m_123343_(), targetX, targetZ, precisionRange});
            }
        }
    }

    public LoganVortexEntity(Level level, double x, double y, double z, boolean isReturnPortal, boolean alreadyUsed) {
        super((EntityType)ModEntities.LOGAN_VORTEX_ENTITY.get(), level);
        this.m_6034_(x, y, z);
        this.f_19804_.m_135381_(LIFETIME, (Object)0);
        this.f_19804_.m_135381_(IS_RETURN_PORTAL, (Object)isReturnPortal);
        this.f_19804_.m_135381_(IS_LOGAN_VORTEX, (Object)true);
        if (alreadyUsed) {
            this.f_19804_.m_135381_(HAS_BEEN_USED, (Object)true);
            this.usedAtTick = 0;
            SlidersMod.LOGGER.info("LoganVortexEntity aesthetic vortex created as already used");
        }
    }

    public LoganVortexEntity(Level level, double x, double y, double z, boolean isReturnPortal) {
        this(level, x, y, z, isReturnPortal, false);
    }

    @Override
    public boolean isLoganVortex() {
        return true;
    }

    @Override
    protected VortexEntity createAestheticVortex(ServerLevel targetLevel, double x, double y, double z) {
        return new LoganVortexEntity((Level)targetLevel, x, y, z, true, true);
    }
}

