/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.events;

import com.michelmuscle.slidersmod.SlidersMod;
import com.michelmuscle.slidersmod.config.SlidersModConfig;
import com.michelmuscle.slidersmod.init.ModItems;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="slidersmod", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DimensionEffectsHandler {
    private static final ResourceLocation DIM_ALTERNATE1 = new ResourceLocation("slidersmod", "alternate1");
    private static final ResourceLocation DIM_ECLIPSE = new ResourceLocation("slidersmod", "eclipse");
    private static final ResourceLocation DIM_NECROPOLE = new ResourceLocation("slidersmod", "necropole");
    private static final ResourceLocation DIM_TWILIGHT = new ResourceLocation("slidersmod", "twilight_world");
    private static final ResourceLocation DIM_PEACEFUL = new ResourceLocation("slidersmod", "peaceful_overworld");
    private static final ResourceLocation DIM_SOMMETS = new ResourceLocation("slidersmod", "sommets_aurore");
    private static final ResourceLocation DIM_BADLANDS = new ResourceLocation("slidersmod", "badlands");
    private static final ResourceLocation DIM_SABLIER = new ResourceLocation("slidersmod", "sablier");
    private static final String DATA_ALT_PIGLIN = "IsAlternate1Piglin";
    private static final String DATA_ALT_MAX_HEALTH = "Alternate1BaseHealth";
    private static final String DATA_ALT_SPEED = "Alternate1BaseSpeed";
    private static final String DATA_ALT_DAMAGE = "Alternate1BaseDamage";

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        ResourceLocation dimension = living.m_9236_().m_46472_().m_135782_();
        if (dimension.equals((Object)DIM_ALTERNATE1) && living instanceof Piglin) {
            Piglin piglin = (Piglin)living;
            DimensionEffectsHandler.applyAlternatePiglinAttributes(piglin);
        } else if (living instanceof Piglin) {
            Piglin piglin = (Piglin)living;
            DimensionEffectsHandler.revertAlternatePiglinAttributes(piglin);
        }
        if (dimension.equals((Object)DIM_ECLIPSE) && living instanceof Player) {
            Player player = (Player)living;
            if (!player.m_9236_().f_46443_) {
                DimensionEffectsHandler.applyPermanentEffect(player, MobEffects.f_19610_);
            }
        }
        if (dimension.equals((Object)DIM_NECROPOLE) && living instanceof Player) {
            Player player2 = (Player)living;
            if (!player2.m_9236_().f_46443_) {
                DimensionEffectsHandler.applyPermanentEffect(player2, MobEffects.f_216964_);
            }
        }
        if (dimension.equals((Object)DIM_SOMMETS) && living instanceof Player) {
            Player player3 = (Player)living;
            if (!player3.m_9236_().f_46443_) {
                DimensionEffectsHandler.applyPermanentEffect(player3, MobEffects.f_19591_);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Level level;
        Player player = event.getEntity();
        ResourceLocation newDim = player.m_9236_().m_46472_().m_135782_();
        ResourceLocation oldDim = event.getFrom().m_135782_();
        if (oldDim.equals((Object)DIM_ECLIPSE)) {
            player.m_21195_(MobEffects.f_19610_);
        }
        if (oldDim.equals((Object)DIM_NECROPOLE)) {
            player.m_21195_(MobEffects.f_216964_);
        }
        if (oldDim.equals((Object)DIM_SOMMETS)) {
            player.m_21195_(MobEffects.f_19591_);
        }
        if (newDim.equals((Object)DIM_SABLIER) && (level = player.m_9236_()) instanceof ServerLevel) {
            GameRules.IntegerValue tickRule;
            ServerLevel serverLevel = (ServerLevel)level;
            GameRules.BooleanValue dayRule = (GameRules.BooleanValue)serverLevel.m_46469_().m_46170_(GameRules.f_46140_);
            if (!dayRule.m_46223_()) {
                dayRule.m_46246_(true, serverLevel.m_7654_());
            }
            if ((tickRule = (GameRules.IntegerValue)serverLevel.m_46469_().m_46170_(GameRules.f_46143_)).m_46288_() != 30) {
                tickRule.m_151489_(30, serverLevel.m_7654_());
            }
        }
    }

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        Level level;
        if (event.phase != TickEvent.Phase.END || !((level = event.level) instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        ResourceLocation dim = level2.m_46472_().m_135782_();
        if (dim.equals((Object)DIM_NECROPOLE)) {
            level2.m_8606_(0, 6000, true, true);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        if (!level.m_46472_().m_135782_().equals((Object)DIM_ECLIPSE)) {
            return;
        }
        if (event.getPlayer() != null && event.getPlayer().m_7500_()) {
            return;
        }
        BlockState state = event.getState();
        BlockPos pos = event.getPos();
        BlockEntity tile = level.m_7702_(pos);
        Block.m_49881_((BlockState)state, (Level)level, (BlockPos)pos, (BlockEntity)tile, (Entity)event.getPlayer(), (ItemStack)(event.getPlayer() != null ? event.getPlayer().m_21205_() : ItemStack.f_41583_));
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        Level level = event.getEntity().m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (event.getEntity() instanceof Warden) {
            double dropRate = (Double)SlidersModConfig.CHIP_DROP_RATE.get();
            if (level2.m_213780_().m_188500_() < dropRate) {
                ItemStack chip = new ItemStack((ItemLike)ModItems.SLIDE_ENHANCEMENT_CHIP.get());
                ItemEntity chipEntity = new ItemEntity((Level)level2, event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), chip);
                event.getDrops().add(chipEntity);
                if (((Boolean)SlidersModConfig.ENABLE_DEBUG_LOGGING.get()).booleanValue()) {
                    SlidersMod.LOGGER.info("Warden dropped Slide Enhancement Chip ({}% chance)", (Object)(dropRate * 100.0));
                }
            }
        }
        if (!level2.m_46472_().m_135782_().equals((Object)DIM_ECLIPSE)) {
            return;
        }
        List<ItemEntity> clones = event.getDrops().stream().map(drop -> new ItemEntity((Level)level2, drop.m_20185_(), drop.m_20186_(), drop.m_20189_(), drop.m_32055_().m_41777_())).toList();
        event.getDrops().addAll(clones);
    }

    @SubscribeEvent
    public static void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        Level level = event.getEntity().m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (level2.m_46472_().m_135782_().equals((Object)DIM_TWILIGHT)) {
            event.setDroppedExperience(event.getDroppedExperience() * 3);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Level level = event.getEntity().m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (level2.m_46472_().m_135782_().equals((Object)DIM_PEACEFUL) && event.getSource().m_276093_(DamageTypes.f_268671_)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_) {
            return;
        }
        Player player = event.player;
        ResourceLocation dim = player.m_9236_().m_46472_().m_135782_();
        if (dim.equals((Object)DIM_PEACEFUL) && !player.m_21023_(MobEffects.f_19605_)) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 60, 0, false, false, false));
        }
        if (dim.equals((Object)DIM_SOMMETS) && !player.m_21023_(MobEffects.f_19591_)) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 220, 0, false, false, false));
        }
    }

    private static void applyPermanentEffect(Player player, MobEffect effect) {
        player.m_7292_(new MobEffectInstance(effect, -1, 0, false, false, false));
    }

    private static void applyAlternatePiglinAttributes(Piglin piglin) {
        double newValue;
        double base;
        CompoundTag tag = piglin.getPersistentData();
        AttributeInstance health = piglin.m_21051_(Attributes.f_22276_);
        AttributeInstance speed = piglin.m_21051_(Attributes.f_22279_);
        AttributeInstance damage = piglin.m_21051_(Attributes.f_22281_);
        if (!tag.m_128471_(DATA_ALT_PIGLIN)) {
            tag.m_128379_(DATA_ALT_PIGLIN, true);
            if (health != null) {
                tag.m_128347_(DATA_ALT_MAX_HEALTH, health.m_22115_());
            }
            if (speed != null) {
                tag.m_128347_(DATA_ALT_SPEED, speed.m_22115_());
            }
            if (damage != null) {
                tag.m_128347_(DATA_ALT_DAMAGE, damage.m_22115_());
            }
        }
        if (health != null) {
            base = tag.m_128459_(DATA_ALT_MAX_HEALTH);
            newValue = (base <= 0.0 ? health.m_22115_() : base) * 0.25;
            health.m_22100_(Math.max(1.0, newValue));
            piglin.m_21153_((float)Math.min((double)piglin.m_21223_(), health.m_22115_()));
        }
        if (speed != null) {
            base = tag.m_128459_(DATA_ALT_SPEED);
            newValue = (base <= 0.0 ? speed.m_22115_() : base) * 2.0;
            speed.m_22100_(newValue);
        }
        if (damage != null) {
            base = tag.m_128459_(DATA_ALT_DAMAGE);
            newValue = (base <= 0.0 ? damage.m_22115_() : base) * 2.0;
            damage.m_22100_(newValue);
        }
    }

    private static void revertAlternatePiglinAttributes(Piglin piglin) {
        CompoundTag tag = piglin.getPersistentData();
        if (!tag.m_128471_(DATA_ALT_PIGLIN)) {
            return;
        }
        AttributeInstance health = piglin.m_21051_(Attributes.f_22276_);
        AttributeInstance speed = piglin.m_21051_(Attributes.f_22279_);
        AttributeInstance damage = piglin.m_21051_(Attributes.f_22281_);
        if (health != null && tag.m_128441_(DATA_ALT_MAX_HEALTH)) {
            double base = tag.m_128459_(DATA_ALT_MAX_HEALTH);
            health.m_22100_(base);
            piglin.m_21153_((float)Math.min((double)piglin.m_21223_(), base));
        }
        if (speed != null && tag.m_128441_(DATA_ALT_SPEED)) {
            speed.m_22100_(tag.m_128459_(DATA_ALT_SPEED));
        }
        if (damage != null && tag.m_128441_(DATA_ALT_DAMAGE)) {
            damage.m_22100_(tag.m_128459_(DATA_ALT_DAMAGE));
        }
        tag.m_128473_(DATA_ALT_PIGLIN);
        tag.m_128473_(DATA_ALT_MAX_HEALTH);
        tag.m_128473_(DATA_ALT_SPEED);
        tag.m_128473_(DATA_ALT_DAMAGE);
    }
}

