/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.events;

import com.michelmuscle.slidersmod.SlidersMod;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="slidersmod", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PeacefulDimensionEvents {
    private static final String PEACEFUL_DIMENSION_NAME = "slidersmod:peaceful_overworld";

    @SubscribeEvent
    public static void onMobSpawn(MobSpawnEvent.FinalizeSpawn event) {
        ServerLevelAccessor serverLevelAccessor = event.getLevel();
        if (!(serverLevelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)serverLevelAccessor;
        String dimName = serverLevel.m_46472_().m_135782_().toString();
        if (!dimName.equals(PEACEFUL_DIMENSION_NAME)) {
            return;
        }
        if (PeacefulDimensionEvents.isHostileMob((Entity)event.getEntity())) {
            SlidersMod.LOGGER.info("Blocking hostile mob {} in peaceful dimension", (Object)event.getEntity().m_6095_().m_20676_().getString());
            event.setResult(Event.Result.DENY);
        }
    }

    private static boolean isHostileMob(Entity entity) {
        return entity instanceof Monster;
    }
}

