/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.menu;

import com.michelmuscle.slidersmod.block.entity.QuantumRecallStationBlockEntity;
import com.michelmuscle.slidersmod.init.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class QuantumRecallStationMenu
extends AbstractContainerMenu {
    public static final int SLOT_MARKER = 0;
    public static final int CONTAINER_DATA_COUNT = 10;
    private final QuantumRecallStationBlockEntity blockEntity;
    private final Inventory playerInventory;
    private final ContainerLevelAccess access;
    private final ContainerData data;

    public QuantumRecallStationMenu(int containerId, Inventory playerInventory, FriendlyByteBuf extraData) {
        this(containerId, playerInventory, playerInventory.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), playerInventory.f_35978_);
    }

    public QuantumRecallStationMenu(int containerId, Inventory playerInventory, BlockEntity blockEntity, Player player) {
        super((MenuType)ModMenuTypes.QUANTUM_RECALL_STATION_MENU.get(), containerId);
        int col;
        if (!(blockEntity instanceof QuantumRecallStationBlockEntity)) {
            throw new IllegalStateException("Wrong block entity");
        }
        final QuantumRecallStationBlockEntity qrsBlockEntity = (QuantumRecallStationBlockEntity)blockEntity;
        this.blockEntity = qrsBlockEntity;
        this.playerInventory = playerInventory;
        this.access = ContainerLevelAccess.m_39289_((Level)playerInventory.f_35978_.m_9236_(), (BlockPos)qrsBlockEntity.m_58899_());
        boolean isServerSide = !playerInventory.f_35978_.m_9236_().m_5776_();
        this.data = isServerSide ? new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> qrsBlockEntity.getEnergy() & 0xFFFF;
                    case 1 -> qrsBlockEntity.getEnergy() >> 16 & 0xFFFF;
                    case 2 -> qrsBlockEntity.getEnergyCapacity() & 0xFFFF;
                    case 3 -> qrsBlockEntity.getEnergyCapacity() >> 16 & 0xFFFF;
                    case 4 -> {
                        Level var3_2 = qrsBlockEntity.m_58904_();
                        if (var3_2 instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)var3_2;
                            yield (int)Math.min(qrsBlockEntity.getRemainingCooldownTicks(serverLevel), Integer.MAX_VALUE);
                        }
                        yield 0;
                    }
                    case 5 -> {
                        if (qrsBlockEntity.hasMarkedEntity()) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 6 -> {
                        Level var3_3 = qrsBlockEntity.m_58904_();
                        if (var3_3 instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)var3_3;
                            long remaining = qrsBlockEntity.getRemainingMarkTicks(serverLevel);
                            yield (int)Math.min(Integer.MAX_VALUE, remaining);
                        }
                        yield 0;
                    }
                    case 7 -> qrsBlockEntity.getVortexDistance();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
            }

            public int m_6499_() {
                return 10;
            }
        } : new SimpleContainerData(10);
        this.m_38884_(this.data);
        this.m_38897_(new Slot((Container)new MarkerContainer(), 0, 32, 31));
        int invX = 33;
        int invY = 84;
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, invX + col * 18, invY + row * 18));
            }
        }
        int hotbarY = 142;
        for (col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, invX + col * 18, hotbarY));
        }
    }

    public QuantumRecallStationBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public int getEnergyStored() {
        int low = this.data.m_6413_(0);
        int high = this.data.m_6413_(1);
        return high << 16 | low;
    }

    public int getMaxEnergyStored() {
        int low = this.data.m_6413_(2);
        int high = this.data.m_6413_(3);
        return high << 16 | low;
    }

    public int getScaledEnergy() {
        int max = this.getMaxEnergyStored();
        if (max == 0) {
            return 0;
        }
        return this.getEnergyStored() * 52 / max;
    }

    public int getCooldownTicks() {
        return this.data.m_6413_(4);
    }

    public boolean hasMarkedEntity() {
        return this.data.m_6413_(5) == 1;
    }

    public int getMarkRemainingTicks() {
        return this.data.m_6413_(6);
    }

    public int getVortexDistance() {
        int d = this.data.m_6413_(7);
        if (d == 0) {
            return QuantumRecallStationBlockEntity.getMinDistance();
        }
        return d;
    }

    public void setVortexDistance(int distance) {
        this.blockEntity.setVortexDistance(distance);
    }

    public boolean canTrigger() {
        int energy = this.getEnergyStored();
        boolean hasMark = this.hasMarkedEntity() && this.getMarkRemainingTicks() > 0;
        boolean onCooldown = this.getCooldownTicks() > 0;
        return energy >= QuantumRecallStationBlockEntity.getRecallCost() && hasMark && !onCooldown;
    }

    public ItemStack getMarkerStack() {
        return this.blockEntity.getMarkerStack();
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            int invEndExclusive;
            int markerSlotEndExclusive;
            ItemStack stack = slot.m_7993_();
            itemstack = stack.m_41777_();
            int invStart = markerSlotEndExclusive = 1;
            int hotbarStart = invEndExclusive = invStart + 27;
            int hotbarEndExclusive = hotbarStart + 9;
            if (index < markerSlotEndExclusive ? !this.m_38903_(stack, invStart, hotbarEndExclusive, false) : !this.m_38903_(stack, 0, markerSlotEndExclusive, false)) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stack);
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        return QuantumRecallStationMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)this.blockEntity.m_58900_().m_60734_());
    }

    public BlockPos getBlockPos() {
        return this.blockEntity.m_58899_();
    }

    public Level getLevel() {
        return this.blockEntity.m_58904_();
    }

    private class MarkerContainer
    implements Container {
        private MarkerContainer() {
        }

        public int m_6643_() {
            return 1;
        }

        public boolean m_7983_() {
            return QuantumRecallStationMenu.this.blockEntity.getMarkerStack().m_41619_();
        }

        public ItemStack m_8020_(int index) {
            return QuantumRecallStationMenu.this.blockEntity.getMarkerStack();
        }

        public ItemStack m_7407_(int index, int amount) {
            ItemStack stack = QuantumRecallStationMenu.this.blockEntity.getMarkerStack();
            if (stack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            ItemStack split = stack.m_41777_();
            split.m_41764_(Math.min(amount, stack.m_41613_()));
            stack.m_41774_(split.m_41613_());
            QuantumRecallStationMenu.this.blockEntity.setMarkerStack(stack);
            this.m_6596_();
            return split;
        }

        public ItemStack m_8016_(int index) {
            ItemStack stack = QuantumRecallStationMenu.this.blockEntity.getMarkerStack();
            QuantumRecallStationMenu.this.blockEntity.setMarkerStack(ItemStack.f_41583_);
            return stack;
        }

        public void m_6836_(int index, ItemStack stack) {
            QuantumRecallStationMenu.this.blockEntity.setMarkerStack(stack);
        }

        public void m_6596_() {
            QuantumRecallStationMenu.this.blockEntity.m_6596_();
        }

        public boolean m_6542_(Player player) {
            return true;
        }

        public void m_6211_() {
            QuantumRecallStationMenu.this.blockEntity.setMarkerStack(ItemStack.f_41583_);
        }
    }
}

