/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.menu;

import com.michelmuscle.slidersmod.block.entity.TimerSlotExpanderBlockEntity;
import com.michelmuscle.slidersmod.init.ModMenuTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TimerSlotExpanderMenu
extends AbstractContainerMenu {
    public static final int PROGRESS_MAX = 200;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int INV_SLOT_COUNT = 27;
    private static final int PLAYER_SLOT_COUNT = 36;
    private static final int MACHINE_SLOT_INDEX = 36;
    private static final int UPGRADE_SLOT_INDEX = 37;
    private static final int OUTPUT_SLOT_INDEX = 38;
    private final TimerSlotExpanderBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;

    public TimerSlotExpanderMenu(int containerId, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerId, inventory, inventory.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(3));
    }

    public TimerSlotExpanderMenu(int containerId, Inventory inventory, BlockEntity entity, ContainerData data) {
        super((MenuType)ModMenuTypes.TIMER_SLOT_EXPANDER_MENU.get(), containerId);
        if (!(entity instanceof TimerSlotExpanderBlockEntity)) {
            throw new IllegalStateException("TimerSlotExpanderMenu created without correct block entity");
        }
        TimerSlotExpanderBlockEntity expander = (TimerSlotExpanderBlockEntity)entity;
        this.blockEntity = expander;
        this.level = inventory.f_35978_.m_9236_();
        this.data = data;
        TimerSlotExpanderMenu.m_38869_((Container)expander, (int)3);
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
        this.m_38897_(new Slot(expander, 0, 44, 34){

            public boolean m_5857_(ItemStack stack) {
                return true;
            }
        });
        this.m_38897_(new Slot(expander, 1, 80, 34){

            public boolean m_5857_(ItemStack stack) {
                return true;
            }
        });
        this.m_38897_(new Slot(expander, 2, 134, 34){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        });
        this.m_38884_(data);
    }

    private void addPlayerInventory(Inventory inv) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)inv, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory inv) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inv, i, 8 + i * 18, 142));
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemStack = slotStack.m_41777_();
            if (index < 36 ? !this.m_38903_(slotStack, 36, 39, false) : !this.m_38903_(slotStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemStack;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public boolean isProcessing() {
        return this.data.m_6413_(2) == 1;
    }

    public int getScaledProgress() {
        return this.data.m_6413_(0);
    }

    public int getMaxProgress() {
        return this.blockEntity.getMaxProgress();
    }

    public int getEnergy() {
        return this.data.m_6413_(1);
    }

    public int getMaxEnergy() {
        return this.blockEntity.getEnergyStorage().getMaxEnergyStored();
    }
}

