/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.network;

import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier1DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier2DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier3DamagedItem;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class DamagedUpgradedLoganCoordsPacket {
    private final int targetX;
    private final int targetZ;

    public DamagedUpgradedLoganCoordsPacket(int targetX, int targetZ) {
        this.targetX = targetX;
        this.targetZ = targetZ;
    }

    public static void encode(DamagedUpgradedLoganCoordsPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.targetX);
        buf.writeInt(packet.targetZ);
    }

    public static DamagedUpgradedLoganCoordsPacket decode(FriendlyByteBuf buf) {
        return new DamagedUpgradedLoganCoordsPacket(buf.readInt(), buf.readInt());
    }

    public static void handle(DamagedUpgradedLoganCoordsPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            ItemStack timerStack = DamagedUpgradedLoganCoordsPacket.findDamagedUpgradedTimer(player);
            if (timerStack == null) {
                return;
            }
            if (timerStack.m_41720_() instanceof UpgradedLoganTimerTier1DamagedItem) {
                UpgradedLoganTimerTier1DamagedItem.setConfiguredX(timerStack, packet.targetX);
                UpgradedLoganTimerTier1DamagedItem.setConfiguredZ(timerStack, packet.targetZ);
            } else if (timerStack.m_41720_() instanceof UpgradedLoganTimerTier2DamagedItem) {
                UpgradedLoganTimerTier2DamagedItem.setConfiguredX(timerStack, packet.targetX);
                UpgradedLoganTimerTier2DamagedItem.setConfiguredZ(timerStack, packet.targetZ);
            } else if (timerStack.m_41720_() instanceof UpgradedLoganTimerTier3DamagedItem) {
                UpgradedLoganTimerTier3DamagedItem.setConfiguredX(timerStack, packet.targetX);
                UpgradedLoganTimerTier3DamagedItem.setConfiguredZ(timerStack, packet.targetZ);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static ItemStack findDamagedUpgradedTimer(ServerPlayer player) {
        ItemStack main = player.m_21205_();
        ItemStack off = player.m_21206_();
        if (main.m_41720_() instanceof UpgradedLoganTimerTier1DamagedItem || main.m_41720_() instanceof UpgradedLoganTimerTier2DamagedItem || main.m_41720_() instanceof UpgradedLoganTimerTier3DamagedItem) {
            return main;
        }
        if (off.m_41720_() instanceof UpgradedLoganTimerTier1DamagedItem || off.m_41720_() instanceof UpgradedLoganTimerTier2DamagedItem || off.m_41720_() instanceof UpgradedLoganTimerTier3DamagedItem) {
            return off;
        }
        return null;
    }
}

