/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.network;

import com.michelmuscle.slidersmod.advancements.AchievementManager;
import com.michelmuscle.slidersmod.item.ExodusTimerItem;
import com.michelmuscle.slidersmod.system.DimensionSeedRegistry;
import com.michelmuscle.slidersmod.system.PlayerSeedRegistry;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ExodusTimerConfigPacket {
    private final String configuredSeed;
    private final long configuredTime;

    public ExodusTimerConfigPacket(String configuredSeed, long configuredTime) {
        this.configuredSeed = configuredSeed;
        this.configuredTime = configuredTime;
    }

    public static void encode(ExodusTimerConfigPacket packet, FriendlyByteBuf buf) {
        buf.m_130070_(packet.configuredSeed);
        buf.writeLong(packet.configuredTime);
    }

    public static ExodusTimerConfigPacket decode(FriendlyByteBuf buf) {
        return new ExodusTimerConfigPacket(buf.m_130277_(), buf.readLong());
    }

    public static void handle(ExodusTimerConfigPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                ItemStack mainHand = player.m_21205_();
                ItemStack offHand = player.m_21206_();
                ItemStack timerStack = null;
                if (mainHand.m_41720_() instanceof ExodusTimerItem) {
                    timerStack = mainHand;
                } else if (offHand.m_41720_() instanceof ExodusTimerItem) {
                    timerStack = offHand;
                }
                if (timerStack != null) {
                    if (!packet.configuredSeed.isEmpty()) {
                        if (!DimensionSeedRegistry.isValidSeedFormat(packet.configuredSeed)) {
                            player.m_5661_((Component)Component.m_237113_((String)"\u00a7cInvalid seed format! Must be 8 digits."), true);
                            return;
                        }
                        DimensionSeedRegistry registry = DimensionSeedRegistry.get(player.m_20194_());
                        if (!registry.isValidSeed(packet.configuredSeed)) {
                            player.m_5661_((Component)Component.m_237113_((String)"\u00a7cDimension seed not found! This seed does not exist yet."), true);
                            return;
                        }
                        PlayerSeedRegistry playerRegistry = PlayerSeedRegistry.get(player.m_20194_());
                        if (!playerRegistry.hasPlayerDiscoveredSeed(player.m_20148_(), packet.configuredSeed)) {
                            player.m_5661_((Component)Component.m_237113_((String)"\u00a7cYou haven't discovered this seed yet! Use a Quantum Relocator to obtain it from another player."), true);
                            return;
                        }
                        ExodusTimerItem.setConfiguredSeed(timerStack, packet.configuredSeed);
                        ExodusTimerItem.setConfiguredTime(timerStack, packet.configuredTime);
                        if (packet.configuredTime == 69L) {
                            AchievementManager.trigger69SecondTimer(player);
                        }
                        if (packet.configuredTime > 3600L) {
                            AchievementManager.triggerGoodLuckWithThat(player);
                        }
                        if (packet.configuredTime > 86400L) {
                            AchievementManager.triggerMrPatience(player);
                        }
                        DimensionSeedRegistry.SeedDestination destination = registry.getDestination(packet.configuredSeed);
                        player.m_5661_((Component)Component.m_237113_((String)("\u00a7aTimer configured! Seed: " + packet.configuredSeed + " | Duration: " + ExodusTimerConfigPacket.formatTime(packet.configuredTime) + " | Destination: " + String.valueOf(destination.dimension.m_135782_()))), true);
                    } else {
                        ExodusTimerItem.setConfiguredSeed(timerStack, "");
                        ExodusTimerItem.setConfiguredTime(timerStack, packet.configuredTime);
                        if (packet.configuredTime == 69L) {
                            AchievementManager.trigger69SecondTimer(player);
                        }
                        if (packet.configuredTime > 3600L) {
                            AchievementManager.triggerGoodLuckWithThat(player);
                        }
                        if (packet.configuredTime > 86400L) {
                            AchievementManager.triggerMrPatience(player);
                        }
                        player.m_5661_((Component)Component.m_237113_((String)("\u00a7aTimer configured! Duration: " + ExodusTimerConfigPacket.formatTime(packet.configuredTime) + " | Mode: Random Dimension")), true);
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static String formatTime(long totalSeconds) {
        long days = totalSeconds / 86400L;
        long hours = totalSeconds % 86400L / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        return String.format("%dd %02d:%02d:%02d", days, hours, minutes, seconds);
    }
}

