/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.network;

import com.michelmuscle.slidersmod.client.hud.ForceVortexWarningHud;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ForceVortexWarningPacket {
    private final boolean isActive;
    private final int secondsLeft;

    public ForceVortexWarningPacket(boolean isActive, int secondsLeft) {
        this.isActive = isActive;
        this.secondsLeft = secondsLeft;
    }

    public static void encode(ForceVortexWarningPacket packet, FriendlyByteBuf buf) {
        buf.writeBoolean(packet.isActive);
        buf.writeInt(packet.secondsLeft);
    }

    public static ForceVortexWarningPacket decode(FriendlyByteBuf buf) {
        return new ForceVortexWarningPacket(buf.readBoolean(), buf.readInt());
    }

    public static void handle(ForceVortexWarningPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (packet.isActive) {
                ForceVortexWarningHud.showWarning(packet.secondsLeft);
            } else {
                ForceVortexWarningHud.cancelWarning();
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

