/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.network;

import com.michelmuscle.slidersmod.SlidersMod;
import com.michelmuscle.slidersmod.block.entity.ProtoSynchronizerBlockEntity;
import com.michelmuscle.slidersmod.system.PlayerSeedRegistry;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ProtoSynchronizerSeedPacket {
    private final BlockPos blockPos;
    private final String seed;

    public ProtoSynchronizerSeedPacket(BlockPos blockPos, String seed) {
        this.blockPos = blockPos;
        this.seed = seed;
    }

    public static void encode(ProtoSynchronizerSeedPacket packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.blockPos);
        buf.m_130070_(packet.seed);
    }

    public static ProtoSynchronizerSeedPacket decode(FriendlyByteBuf buf) {
        return new ProtoSynchronizerSeedPacket(buf.m_130135_(), buf.m_130277_());
    }

    public static void handle(ProtoSynchronizerSeedPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            BlockEntity blockEntity = player.m_9236_().m_7702_(packet.blockPos);
            if (!(blockEntity instanceof ProtoSynchronizerBlockEntity)) {
                SlidersMod.LOGGER.warn("Player {} tried to set seed on invalid block at {}", (Object)player.m_7755_().getString(), (Object)packet.blockPos);
                return;
            }
            ProtoSynchronizerBlockEntity protoSync = (ProtoSynchronizerBlockEntity)blockEntity;
            if (!ProtoSynchronizerSeedPacket.isValidSeedFormat(packet.seed)) {
                player.m_5661_((Component)Component.m_237113_((String)"\u00a7cInvalid seed format! Must be 8 digits."), true);
                return;
            }
            PlayerSeedRegistry registry = PlayerSeedRegistry.get(player.m_20194_());
            if (!registry.hasPlayerDiscoveredSeed(player.m_20148_(), packet.seed)) {
                player.m_5661_((Component)Component.m_237113_((String)"\u00a7cYou haven't discovered this seed yet!"), true);
                return;
            }
            protoSync.setTargetSeed(packet.seed);
            SlidersMod.LOGGER.info("Player {} set seed {} on Proto-Synchronizer at {}", new Object[]{player.m_7755_().getString(), packet.seed, packet.blockPos});
            player.m_5661_((Component)Component.m_237113_((String)("\u00a7aTarget seed set: " + packet.seed)), true);
        });
        ctx.get().setPacketHandled(true);
    }

    private static boolean isValidSeedFormat(String seed) {
        if (seed == null || seed.length() != 8) {
            return false;
        }
        for (char c : seed.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }
}

