/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.network;

import com.michelmuscle.slidersmod.advancements.AchievementManager;
import com.michelmuscle.slidersmod.item.CustomTimerItem;
import com.michelmuscle.slidersmod.item.LoganTimerItem;
import com.michelmuscle.slidersmod.item.OriginalTimerItem;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class TimerConfigPacket {
    private final long configuredSeconds;

    public TimerConfigPacket(long configuredSeconds) {
        this.configuredSeconds = configuredSeconds;
    }

    public static void encode(TimerConfigPacket packet, FriendlyByteBuf buf) {
        buf.writeLong(packet.configuredSeconds);
    }

    public static TimerConfigPacket decode(FriendlyByteBuf buf) {
        return new TimerConfigPacket(buf.readLong());
    }

    public static void handle(TimerConfigPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                ItemStack mainHand = player.m_21205_();
                ItemStack offHand = player.m_21206_();
                ItemStack timerStack = null;
                if (mainHand.m_41720_() instanceof OriginalTimerItem || mainHand.m_41720_() instanceof LoganTimerItem || mainHand.m_41720_() instanceof CustomTimerItem) {
                    timerStack = mainHand;
                } else if (offHand.m_41720_() instanceof OriginalTimerItem || offHand.m_41720_() instanceof LoganTimerItem || offHand.m_41720_() instanceof CustomTimerItem) {
                    timerStack = offHand;
                }
                if (timerStack != null) {
                    if (timerStack.m_41720_() instanceof OriginalTimerItem) {
                        OriginalTimerItem.setConfiguredTime(timerStack, packet.configuredSeconds);
                    } else if (timerStack.m_41720_() instanceof LoganTimerItem) {
                        LoganTimerItem.setConfiguredTime(timerStack, packet.configuredSeconds);
                    } else if (timerStack.m_41720_() instanceof CustomTimerItem) {
                        CustomTimerItem.setConfiguredTime(timerStack, packet.configuredSeconds);
                    }
                    if (packet.configuredSeconds == 69L) {
                        AchievementManager.trigger69SecondTimer(player);
                    }
                    if (packet.configuredSeconds > 3600L) {
                        AchievementManager.triggerGoodLuckWithThat(player);
                    }
                    if (packet.configuredSeconds > 86400L) {
                        AchievementManager.triggerMrPatience(player);
                    }
                    player.m_5661_((Component)Component.m_237113_((String)("\u00a7aTimer configured: " + TimerConfigPacket.formatTime(packet.configuredSeconds))), true);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static String formatTime(long totalSeconds) {
        long days = totalSeconds / 86400L;
        long hours = totalSeconds % 86400L / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        if (days > 0L) {
            return String.format("%dd %02dh %02dm %02ds", days, hours, minutes, seconds);
        }
        if (hours > 0L) {
            return String.format("%02dh %02dm %02ds", hours, minutes, seconds);
        }
        if (minutes > 0L) {
            return String.format("%02dm %02ds", minutes, seconds);
        }
        return String.format("%02ds", seconds);
    }
}

