/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.portal;

import com.michelmuscle.slidersmod.SlidersMod;
import com.michelmuscle.slidersmod.entity.CustomShowcaseVortexObjEntity;
import com.michelmuscle.slidersmod.entity.EgyptianVortexBackObjEntity;
import com.michelmuscle.slidersmod.entity.EgyptianVortexBorderObjEntity;
import com.michelmuscle.slidersmod.entity.ExodusVortexBackObjEntity;
import com.michelmuscle.slidersmod.entity.ExodusVortexBorderObjEntity;
import com.michelmuscle.slidersmod.entity.LoganVortexBorderObjEntity;
import com.michelmuscle.slidersmod.entity.OgVortexBackObjEntity;
import com.michelmuscle.slidersmod.entity.OgVortexBorderObjEntity;
import com.michelmuscle.slidersmod.entity.ProtoVortexBorderObjEntity;
import com.michelmuscle.slidersmod.entity.VortexCollisionObjEntity;
import com.michelmuscle.slidersmod.entity.VortexEntity;
import com.michelmuscle.slidersmod.init.ModEntities;
import com.michelmuscle.slidersmod.portal.VortexPortalPlacement;
import com.michelmuscle.slidersmod.portal.VortexPortalTargets;
import com.michelmuscle.slidersmod.portal.VortexPortalTracker;
import com.michelmuscle.slidersmod.util.CustomVortexVisuals;
import com.michelmuscle.slidersmod.world.VortexShowcaseManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.api.PortalAPI;
import qouteall.imm_ptl.core.platform_specific.IPRegistry;
import qouteall.imm_ptl.core.portal.GeometryPortalShape;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.q_misc_util.my_util.DQuaternion;

public final class VortexImmersivePortalHelper {
    public static final double TARGET_PORTAL_SIZE = 3.0;
    public static final double PREVIEW_PORTAL_SIZE = 0.05;
    public static final int PORTAL_GROWTH_TICKS = 15;
    private static final double CUSTOM_SHOWCASE_VERTICAL_OFFSET = 40.0;
    private static final Vec3 CUSTOM_SHOWCASE_AXIS_W = new Vec3(-1.0, 0.0, 0.0);
    private static final Vec3 CUSTOM_SHOWCASE_AXIS_H = new Vec3(0.0, 1.0, 0.0);
    private static final Vec3 CUSTOM_SHOWCASE_NORMAL = new Vec3(0.0, 0.0, -1.0);
    private static final int CIRCLE_SEGMENTS = 40;
    private static final DQuaternion FLIP_AXIS_W = DQuaternion.rotationByDegrees((Vec3)new Vec3(0.0, 1.0, 0.0), (double)180.0).fixFloatingPointErrorAccumulation();
    private static final ResourceLocation OG_COLLISION_MODEL = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"models/entity/vortexcollision.obj");
    private static final ResourceLocation EGYPTIAN_COLLISION_MODEL = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"models/entity/egyptianvortexcollision.obj");
    private static final String VORTEX_PORTAL_TAG = "slidersmod:vortex_portal";
    private static final int BACK_DECORATION_SPAWN_DELAY_TICKS = 30;
    private static final int BACK_DECORATION_FADE_OUT_TICKS = 30;

    private VortexImmersivePortalHelper() {
    }

    @Nullable
    private static DecorationAppearance resolveDecorationAppearance(VortexEntity vortex) {
        String textureId = vortex.getCustomTextureId();
        if (textureId == null || textureId.isEmpty()) {
            return null;
        }
        CustomVortexVisuals.TextureVariant variant = CustomVortexVisuals.TextureVariant.byId(textureId);
        if (!variant.tintable()) {
            return null;
        }
        return new DecorationAppearance(variant, textureId, vortex.getCustomTint());
    }

    public static Optional<Portal> spawnPreviewPortal(ServerLevel level, VortexPortalPlacement placement, VortexPortalTargets.ShowcaseTarget target) {
        return VortexImmersivePortalHelper.spawnShowcasePortal(level, placement, target, 0.05, false);
    }

    public static Optional<Portal> spawnFullPortal(ServerLevel level, VortexPortalPlacement placement, VortexPortalTargets.ShowcaseTarget target) {
        return VortexImmersivePortalHelper.spawnShowcasePortal(level, placement, target, 3.0, true);
    }

    private static CustomShowcaseVortexObjEntity spawnCustomShowcase(ServerLevel vortexLevel, VortexPortalPlacement placement, CustomVortexVisuals.ModelVariant variant, int tint, @Nullable Vec3 forcedAnchor) {
        Vec3 normal;
        Vec3 axisH;
        Vec3 axisW;
        ServerLevel showcaseLevel = vortexLevel.m_7654_().m_129880_(VortexShowcaseManager.dimensionKey());
        if (showcaseLevel == null) {
            SlidersMod.LOGGER.error("Unable to access showcase dimension for custom vortex.");
            return null;
        }
        Vec3 anchor = forcedAnchor != null ? forcedAnchor : new Vec3(placement.center().f_82479_, placement.center().f_82480_ + 40.0, placement.center().f_82481_);
        showcaseLevel.m_46745_(BlockPos.m_274446_((Position)anchor));
        CustomShowcaseVortexObjEntity entity = (CustomShowcaseVortexObjEntity)((EntityType)ModEntities.CUSTOM_SHOWCASE_VORTEX_OBJ_ENTITY.get()).m_20615_((Level)showcaseLevel);
        if (entity == null) {
            SlidersMod.LOGGER.error("Unable to create custom_showcase_vortex_obj entity.");
            return null;
        }
        entity.configure(variant, tint);
        if (forcedAnchor == null) {
            axisW = new Vec3(1.0, 0.0, 0.0);
            axisH = new Vec3(0.0, 1.0, 0.0);
            normal = new Vec3(0.0, 0.0, 1.0);
        } else {
            axisW = placement.axisW();
            axisH = placement.axisH();
            normal = placement.normal();
        }
        entity.configureOrientation(axisW, axisH, normal);
        entity.m_7678_(anchor.f_82479_, anchor.f_82480_, anchor.f_82481_, 0.0f, 0.0f);
        entity.m_20242_(true);
        entity.f_19794_ = true;
        showcaseLevel.m_7967_((Entity)entity);
        return entity;
    }

    public static ShowcasePreparation prepareShowcaseTarget(ServerLevel level, VortexPortalPlacement placement, CustomVortexVisuals.ModelVariant modelVariant, int tint) {
        if (!modelVariant.isCustom()) {
            return new ShowcasePreparation(modelVariant.defaultTexture().showcaseTarget(), null);
        }
        CustomShowcaseVortexObjEntity entity = VortexImmersivePortalHelper.spawnCustomShowcase(level, placement, modelVariant, tint, null);
        if (entity == null) {
            return new ShowcasePreparation(modelVariant.defaultTexture().showcaseTarget(), null);
        }
        VortexPortalTargets.ShowcaseTarget target = new VortexPortalTargets.ShowcaseTarget(VortexShowcaseManager.dimensionKey(), entity.m_20182_(), entity.getAxisW(), entity.getAxisH(), modelVariant.portalWidth(), modelVariant.portalHeight());
        return new ShowcasePreparation(target, entity.m_20148_());
    }

    public static Optional<Portal> spawnShowcasePortal(ServerLevel level, VortexPortalPlacement placement, VortexPortalTargets.ShowcaseTarget target, double initialSize, boolean visible) {
        Portal portal = (Portal)((EntityType)IPRegistry.PORTAL.get()).m_20615_((Level)level);
        if (portal == null) {
            SlidersMod.LOGGER.error("Unable to create Immersive Portal entity for vortex showcase.");
            return Optional.empty();
        }
        portal.portalTag = VORTEX_PORTAL_TAG;
        double scale = initialSize / 3.0;
        double width = target.width() * scale;
        double height = target.height() * scale;
        portal.setOriginPos(placement.center());
        portal.setOrientationAndSize(placement.axisW(), placement.axisH(), width, height);
        portal.setDestinationDimension(target.dimension());
        portal.setDestination(target.anchorCenter());
        portal.teleportable = false;
        portal.setInteractable(false);
        portal.setIsVisible(visible);
        portal.setScaleTransformation(0.9);
        VortexImmersivePortalHelper.applyCircularShape(portal, width, height);
        VortexImmersivePortalHelper.alignDestinationOrientation(portal, target.axisW(), target.axisH(), target.flipFacing());
        PortalAPI.spawnServerEntity((Entity)portal);
        VortexPortalTracker.register(level, portal);
        SlidersMod.LOGGER.debug("Spawned vortex Immersive Portal at {} looking towards {}", (Object)placement.center(), (Object)placement.normal());
        return Optional.of(portal);
    }

    public static Optional<UUID> spawnOgBorderDecoration(ServerLevel level, VortexPortalPlacement placement, @Nullable DecorationAppearance appearance) {
        OgVortexBorderObjEntity entity = (OgVortexBorderObjEntity)((EntityType)ModEntities.OG_VORTEX_BORDER_OBJ_ENTITY.get()).m_20615_((Level)level);
        if (entity == null) {
            SlidersMod.LOGGER.error("Unable to create og_vortex_border_obj entity.");
            return Optional.empty();
        }
        Vec3 center = placement.center();
        entity.m_7678_(center.f_82479_, center.f_82480_, center.f_82481_, 0.0f, 0.0f);
        entity.configureOrientation(placement.axisW(), placement.axisH(), placement.normal());
        entity.m_20242_(true);
        entity.f_19794_ = true;
        if (appearance != null) {
            entity.setCustomAppearance(appearance.textureId(), appearance.tint());
        }
        level.m_7967_((Entity)entity);
        return Optional.of(entity.m_20148_());
    }

    public static Optional<UUID> spawnLoganBorderDecoration(ServerLevel level, VortexPortalPlacement placement) {
        LoganVortexBorderObjEntity entity = (LoganVortexBorderObjEntity)((EntityType)ModEntities.LOGAN_VORTEX_BORDER_OBJ_ENTITY.get()).m_20615_((Level)level);
        if (entity == null) {
            SlidersMod.LOGGER.error("Unable to create logan_vortex_border_obj entity.");
            return Optional.empty();
        }
        Vec3 center = placement.center();
        entity.m_7678_(center.f_82479_, center.f_82480_, center.f_82481_, 0.0f, 0.0f);
        entity.configureOrientation(placement.axisW(), placement.axisH(), placement.normal());
        entity.m_20242_(true);
        entity.f_19794_ = true;
        level.m_7967_((Entity)entity);
        return Optional.of(entity.m_20148_());
    }

    public static Optional<UUID> spawnExodusBorderDecoration(ServerLevel level, VortexPortalPlacement placement, @Nullable DecorationAppearance appearance) {
        ExodusVortexBorderObjEntity entity = (ExodusVortexBorderObjEntity)((EntityType)ModEntities.EXODUS_VORTEX_BORDER_OBJ_ENTITY.get()).m_20615_((Level)level);
        if (entity == null) {
            SlidersMod.LOGGER.error("Unable to create exodus_vortex_border_obj entity.");
            return Optional.empty();
        }
        Vec3 center = placement.center();
        entity.m_7678_(center.f_82479_, center.f_82480_, center.f_82481_, 0.0f, 0.0f);
        entity.configureOrientation(placement.axisW(), placement.axisH(), placement.normal());
        if (appearance != null) {
            entity.setCustomAppearance(appearance.textureId(), appearance.tint());
        }
        entity.m_20242_(true);
        entity.f_19794_ = true;
        level.m_7967_((Entity)entity);
        return Optional.of(entity.m_20148_());
    }

    public static Optional<UUID> spawnEgyptianBorderDecoration(ServerLevel level, VortexPortalPlacement placement, @Nullable DecorationAppearance appearance) {
        EgyptianVortexBorderObjEntity entity = (EgyptianVortexBorderObjEntity)((EntityType)ModEntities.EGYPTIAN_VORTEX_BORDER_OBJ_ENTITY.get()).m_20615_((Level)level);
        if (entity == null) {
            SlidersMod.LOGGER.error("Unable to create egyptian_vortex_border_obj entity.");
            return Optional.empty();
        }
        Vec3 center = placement.center();
        entity.m_7678_(center.f_82479_, center.f_82480_, center.f_82481_, 0.0f, 0.0f);
        entity.configureOrientation(placement.axisW(), placement.axisH(), placement.normal());
        if (appearance != null) {
            entity.setCustomAppearance(appearance.textureId(), appearance.tint());
        }
        entity.m_20242_(true);
        entity.f_19794_ = true;
        level.m_7967_((Entity)entity);
        return Optional.of(entity.m_20148_());
    }

    public static Optional<UUID> spawnProtoBorderDecoration(ServerLevel level, VortexPortalPlacement placement) {
        ProtoVortexBorderObjEntity entity = (ProtoVortexBorderObjEntity)((EntityType)ModEntities.PROTO_VORTEX_BORDER_OBJ_ENTITY.get()).m_20615_((Level)level);
        if (entity == null) {
            SlidersMod.LOGGER.error("Unable to create proto_vortex_border_obj entity.");
            return Optional.empty();
        }
        Vec3 center = placement.center();
        entity.m_7678_(center.f_82479_, center.f_82480_, center.f_82481_, 0.0f, 0.0f);
        entity.configureOrientation(placement.axisW(), placement.axisH(), placement.normal());
        entity.m_20242_(true);
        entity.f_19794_ = true;
        level.m_7967_((Entity)entity);
        return Optional.of(entity.m_20148_());
    }

    public static Optional<UUID> spawnCollisionVolume(ServerLevel level, VortexPortalPlacement placement, VortexCollisionObjEntity.CollisionRole role, double normalOffset, float damage, float knockback, ResourceLocation modelId) {
        VortexCollisionObjEntity entity = (VortexCollisionObjEntity)((EntityType)ModEntities.VORTEX_COLLISION_OBJ_ENTITY.get()).m_20615_((Level)level);
        if (entity == null) {
            SlidersMod.LOGGER.error("Unable to create vortex_collision_obj entity.");
            return Optional.empty();
        }
        Vec3 normal = placement.normal().m_82541_();
        Vec3 center = placement.center().m_82549_(normal.m_82490_(normalOffset));
        entity.configurePlacement(center, placement.axisW(), placement.axisH(), placement.normal());
        entity.configureRole(role, damage, knockback);
        entity.setCollisionModel(modelId);
        entity.m_20242_(true);
        entity.f_19794_ = true;
        level.m_7967_((Entity)entity);
        return Optional.of(entity.m_20148_());
    }

    public static Optional<UUID> spawnOgBackDecoration(ServerLevel level, VortexPortalPlacement placement, double normalOffset, @Nullable DecorationAppearance appearance) {
        OgVortexBackObjEntity entity = (OgVortexBackObjEntity)((EntityType)ModEntities.OG_VORTEX_BACK_OBJ_ENTITY.get()).m_20615_((Level)level);
        if (entity == null) {
            SlidersMod.LOGGER.error("Unable to create og_vortex_back_obj entity.");
            return Optional.empty();
        }
        Vec3 normal = placement.normal().m_82541_();
        Vec3 center = placement.center().m_82549_(normal.m_82490_(normalOffset));
        entity.m_7678_(center.f_82479_, center.f_82480_, center.f_82481_, 0.0f, 0.0f);
        entity.configureOrientation(placement.axisW(), placement.axisH(), placement.normal());
        entity.setSpawnDelay(30);
        if (appearance != null) {
            entity.setCustomAppearance(appearance.textureId(), appearance.tint());
        }
        entity.m_20242_(true);
        entity.f_19794_ = true;
        level.m_7967_((Entity)entity);
        return Optional.of(entity.m_20148_());
    }

    public static Optional<UUID> spawnExodusBackDecoration(ServerLevel level, VortexPortalPlacement placement, double normalOffset, @Nullable DecorationAppearance appearance) {
        ExodusVortexBackObjEntity entity = (ExodusVortexBackObjEntity)((EntityType)ModEntities.EXODUS_VORTEX_BACK_OBJ_ENTITY.get()).m_20615_((Level)level);
        if (entity == null) {
            SlidersMod.LOGGER.error("Unable to create exodus_vortex_back_obj entity.");
            return Optional.empty();
        }
        Vec3 normal = placement.normal().m_82541_();
        Vec3 center = placement.center().m_82549_(normal.m_82490_(normalOffset));
        entity.m_7678_(center.f_82479_, center.f_82480_, center.f_82481_, 0.0f, 0.0f);
        entity.configureOrientation(placement.axisW(), placement.axisH(), placement.normal());
        entity.setSpawnDelay(30);
        if (appearance != null) {
            entity.setCustomAppearance(appearance.textureId(), appearance.tint());
        }
        entity.m_20242_(true);
        entity.f_19794_ = true;
        level.m_7967_((Entity)entity);
        return Optional.of(entity.m_20148_());
    }

    public static Optional<UUID> spawnEgyptianBackDecoration(ServerLevel level, VortexPortalPlacement placement, double normalOffset, @Nullable DecorationAppearance appearance) {
        EgyptianVortexBackObjEntity entity = (EgyptianVortexBackObjEntity)((EntityType)ModEntities.EGYPTIAN_VORTEX_BACK_OBJ_ENTITY.get()).m_20615_((Level)level);
        if (entity == null) {
            SlidersMod.LOGGER.error("Unable to create egyptian_vortex_back_obj entity.");
            return Optional.empty();
        }
        Vec3 normal = placement.normal().m_82541_();
        Vec3 center = placement.center().m_82549_(normal.m_82490_(normalOffset));
        entity.m_7678_(center.f_82479_, center.f_82480_, center.f_82481_, 0.0f, 0.0f);
        entity.configureOrientation(placement.axisW(), placement.axisH(), placement.normal());
        entity.setSpawnDelay(30);
        if (appearance != null) {
            entity.setCustomAppearance(appearance.textureId(), appearance.tint());
        }
        entity.m_20242_(true);
        entity.f_19794_ = true;
        level.m_7967_((Entity)entity);
        return Optional.of(entity.m_20148_());
    }

    public static void attachVisuals(ServerLevel level, VortexEntity vortex, VortexPortalPlacement placement, @Nullable UUID existingPortalId) {
        VortexPortalTargets.ShowcaseTarget target = VortexImmersivePortalHelper.resolveTarget(level, vortex, placement);
        vortex.rememberPortalTargetSize(target.width(), target.height());
        DecorationAppearance decorationAppearance = VortexImmersivePortalHelper.resolveDecorationAppearance(vortex);
        DecorationAppearance ogAppearance = decorationAppearance != null && decorationAppearance.variant() == CustomVortexVisuals.TextureVariant.CUSTOM_OG ? decorationAppearance : null;
        DecorationAppearance egyptianAppearance = decorationAppearance != null && decorationAppearance.variant() == CustomVortexVisuals.TextureVariant.CUSTOM_EGYPTIAN ? decorationAppearance : null;
        DecorationAppearance exodusAppearance = decorationAppearance != null && decorationAppearance.variant() == CustomVortexVisuals.TextureVariant.CUSTOM_EXODUS ? decorationAppearance : null;
        Vec3 center = placement.center();
        BlockPos lightAnchor = BlockPos.m_274561_((double)center.f_82479_, (double)Math.floor(center.f_82480_), (double)center.f_82481_);
        vortex.setLightAnchor(lightAnchor);
        UUID portalId = existingPortalId;
        vortex.reserveImmersivePortalVisual();
        Portal boundPortal = VortexImmersivePortalHelper.findPortal(level, existingPortalId);
        if (boundPortal == null) {
            boundPortal = VortexImmersivePortalHelper.spawnFullPortal(level, placement, target).orElse(null);
            portalId = boundPortal != null ? boundPortal.m_20148_() : null;
        }
        boolean attached = false;
        if (boundPortal != null && portalId != null) {
            VortexImmersivePortalHelper.setPortalVisibility(boundPortal, true);
            VortexImmersivePortalHelper.updatePortalSize(boundPortal, target, 3.0);
            vortex.bindImmersivePortal(portalId);
            attached = true;
        }
        if (!attached) {
            vortex.cancelImmersivePortalReservationIfUnbound();
        }
        boolean usesEgyptianStyle = vortex.isEgyptianVortex() || vortex.isProtoVortex();
        boolean isExodus = vortex.isExodusVortex();
        if (vortex.isLoganVortex()) {
            VortexImmersivePortalHelper.spawnLoganBorderDecoration(level, placement).ifPresent(vortex::bindDecoration);
        } else if (vortex.isProtoVortex()) {
            VortexImmersivePortalHelper.spawnProtoBorderDecoration(level, placement).ifPresent(vortex::bindDecoration);
        } else if (vortex.isEgyptianVortex()) {
            VortexImmersivePortalHelper.spawnEgyptianBorderDecoration(level, placement, egyptianAppearance).ifPresent(vortex::bindDecoration);
        } else if (isExodus) {
            VortexImmersivePortalHelper.spawnExodusBorderDecoration(level, placement, exodusAppearance).ifPresent(vortex::bindDecoration);
        } else {
            VortexImmersivePortalHelper.spawnOgBorderDecoration(level, placement, ogAppearance).ifPresent(vortex::bindDecoration);
        }
        if (vortex.wantsBackDecoration()) {
            double backOffset = 0.6;
            if (isExodus) {
                VortexImmersivePortalHelper.spawnExodusBackDecoration(level, placement, backOffset, exodusAppearance).ifPresent(vortex::bindBackDecoration);
            } else if (usesEgyptianStyle) {
                VortexImmersivePortalHelper.spawnEgyptianBackDecoration(level, placement, backOffset, egyptianAppearance).ifPresent(vortex::bindBackDecoration);
            } else {
                VortexImmersivePortalHelper.spawnOgBackDecoration(level, placement, backOffset, ogAppearance).ifPresent(vortex::bindBackDecoration);
            }
        } else {
            vortex.bindBackDecoration(null);
        }
        if (vortex.wantsFrontCollisionVolume()) {
            ResourceLocation model = usesEgyptianStyle ? EGYPTIAN_COLLISION_MODEL : OG_COLLISION_MODEL;
            VortexImmersivePortalHelper.spawnCollisionVolume(level, placement, VortexCollisionObjEntity.CollisionRole.FRONT, 0.0, 0.0f, 0.0f, model).ifPresent(vortex::bindCollisionVolume);
        } else {
            vortex.bindCollisionVolume(null);
        }
        if (vortex.wantsBackCollisionVolume()) {
            ResourceLocation model = usesEgyptianStyle ? EGYPTIAN_COLLISION_MODEL : OG_COLLISION_MODEL;
            VortexImmersivePortalHelper.spawnCollisionVolume(level, placement, VortexCollisionObjEntity.CollisionRole.BACK, 0.25, 6.0f, 0.7f, model).ifPresent(vortex::bindBackCollisionVolume);
        } else {
            vortex.bindBackCollisionVolume(null);
        }
    }

    private static VortexPortalTargets.ShowcaseTarget resolveTarget(ServerLevel vortexLevel, VortexEntity vortex, VortexPortalPlacement placement) {
        CustomVortexVisuals.ModelVariant modelVariant;
        String customModelId = vortex.getCustomModelId();
        if (customModelId != null && !customModelId.isEmpty() && (modelVariant = CustomVortexVisuals.ModelVariant.byId(customModelId)).isCustom()) {
            return VortexImmersivePortalHelper.createCustomShowcaseTarget(vortexLevel, vortex, placement, modelVariant);
        }
        String customTextureId = vortex.getCustomTextureId();
        if (customTextureId != null && !customTextureId.isEmpty()) {
            return CustomVortexVisuals.TextureVariant.byId(customTextureId).showcaseTarget();
        }
        if (vortex.isLoganVortex()) {
            return VortexPortalTargets.LOGAN;
        }
        if (vortex.isProtoVortex()) {
            return VortexPortalTargets.PROTO;
        }
        if (vortex.isExodusVortex()) {
            return VortexPortalTargets.EXODUS;
        }
        if (vortex.isEgyptianVortex()) {
            return VortexPortalTargets.EGYPTIAN;
        }
        return VortexPortalTargets.ORIGINAL;
    }

    private static VortexPortalTargets.ShowcaseTarget createCustomShowcaseTarget(ServerLevel vortexLevel, VortexEntity vortex, VortexPortalPlacement placement, CustomVortexVisuals.ModelVariant variant) {
        Entity existing;
        ServerLevel showcase = vortexLevel.m_7654_().m_129880_(VortexShowcaseManager.dimensionKey());
        if (showcase == null) {
            SlidersMod.LOGGER.error("Unable to access vortex showcase dimension for custom tunnel.");
            return variant.defaultTexture().showcaseTarget();
        }
        CustomShowcaseVortexObjEntity entity = null;
        UUID customId = vortex.getCustomShowcaseEntityId();
        if (customId != null && (existing = showcase.m_8791_(customId)) instanceof CustomShowcaseVortexObjEntity) {
            CustomShowcaseVortexObjEntity customEntity;
            entity = customEntity = (CustomShowcaseVortexObjEntity)existing;
        }
        if (entity == null) {
            entity = VortexImmersivePortalHelper.spawnCustomShowcase(vortexLevel, placement, variant, vortex.getCustomTint(), null);
            if (entity == null) {
                return variant.defaultTexture().showcaseTarget();
            }
            vortex.bindCustomShowcase(entity.m_20148_());
        } else {
            entity.configure(variant, vortex.getCustomTint());
            entity.configureOrientation(CUSTOM_SHOWCASE_AXIS_W, CUSTOM_SHOWCASE_AXIS_H, CUSTOM_SHOWCASE_NORMAL);
        }
        Vec3 placementNormal = placement.normal();
        Vec3 horizontalNormal = new Vec3(placementNormal.f_82479_, 0.0, placementNormal.f_82481_);
        boolean flipFacing = horizontalNormal.m_82556_() > 1.0E-4 && horizontalNormal.m_82541_().m_82526_(CUSTOM_SHOWCASE_NORMAL) < 0.0;
        return new VortexPortalTargets.ShowcaseTarget(VortexShowcaseManager.dimensionKey(), entity.m_20182_(), entity.getAxisW(), entity.getAxisH(), variant.portalWidth(), variant.portalHeight(), flipFacing);
    }

    public static Portal findPortal(ServerLevel level, @Nullable UUID portalId) {
        if (portalId == null) {
            return null;
        }
        Entity entity = level.m_8791_(portalId);
        if (entity instanceof Portal) {
            Portal portal = (Portal)entity;
            return portal;
        }
        return null;
    }

    private static void applyCircularShape(Portal portal, double width, double height) {
        GeometryPortalShape shape = new GeometryPortalShape();
        ArrayList<GeometryPortalShape.TriangleInPlane> triangles = new ArrayList<GeometryPortalShape.TriangleInPlane>(40);
        double twoPi = Math.PI * 2;
        double halfWidth = width * 0.5;
        double halfHeight = height * 0.5;
        for (int i = 0; i < 40; ++i) {
            double angleA = twoPi * (double)i / 40.0;
            double angleB = twoPi * (double)(i + 1) / 40.0;
            triangles.add(new GeometryPortalShape.TriangleInPlane(0.0, 0.0, Math.cos(angleA) * halfWidth, Math.sin(angleA) * halfHeight, Math.cos(angleB) * halfWidth, Math.sin(angleB) * halfHeight));
        }
        shape.triangles = triangles;
        shape.normalize(width, height);
        portal.specialShape = shape;
        portal.cullableXStart = 0.0;
        portal.cullableXEnd = 0.0;
        portal.cullableYStart = 0.0;
        portal.cullableYEnd = 0.0;
    }

    private static void alignDestinationOrientation(Portal portal, Vec3 targetAxisW, Vec3 targetAxisH, boolean flipFacing) {
        DQuaternion thisSideOrientation = PortalAPI.getPortalOrientationQuaternion((Portal)portal);
        DQuaternion targetOrientation = PortalManipulation.getPortalOrientationQuaternion((Vec3)targetAxisW.m_82541_(), (Vec3)targetAxisH.m_82541_());
        if (flipFacing) {
            targetOrientation = targetOrientation.hamiltonProduct(FLIP_AXIS_W);
        }
        DQuaternion delta = VortexImmersivePortalHelper.computeDeltaTransformation(thisSideOrientation, targetOrientation);
        portal.setRotationTransformationD(delta);
    }

    private static DQuaternion computeDeltaTransformation(DQuaternion thisSide, DQuaternion otherSide) {
        return otherSide.hamiltonProduct(FLIP_AXIS_W).hamiltonProduct(thisSide.getConjugated());
    }

    public static void updatePortalSize(Portal portal, VortexPortalTargets.ShowcaseTarget target, double size) {
        double scale = size / 3.0;
        double width = target.width() * scale;
        double height = target.height() * scale;
        portal.setWidth(width);
        portal.setHeight(height);
        VortexImmersivePortalHelper.applyCircularShape(portal, width, height);
        portal.reloadAndSyncToClientNextTick();
    }

    public static void updatePortalSize(VortexEntity vortex, Portal portal, double size) {
        double scale = size / 3.0;
        double width = vortex.getPortalTargetWidth() * scale;
        double height = vortex.getPortalTargetHeight() * scale;
        portal.setWidth(width);
        portal.setHeight(height);
        VortexImmersivePortalHelper.applyCircularShape(portal, width, height);
        portal.reloadAndSyncToClientNextTick();
    }

    public static void setPortalVisibility(Portal portal, boolean visible) {
        portal.setIsVisible(visible);
        portal.reloadAndSyncToClientNextTick();
    }

    public static void cleanupResidualPortals(ServerLevel level, Vec3 center, double radius, double maxSize) {
        if (radius <= 0.0 || maxSize <= 0.0) {
            return;
        }
        AABB box = new AABB(center.f_82479_ - radius, center.f_82480_ - radius, center.f_82481_ - radius, center.f_82479_ + radius, center.f_82480_ + radius, center.f_82481_ + radius);
        List portals = level.m_45976_(Portal.class, box);
        for (Portal portal : portals) {
            if (portal.portalTag == null || !portal.portalTag.equals(VORTEX_PORTAL_TAG)) continue;
            double width = portal.width;
            double height = portal.height;
            if (portal.isVisible() && !(width <= maxSize) && !(height <= maxSize)) continue;
            portal.m_146870_();
        }
    }

    public static void cleanupOrphanedPortals(ServerLevel level, double scanRadius, double vortexRadius) {
        if (scanRadius <= 0.0 || vortexRadius <= 0.0 || level.m_6907_().isEmpty()) {
            return;
        }
        double clampedScan = Math.min(scanRadius, 96.0);
        for (Player player : level.m_6907_()) {
            AABB scan = player.m_20191_().m_82400_(clampedScan);
            List portals = level.m_45976_(Portal.class, scan);
            if (portals.isEmpty()) continue;
            for (Portal portal : portals) {
                boolean hasNearbyVortex;
                if (portal.portalTag == null || !portal.portalTag.equals(VORTEX_PORTAL_TAG)) continue;
                boolean bl = hasNearbyVortex = !level.m_45976_(VortexEntity.class, portal.m_20191_().m_82400_(vortexRadius)).isEmpty();
                if (portal.isVisible() && hasNearbyVortex) continue;
                portal.m_146870_();
            }
        }
    }

    private record DecorationAppearance(CustomVortexVisuals.TextureVariant variant, String textureId, int tint) {
    }

    public record ShowcasePreparation(VortexPortalTargets.ShowcaseTarget target, @Nullable UUID customEntityId) {
    }
}

