/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.screen;

import com.michelmuscle.slidersmod.item.EgyptianTimerDamagedItem;
import com.michelmuscle.slidersmod.item.ExodusTimerDamagedItem;
import com.michelmuscle.slidersmod.item.LoganTimerDamagedItem;
import com.michelmuscle.slidersmod.item.OriginalTimerDamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier1DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier2DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier3DamagedItem;
import com.michelmuscle.slidersmod.network.DamagedUpgradedLoganCoordsPacket;
import com.michelmuscle.slidersmod.network.ModNetworking;
import com.michelmuscle.slidersmod.network.TrackVortexPacket;
import com.michelmuscle.slidersmod.screen.component.PortalStabilityUi;
import com.michelmuscle.slidersmod.util.TimerUpgradeData;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.BiConsumer;
import java.util.function.ToIntFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DamagedTimerScreen
extends Screen {
    private static final int GUI_WIDTH = 280;
    private static final int GUI_HEIGHT = 220;
    private static final int TRACK_ACTION_COOLDOWN_TICKS = 100;
    private final ItemStack timerStack;
    private int guiLeft;
    private int guiTop;
    private long remainingTime;
    private int tickCounter;
    private final boolean isEgyptianTimer;
    private int trackingMode;
    private final boolean isUpgradedLoganTimer;
    private final int upgradedPrecisionRange;
    private final ToIntFunction<ItemStack> upgradedXGetter;
    private final ToIntFunction<ItemStack> upgradedZGetter;
    private final BiConsumer<ItemStack, Integer> upgradedXSetter;
    private final BiConsumer<ItemStack, Integer> upgradedZSetter;
    private EditBox xInput;
    private EditBox zInput;
    private Button egyptianTrackButton;
    private Button egyptianTrackActionButton;
    private final boolean hasTrackerUpgrade;
    private int trackActionCooldownTicks;

    public DamagedTimerScreen(ItemStack timerStack) {
        super((Component)Component.m_237113_((String)"Damaged Timer"));
        this.timerStack = timerStack;
        this.isEgyptianTimer = timerStack.m_41720_() instanceof EgyptianTimerDamagedItem;
        this.hasTrackerUpgrade = TimerUpgradeData.hasTrackerUpgrade(timerStack);
        UpgradedHooks hooks = this.detectUpgradedHooks(timerStack);
        boolean bl = this.isUpgradedLoganTimer = hooks != null;
        if (hooks != null) {
            this.upgradedPrecisionRange = hooks.precision;
            this.upgradedXGetter = hooks.xGetter;
            this.upgradedZGetter = hooks.zGetter;
            this.upgradedXSetter = hooks.xSetter;
            this.upgradedZSetter = hooks.zSetter;
        } else {
            this.upgradedPrecisionRange = 0;
            this.upgradedXGetter = null;
            this.upgradedZGetter = null;
            this.upgradedXSetter = null;
            this.upgradedZSetter = null;
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - 280) / 2;
        this.guiTop = (this.f_96544_ - 220) / 2;
        CompoundTag tag = this.timerStack.m_41784_();
        this.trackingMode = tag.m_128451_("TrackingMode");
        if (this.isEgyptianTimer) {
            Button randomButton = Button.m_253074_((Component)this.componentWithHighlight("Random Jump", this.trackingMode == 0), b -> this.setTrackingMode(0)).m_252987_(this.guiLeft + 20, this.guiTop + 140, 110, 20).m_253136_();
            Button trackButton = Button.m_253074_((Component)this.componentWithHighlight("Track Vortex", this.trackingMode == 1), b -> this.setTrackingMode(1)).m_252987_(this.guiLeft + 150, this.guiTop + 140, 110, 20).m_253136_();
            trackButton.f_93623_ = this.hasTrackerUpgrade;
            this.m_142416_((GuiEventListener)randomButton);
            this.m_142416_((GuiEventListener)trackButton);
            this.egyptianTrackButton = trackButton;
            if (this.trackingMode == 1 && this.hasTrackerUpgrade) {
                this.egyptianTrackActionButton = Button.m_253074_((Component)Component.m_237113_((String)"Track"), this::onTrackPressed).m_252987_(this.guiLeft + 150, this.guiTop + 165, 110, 20).m_253136_();
                this.egyptianTrackActionButton.f_93623_ = this.trackActionCooldownTicks <= 0;
                this.m_142416_((GuiEventListener)this.egyptianTrackActionButton);
            }
        }
        Button closeButton = Button.m_253074_((Component)Component.m_237113_((String)"Close"), b -> this.m_7379_()).m_252987_(this.guiLeft + 90, this.guiTop + 220 - 35, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)closeButton);
        if (this.isUpgradedLoganTimer) {
            this.addUpgradedCoordinateInputs();
        }
        this.addPortalStabilityControls();
        this.updateRemainingTime();
    }

    private void addPortalStabilityControls() {
        if (!PortalStabilityUi.shouldShow(this.timerStack)) {
            return;
        }
        int width = 240;
        int x = this.guiLeft + 20;
        int baseY = this.guiTop + 60;
        this.m_142416_((GuiEventListener)PortalStabilityUi.createPortalButton(this.timerStack, x, baseY, width));
        this.m_142416_((GuiEventListener)PortalStabilityUi.createReturnButton(this.timerStack, x, baseY + 24, width));
    }

    private Component componentWithHighlight(String base, boolean active) {
        return active ? Component.m_237113_((String)("\u00a7a\u00a7o" + base)) : Component.m_237113_((String)base);
    }

    private void setTrackingMode(int mode) {
        if (mode == 1 && !this.hasTrackerUpgrade) {
            if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                this.f_96541_.f_91074_.m_5661_((Component)Component.m_237113_((String)"Tracker upgrade required!").m_130940_(ChatFormatting.RED), true);
            }
            return;
        }
        this.trackingMode = mode;
        CompoundTag tag = this.timerStack.m_41784_();
        tag.m_128405_("TrackingMode", mode);
        this.m_7856_();
    }

    public void m_86600_() {
        super.m_86600_();
        CompoundTag tag = this.timerStack.m_41784_();
        if (!tag.m_128441_("ActivationTime")) {
            this.m_7379_();
            return;
        }
        if (this.trackActionCooldownTicks > 0) {
            --this.trackActionCooldownTicks;
            if (this.trackActionCooldownTicks <= 0 && this.egyptianTrackActionButton != null) {
                this.egyptianTrackActionButton.f_93623_ = this.hasTrackerUpgrade;
            }
        }
        ++this.tickCounter;
        if (this.tickCounter >= 20) {
            this.tickCounter = 0;
            this.updateRemainingTime();
        }
    }

    private void updateRemainingTime() {
        this.remainingTime = this.timerStack.m_41720_() instanceof EgyptianTimerDamagedItem ? EgyptianTimerDamagedItem.getRemainingTime(this.timerStack, (Level)this.f_96541_.f_91073_) : (this.timerStack.m_41720_() instanceof LoganTimerDamagedItem ? LoganTimerDamagedItem.getRemainingTime(this.timerStack, (Level)this.f_96541_.f_91073_) : (this.timerStack.m_41720_() instanceof UpgradedLoganTimerTier1DamagedItem ? UpgradedLoganTimerTier1DamagedItem.getRemainingTime(this.timerStack, (Level)this.f_96541_.f_91073_) : (this.timerStack.m_41720_() instanceof UpgradedLoganTimerTier2DamagedItem ? UpgradedLoganTimerTier2DamagedItem.getRemainingTime(this.timerStack, (Level)this.f_96541_.f_91073_) : (this.timerStack.m_41720_() instanceof UpgradedLoganTimerTier3DamagedItem ? UpgradedLoganTimerTier3DamagedItem.getRemainingTime(this.timerStack, (Level)this.f_96541_.f_91073_) : (this.timerStack.m_41720_() instanceof ExodusTimerDamagedItem ? ExodusTimerDamagedItem.getRemainingTime(this.timerStack, (Level)this.f_96541_.f_91073_) : OriginalTimerDamagedItem.getRemainingTime(this.timerStack, (Level)this.f_96541_.f_91073_))))));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.m_280509_(this.guiLeft, this.guiTop, this.guiLeft + 280, this.guiTop + 220, -872415232);
        graphics.m_280509_(this.guiLeft + 2, this.guiTop + 2, this.guiLeft + 280 - 2, this.guiTop + 220 - 2, -13948117);
        graphics.m_280137_(this.f_96547_, "\u00a7c\u00a7o DAMAGED TIMER", this.guiLeft + 140, this.guiTop + 10, 0xFFFFFF);
        if (this.isEgyptianTimer) {
            String modeText = this.trackingMode == 1 ? "?5?o Track a vortex" : "?7Random jumps";
            graphics.m_280137_(this.f_96547_, modeText, this.guiLeft + 140, this.guiTop + 30, 0xAAAAAA);
            if (this.trackingMode == 1) {
                Object status;
                if (!this.hasTrackerUpgrade) {
                    status = "Tracker upgrade required";
                } else if (this.trackActionCooldownTicks > 0) {
                    int seconds = (this.trackActionCooldownTicks + 19) / 20;
                    status = "Searching... " + seconds + "s";
                } else {
                    status = "Ready to scan";
                }
                graphics.m_280137_(this.f_96547_, "?7" + (String)status, this.guiLeft + 140, this.guiTop + 45, 0xDDDDDD);
            }
        } else if (this.isUpgradedLoganTimer) {
            graphics.m_280137_(this.f_96547_, "?7Target precision: ?" + this.upgradedPrecisionRange + " blocks", this.guiLeft + 140, this.guiTop + 30, 0xAAAAAA);
        } else {
            graphics.m_280137_(this.f_96547_, "?7Random jumps - Cannot configure", this.guiLeft + 140, this.guiTop + 30, 0xAAAAAA);
        }
        graphics.m_280137_(this.f_96547_, "REMAINING TIME", this.guiLeft + 140, this.guiTop + 60, 0xCCCCCC);
        graphics.m_280137_(this.f_96547_, this.formatTimeDisplay(this.remainingTime / 20L), this.guiLeft + 140, this.guiTop + 85, 0xFFFFFF);
        long seconds = this.remainingTime / 20L;
        MutableComponent hint = seconds <= 3L && seconds > 0L ? Component.m_237113_((String)"\u00a7e\u00a7o LEFT-CLICK NOW TO OPEN VORTEX!") : (seconds <= 30L ? Component.m_237113_((String)"\u00a77Wait for the last 3 seconds...") : Component.m_237113_((String)"\u00a77Wait until remaining time   3 seconds"));
        graphics.m_280137_(this.f_96547_, hint.getString(), this.guiLeft + 140, this.guiTop + 115, 0xFFFFFF);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    private void onTrackPressed(Button button) {
        if (!this.hasTrackerUpgrade) {
            return;
        }
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            return;
        }
        button.f_93623_ = false;
        this.trackActionCooldownTicks = 100;
        this.f_96541_.f_91074_.m_5661_((Component)Component.m_237113_((String)"Searching for vortex...").m_130940_(ChatFormatting.GOLD), true);
        ModNetworking.CHANNEL.sendToServer((Object)new TrackVortexPacket());
    }

    private void addUpgradedCoordinateInputs() {
        this.xInput = new EditBox(this.f_96547_, this.guiLeft + 20, this.guiTop + 140, 90, 18, (Component)Component.m_237113_((String)"X"));
        this.zInput = new EditBox(this.f_96547_, this.guiLeft + 130, this.guiTop + 140, 90, 18, (Component)Component.m_237113_((String)"Z"));
        this.xInput.m_94153_(this::validateCoordinateInput);
        this.zInput.m_94153_(this::validateCoordinateInput);
        this.xInput.m_94144_(String.valueOf(this.upgradedXGetter.applyAsInt(this.timerStack)));
        this.zInput.m_94144_(String.valueOf(this.upgradedZGetter.applyAsInt(this.timerStack)));
        this.m_142416_((GuiEventListener)this.xInput);
        this.m_142416_((GuiEventListener)this.zInput);
        Button applyButton = Button.m_253074_((Component)Component.m_237113_((String)"Apply X/Z"), this::onApplyCoords).m_252987_(this.guiLeft + 20, this.guiTop + 170, 200, 20).m_253136_();
        this.m_142416_((GuiEventListener)applyButton);
    }

    private boolean validateCoordinateInput(String value) {
        return value.isEmpty() || value.matches("-?[0-9]{0,7}");
    }

    private void onApplyCoords(Button button) {
        block4: {
            if (!this.isUpgradedLoganTimer) {
                return;
            }
            try {
                int newX = Integer.parseInt(this.xInput.m_94155_().trim());
                int newZ = Integer.parseInt(this.zInput.m_94155_().trim());
                this.upgradedXSetter.accept(this.timerStack, newX);
                this.upgradedZSetter.accept(this.timerStack, newZ);
                ModNetworking.CHANNEL.sendToServer((Object)new DamagedUpgradedLoganCoordsPacket(newX, newZ));
                Minecraft playerClient = Minecraft.m_91087_();
                if (playerClient.f_91074_ != null) {
                    playerClient.f_91074_.m_5661_((Component)Component.m_237113_((String)("\u00a7aTarget updated: X=" + newX + " Z=" + newZ)), true);
                }
            }
            catch (NumberFormatException ex) {
                Minecraft playerClient = Minecraft.m_91087_();
                if (playerClient.f_91074_ == null) break block4;
                playerClient.f_91074_.m_5661_((Component)Component.m_237113_((String)"\u00a7cInvalid coordinates."), true);
            }
        }
    }

    private String formatTimeDisplay(long totalSeconds) {
        long hours = totalSeconds / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        return String.format("\u00a7e%02d:%02d:%02d", hours, minutes, seconds);
    }

    public boolean m_7043_() {
        return false;
    }

    private UpgradedHooks detectUpgradedHooks(ItemStack stack) {
        if (stack.m_41720_() instanceof UpgradedLoganTimerTier1DamagedItem) {
            return new UpgradedHooks(UpgradedLoganTimerTier1DamagedItem::getConfiguredX, UpgradedLoganTimerTier1DamagedItem::getConfiguredZ, UpgradedLoganTimerTier1DamagedItem::setConfiguredX, UpgradedLoganTimerTier1DamagedItem::setConfiguredZ, UpgradedLoganTimerTier1DamagedItem.getPrecisionRange());
        }
        if (stack.m_41720_() instanceof UpgradedLoganTimerTier2DamagedItem) {
            return new UpgradedHooks(UpgradedLoganTimerTier2DamagedItem::getConfiguredX, UpgradedLoganTimerTier2DamagedItem::getConfiguredZ, UpgradedLoganTimerTier2DamagedItem::setConfiguredX, UpgradedLoganTimerTier2DamagedItem::setConfiguredZ, UpgradedLoganTimerTier2DamagedItem.getPrecisionRange());
        }
        if (stack.m_41720_() instanceof UpgradedLoganTimerTier3DamagedItem) {
            return new UpgradedHooks(UpgradedLoganTimerTier3DamagedItem::getConfiguredX, UpgradedLoganTimerTier3DamagedItem::getConfiguredZ, UpgradedLoganTimerTier3DamagedItem::setConfiguredX, UpgradedLoganTimerTier3DamagedItem::setConfiguredZ, UpgradedLoganTimerTier3DamagedItem.getPrecisionRange());
        }
        return null;
    }

    private record UpgradedHooks(ToIntFunction<ItemStack> xGetter, ToIntFunction<ItemStack> zGetter, BiConsumer<ItemStack, Integer> xSetter, BiConsumer<ItemStack, Integer> zSetter, int precision) {
    }
}

