/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.screen;

import com.michelmuscle.slidersmod.gui.EnergyBarRenderer;
import com.michelmuscle.slidersmod.gui.ProgressArrowRenderer;
import com.michelmuscle.slidersmod.init.ModItems;
import com.michelmuscle.slidersmod.menu.ResearchTableMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ResearchTableScreen
extends AbstractContainerScreen<ResearchTableMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("slidersmod", "textures/gui/research_table.png");
    private static final int GUI_W = 176;
    private static final int GUI_H = 166;

    public ResearchTableScreen(ResearchTableMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.f_97726_ = 176;
        this.f_97727_ = 166;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = 8;
        this.f_97729_ = 6;
        this.f_97730_ = 8;
        this.f_97731_ = this.f_97727_ - 92;
    }

    protected void m_7286_(GuiGraphics g, float partialTick, int mouseX, int mouseY) {
        int color;
        String status;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        g.m_280163_(TEXTURE, this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 256, 256);
        this.renderInputOverlay(g, this.f_97735_, this.f_97736_);
        int maxProg = Math.max(((ResearchTableMenu)this.f_97732_).getMaxProgress(), 1);
        int curProg = Mth.m_14045_((int)((ResearchTableMenu)this.f_97732_).getProgress(), (int)0, (int)maxProg);
        int progress = (int)((float)curProg * 100.0f / (float)maxProg);
        ProgressArrowRenderer.renderProgressArrow(g, this.f_97735_ + 76, this.f_97736_ + 38, progress);
        int sx = this.f_97735_ + 67;
        int sy = this.f_97736_ + 59;
        int sw = 52;
        int sh = 14;
        int state = ((ResearchTableMenu)this.f_97732_).getStateOrdinal();
        if (state == 1) {
            status = "Researching...";
            long ticks = this.f_96541_ != null && this.f_96541_.f_91073_ != null ? this.f_96541_.f_91073_.m_46467_() : System.currentTimeMillis() / 50L;
            color = ticks / 10L % 2L == 0L ? 0x55FF55 : 0xFFFFFF;
        } else if (state == 2) {
            status = "Success !";
            color = 65280;
        } else if (state == 3) {
            status = "Research failed !";
            color = 0xFF5555;
        } else {
            status = "Pending...";
            color = 0xAAAAAA;
        }
        int tx = sx + Math.max(0, (sw - this.f_96547_.m_92895_(status)) / 2);
        int ty = sy + Math.max(0, (sh - 9) / 2);
        g.m_280056_(this.f_96547_, status, tx, ty, color, false);
        int eMax = Math.max(((ResearchTableMenu)this.f_97732_).getMaxEnergyStored(), 1);
        int eCur = Mth.m_14045_((int)((ResearchTableMenu)this.f_97732_).getEnergyStored(), (int)0, (int)eMax);
        int energyPercent = eMax > 0 ? eCur * 100 / eMax : 0;
        EnergyBarRenderer.renderEnergyBar(g, this.f_97735_ + 12, this.f_97736_ + 18, energyPercent);
    }

    private void renderInputOverlay(GuiGraphics g, int x, int y) {
        ItemStack chip = new ItemStack((ItemLike)ModItems.SLIDE_ENHANCEMENT_CHIP.get());
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.35f);
        g.m_280203_(chip, x + 43, y + 34);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    protected void m_280003_(GuiGraphics g, int mouseX, int mouseY) {
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float delta) {
        this.m_280273_(g);
        super.m_88315_(g, mouseX, mouseY, delta);
        this.m_280072_(g, mouseX, mouseY);
    }

    protected void m_280072_(GuiGraphics g, int mouseX, int mouseY) {
        super.m_280072_(g, mouseX, mouseY);
        int x1 = this.f_97735_ + 12;
        int yTop = this.f_97736_ + 18;
        int yBot = this.f_97736_ + 68;
        if (mouseX >= x1 && mouseX <= x1 + 8 && mouseY >= yTop && mouseY <= yBot) {
            MutableComponent tooltip = Component.m_237113_((String)(((ResearchTableMenu)this.f_97732_).getEnergyStored() + " / " + ((ResearchTableMenu)this.f_97732_).getMaxEnergyStored() + " FE"));
            g.m_280557_(this.f_96547_, (Component)tooltip, mouseX, mouseY);
        }
    }
}

